/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.visualisation.MicroarrayTable;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.Table;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.table.DefaultTableModel;

public class Spreadsheet
extends Visualisation {
    private static final int MARGIN = 30;
    private final int COLUMNS_REQUIRES_SCROLLING = 8;
    private MicroarrayTable table;

    public JComponent getVisualisation(DataBean data, Dimension size) throws Exception {
        JPanel panel = new JPanel(new BorderLayout());
        Dimension tableSize = size;
        tableSize.setSize(tableSize.getWidth() - 30.0, tableSize.getHeight() - 30.0);
        Table rowCounter = data.fetchFeature("/column/*").asTable();
        int rowCount = 0;
        while (rowCounter.nextRow()) {
            ++rowCount;
        }
        Table columns = data.fetchFeature("restrict(/column/*)").asTable();
        Object[] columnTitles = new String[columns.getCount()];
        int counter = 0;
        String[] arr$ = columns.getColumnNames();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String column;
            columnTitles[counter] = column = arr$[i$];
            ++counter;
        }
        Object[][] rowData = new Object[2000 < rowCount ? 2000 : rowCount][columns.getCount()];
        int row = 0;
        while (columns.nextRow()) {
            int column = 0;
            for (String columnName : columns.getColumnNames()) {
                rowData[row][column] = columns.getValue(columnName);
                ++column;
            }
            ++row;
        }
        this.table = new MicroarrayTable();
        DefaultTableModel tableModel = new DefaultTableModel(rowData, columnTitles){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.table.setModel(tableModel);
        this.table.setColumnControlVisible(true);
        JScrollPane tableScroller = new JScrollPane((Component)((Object)this.table));
        this.table.setBackground(Color.white);
        this.table.setPreferredScrollableViewportSize(tableSize);
        this.table.setSelectionMode(1);
        this.table.setHorizontalScrollEnabled(columns.getCount() > 8);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    SpreadsheetPopupMenu popup = new SpreadsheetPopupMenu(Spreadsheet.this.table);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        panel.add((Component)new JLabel("Showing " + rowData.length + " rows of " + rowCount), "North");
        panel.add((Component)tableScroller, "Center");
        return panel;
    }

    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        if (bean.isContentTypeCompatitible("text/tab", "text/csv")) {
            return true;
        }
        if (bean.isContentTypeCompatitible("application/cel")) {
            return !bean.fetchFeature("/embedded-binary-content/").exists();
        }
        return false;
    }

    public class SpreadsheetPopupMenu
    extends JPopupMenu
    implements ActionListener {
        private MicroarrayTable table;
        private JMenuItem annotateMenuItem;
        private JMenuItem copyMenuItem;

        public SpreadsheetPopupMenu(MicroarrayTable table) {
            this.table = table;
            this.copyMenuItem = new JMenuItem("Copy");
            this.annotateMenuItem = new JMenuItem("Annotate using GeneCruiser...");
            this.copyMenuItem.addActionListener(this);
            this.annotateMenuItem.addActionListener(this);
            this.add(this.copyMenuItem);
            this.add(new JSeparator());
            this.add(this.annotateMenuItem);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.annotateMenuItem) {
                int rowIndexStart = this.table.getSelectedRow();
                int rowIndexEnd = this.table.getSelectionModel().getMaxSelectionIndex();
                int colIndexStart = this.table.getSelectedColumn();
                int colIndexEnd = this.table.getColumnModel().getSelectionModel().getMaxSelectionIndex();
                LinkedList<String> probesets = new LinkedList<String>();
                for (int row = rowIndexStart; row <= rowIndexEnd; ++row) {
                    for (int column = colIndexStart; column <= colIndexEnd; ++column) {
                        if (!this.table.isCellSelected(row, column)) continue;
                        probesets.add(this.table.getValueAt(row, column).toString());
                    }
                }
                Session.getSession().getApplication().annotate(probesets);
            }
            if (e.getSource() == this.copyMenuItem) {
                this.table.copy();
            }
        }
    }
}

