/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.ErrorReportAsException;
import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.cluster.ClusterBranchNode;
import fi.csc.microarray.cluster.ClusterLeafNode;
import fi.csc.microarray.cluster.ClusterNode;
import fi.csc.microarray.cluster.ClusterParser;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.Table;
import java.awt.Color;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;
import org.jfree.chart.BioChartFactory;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.HCToolTipGenerator;
import org.jfree.chart.labels.StandardHCToolTipGenerator;
import org.jfree.chart.plot.GradientColorPalette;
import org.jfree.chart.plot.HCPlot;
import org.jfree.data.hc.DataRange;
import org.jfree.data.hc.DataRangeMismatchException;
import org.jfree.data.hc.HCDataset;
import org.jfree.data.hc.HCTreeNode;
import org.jfree.data.hc.HeatMap;

public class HierarchicalClustering
extends Visualisation {
    private static final Logger logger = Logger.getLogger(HierarchicalClustering.class);
    private Map<String, Integer> orderMap = new HashMap<String, Integer>();

    public JComponent getVisualisation(DataBean data, Dimension size) throws MicroarrayException {
        try {
            int i;
            Table heatMapData = null;
            String hcTree = data.fetchFeature("/clusters/hierarchical/tree").asStrings().iterator().next();
            heatMapData = data.fetchFeature("/clusters/hierarchical/heatmap").asTable();
            int rowCount = 0;
            while (heatMapData.nextRow()) {
                ++rowCount;
            }
            LinkedList<String> columns = new LinkedList<String>();
            for (String columnName : heatMapData.getColumnNames()) {
                if (columnName.startsWith("chip.")) {
                    columns.add(columnName);
                    continue;
                }
                logger.debug((Object)("Column skipped in HC: " + columnName));
            }
            int columnCount = columns.size();
            boolean reversed = hcTree.contains("chip.");
            HeatMap heatMap = null;
            heatMap = !reversed ? new HeatMap("Heatmap", rowCount, columnCount) : new HeatMap("Heatmap", columnCount, rowCount);
            HCTreeNode root = null;
            ClusterParser parser = new ClusterParser(hcTree);
            ClusterBranchNode tree = parser.getTree();
            int initialHeight = this.getTreeHeight(tree);
            this.orderMap.clear();
            root = this.readTree(tree, 0, initialHeight);
            heatMapData = data.fetchFeature("/clusters/hierarchical/heatmap").asTable();
            int row = -1;
            while (heatMapData.nextRow()) {
                if (!reversed) {
                    row = this.orderMap.get(this.translate(heatMapData.getStringValue(" ")));
                    logger.debug((Object)("Adding a new row to heatmap, name: " + heatMapData.getStringValue(" ") + "\tto row: " + row));
                } else {
                    ++row;
                }
                if (!reversed) {
                    heatMap.setRowName(row, this.translate(heatMapData.getStringValue(" ")));
                } else {
                    heatMap.setColumnName(row, this.translate(heatMapData.getStringValue(" ")));
                }
                i = -1;
                for (String columnName : columns) {
                    if (!reversed) {
                        ++i;
                    } else {
                        i = this.orderMap.get(columnName);
                        logger.debug((Object)("Adding a new row to heatmap (reversed), name: " + columnName + "\tto row: " + i));
                    }
                    if (!reversed) {
                        heatMap.update(row, i, (double)heatMapData.getFloatValue(columnName));
                        continue;
                    }
                    heatMap.update(i, row, (double)heatMapData.getFloatValue(columnName));
                }
            }
            i = -1;
            for (String columnName : columns) {
                String sampleName = columnName.substring("chip.".length());
                String realName = data.fetchFeature("/phenodata/linked/sample_to_name/" + sampleName).asString();
                if (!reversed) {
                    ++i;
                } else {
                    i = this.orderMap.get(columnName);
                    logger.debug((Object)("Adding a new row to heatmap (reversed), name: " + columnName + "\tto row: " + i));
                }
                if (!reversed) {
                    heatMap.setColumnName(i, realName);
                    continue;
                }
                heatMap.setRowName(i, realName);
            }
            HCDataset dataset = new HCDataset(heatMap, root, null);
            boolean tooltips = true;
            JFreeChart chart = BioChartFactory.createHCChart((String)"Hierarchical Clustering", (HCDataset)dataset, (boolean)tooltips, (boolean)false);
            if (chart.getPlot() instanceof HCPlot) {
                HCPlot hcPlot = (HCPlot)chart.getPlot();
                hcPlot.setColumnNamesSize(0.2);
                hcPlot.setRowNamesSize(0.3);
                hcPlot.setRowTreeSize(0.1);
                hcPlot.setColumnTreeSize(0.1);
                if (tooltips) {
                    hcPlot.setToolTipGenerator((HCToolTipGenerator)new MicroarrayHCToolTipGenerator());
                }
                double min = HierarchicalClustering.getMinValue(dataset.getHeatMap());
                double max = HierarchicalClustering.getMaxValue(dataset.getHeatMap());
                double mid = (min + max) / 2.0;
                GradientColorPalette colors = new GradientColorPalette();
                colors.addKeyColor(min, Color.RED);
                colors.addKeyColor(mid, Color.BLACK);
                colors.addKeyColor(max, Color.GREEN);
                hcPlot.setColoring(colors);
            }
            ChartPanel chartPanel = this.makePanel(chart, size);
            chartPanel.addChartMouseListener((ChartMouseListener)((HCPlot)chart.getPlot()));
            return chartPanel;
        }
        catch (Exception e) {
            logger.error((Object)e);
            e.printStackTrace();
            throw new ErrorReportAsException("Hierarchical clustering cannot be shown.", "The problem is probably caused by unsupported data, such as gene names that are plain numbers or have illegal characters in them.", e);
        }
    }

    private String translate(String gene) {
        return gene.replace("(", "").replace(")", "-");
    }

    private int getTreeHeight(ClusterNode tree) {
        int right;
        if (tree instanceof ClusterLeafNode) {
            return 0;
        }
        int left = this.getTreeHeight(((ClusterBranchNode)tree).getLeftBranch()) + 1;
        return left > (right = this.getTreeHeight(((ClusterBranchNode)tree).getRightBranch()) + 1) ? left : right;
    }

    private HCTreeNode readTree(ClusterNode tree, int index, int height) throws DataRangeMismatchException {
        if (tree instanceof ClusterLeafNode) {
            String gene = ((ClusterLeafNode)tree).getGene();
            this.orderMap.put(gene, index);
            logger.debug((Object)("LeafNode: " + ((ClusterLeafNode)tree).getGene() + "in index: " + index));
            return new HCTreeNode(0.0, index);
        }
        HCTreeNode node = new HCTreeNode((double)height);
        HCTreeNode leftChild = this.readTree(((ClusterBranchNode)tree).getLeftBranch(), index, height - 1);
        node.setLeftChild(leftChild);
        HCTreeNode rightChild = this.readTree(((ClusterBranchNode)tree).getRightBranch(), node.getDataRange().getRightBound() + 1, height - 1);
        node.setRightChild(rightChild);
        return node;
    }

    private static Double getMinValue(HeatMap heatmap) {
        Double min = null;
        for (int row = 0; row < heatmap.getRowCount(); ++row) {
            for (int column = 0; column < heatmap.getColumnsCount(); ++column) {
                Double value = heatmap.get(row, column);
                if (min != null && !(value < min)) continue;
                min = value;
            }
        }
        return min;
    }

    private static Double getMaxValue(HeatMap heatmap) {
        Double max = null;
        for (int row = 0; row < heatmap.getRowCount(); ++row) {
            for (int column = 0; column < heatmap.getColumnsCount(); ++column) {
                Double value = heatmap.get(row, column);
                if (max != null && !(value > max)) continue;
                max = value;
            }
        }
        return max;
    }

    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        return bean.isContentTypeCompatitible("text/plain") && bean.fetchFeature("/clusters/hierarchical/tree").exists() && bean.fetchFeature("/clusters/hierarchical/heatmap").exists();
    }

    private class MicroarrayHCToolTipGenerator
    extends StandardHCToolTipGenerator {
        private MicroarrayHCToolTipGenerator() {
        }

        public String generateToolTip(HeatMap heatmap, DataRange rowRange, DataRange columnRange) {
            int maxColumn;
            int minColumn;
            int maxRow;
            int minRow;
            try {
                minRow = rowRange.getLeftBound();
                maxRow = rowRange.getRightBound();
                minColumn = columnRange.getLeftBound();
                maxColumn = columnRange.getRightBound();
            }
            catch (Exception e) {
                return "This block contains no data.";
            }
            if (minRow == maxRow && minColumn == maxColumn) {
                return "(" + heatmap.getRowName(minRow) + "," + heatmap.getColumnName(minColumn) + ") = " + heatmap.get(minRow, minColumn);
            }
            double averageValue = 0.0;
            int blockCount = 0;
            for (int rowCounter = minRow; rowCounter <= maxRow; ++rowCounter) {
                int columnCounter = minColumn;
                while (columnCounter <= maxColumn) {
                    averageValue += heatmap.get(rowCounter, columnCounter);
                    ++columnCounter;
                    ++blockCount;
                }
            }
            return "(" + heatmap.getRowName(minRow) + "," + heatmap.getColumnName(minColumn) + ") .. " + "(" + heatmap.getRowName(maxRow) + "," + heatmap.getColumnName(maxColumn) + ") = " + (averageValue /= (double)blockCount) + " (contains " + (blockCount + 1) + " blocks)";
        }
    }
}

