/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.methods.ArrayLayout;
import fi.csc.microarray.client.visualisation.methods.ClusteredProfiles;
import fi.csc.microarray.client.visualisation.methods.Empty;
import fi.csc.microarray.client.visualisation.methods.ExpressionProfile;
import fi.csc.microarray.client.visualisation.methods.HierarchicalClustering;
import fi.csc.microarray.client.visualisation.methods.Histogram;
import fi.csc.microarray.client.visualisation.methods.HtmlViewer;
import fi.csc.microarray.client.visualisation.methods.ImageViewer;
import fi.csc.microarray.client.visualisation.methods.PhenodataEditor;
import fi.csc.microarray.client.visualisation.methods.SOM;
import fi.csc.microarray.client.visualisation.methods.Scatterplot;
import fi.csc.microarray.client.visualisation.methods.Spreadsheet;
import fi.csc.microarray.client.visualisation.methods.TextViewer;
import fi.csc.microarray.client.visualisation.methods.threed.Scatterplot3D;
import fi.csc.microarray.databeans.DataBean;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum VisualisationMethod {
    NONE("None", new Empty(), VisualConstants.EMPTY_MENUICON, 0, 0.0),
    SPREADSHEET("Spreadsheet", new Spreadsheet(), VisualConstants.SPREADSHEET_MENUICON, 2, 7.0E-4),
    PHENODATA("Phenodata editor", new PhenodataEditor(), VisualConstants.PHENODATA_MENUICON, 3, 0.0),
    ARRAY_LAYOUT("Array layout", new ArrayLayout(), VisualConstants.ARRAY_MENUICON, -1, 9.0E-4),
    HISTOGRAM("Histogram", new Histogram(), VisualConstants.HISTOGRAM_MENUICON, -1, 0.024),
    SCATTERPLOT("Scatterplot", new Scatterplot(), VisualConstants.SCATTER_MENUICON, -1, 0.039),
    SCATTERPLOT3D("3D Scatterplot", new Scatterplot3D(), VisualConstants.SCATTER3D_MENUICON, -1, 0.082),
    SOM("SOM", new SOM(), VisualConstants.SOM_MENUICON, 3, 0.034),
    HIERARCHICAL("Hierarchical clustering", new HierarchicalClustering(), VisualConstants.HC_MENUICON, 3, 0.09),
    EXPRESSION_PROFILE("Expression profile", new ExpressionProfile(), VisualConstants.PROFILE_MENUICON, -1, 0.1),
    CLUSTERED_PROFILES("Clustered profiles", new ClusteredProfiles(), VisualConstants.PROFILES_MENUICON, -1, NO_MEASURED_ESTIMATE),
    SHOW_IMAGE("Show image", new ImageViewer(), VisualConstants.IMAGE_MENUICON, 1, 0.015),
    WEBVIEW("View page", new HtmlViewer(), VisualConstants.HTML_MENUICON, 1, 0.016),
    VIEW_TEXT("View text", new TextViewer(), VisualConstants.TEXT_MENUICON, 1, 0.023);

    private static double NO_MEASURED_ESTIMATE;
    private static LinkedList<VisualisationMethod> orderedDefaultCandidates;
    private String name;
    private Visualisation visualiser;
    private ImageIcon icon;
    private int orderNumber;
    private double durationEstimationFactor;

    private VisualisationMethod(String name, Visualisation visualiser, ImageIcon icon, int orderNumber, double durationEstimationFactor) {
        this.name = name;
        this.visualiser = visualiser;
        this.icon = icon;
        this.orderNumber = orderNumber;
        this.durationEstimationFactor = durationEstimationFactor;
    }

    public String toString() {
        return this.name;
    }

    public Visualisation getVisualiser() {
        return this.visualiser;
    }

    public int getOrderNumber() {
        return this.orderNumber;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public static VisualisationMethod getDefault() {
        return NONE;
    }

    public long estimateDuration(List<DataBean> datas) {
        if (datas.size() > 0) {
            return (long)((double)datas.get(0).getContentLength() * this.durationEstimationFactor * (double)datas.size());
        }
        return -1L;
    }

    public static boolean isApplicableForMultipleDatas(VisualisationMethod method) {
        return Arrays.asList(VisualisationMethod.getApplicableForMultipleDatas()).contains((Object)method);
    }

    public static VisualisationMethod[] getApplicableForMultipleDatas() {
        VisualisationMethod[] isApplicableForMultipleDatas = new VisualisationMethod[]{NONE, HISTOGRAM, SCATTERPLOT, ARRAY_LAYOUT, HIERARCHICAL, SOM, EXPRESSION_PROFILE};
        return isApplicableForMultipleDatas;
    }

    public boolean isApplicableTo(DataBean bean) throws MicroarrayException {
        return bean != null && this.visualiser.canVisualise(bean);
    }

    public static Iterable<VisualisationMethod> orderedDefaultCandidates() {
        return orderedDefaultCandidates;
    }

    static {
        NO_MEASURED_ESTIMATE = 0.0;
        orderedDefaultCandidates = new LinkedList();
        for (VisualisationMethod value : VisualisationMethod.values()) {
            if (value.getOrderNumber() < 0) continue;
            orderedDefaultCandidates.add(value);
        }
        Collections.sort(orderedDefaultCandidates, new Comparator<VisualisationMethod>(){

            @Override
            public int compare(VisualisationMethod method1, VisualisationMethod method2) {
                return new Integer(method2.getOrderNumber()).compareTo(new Integer(method1.getOrderNumber()));
            }
        });
    }
}

