/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.visualisation.methods.threed.DataPoint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotateListPanel
extends JPanel {
    private JList selectedList;
    DefaultListModel selectedListModel;
    JButton annotateButton;
    private JLabel countLabel;

    public AnnotateListPanel() {
        this.setLayout(new BorderLayout());
        this.selectedListModel = new DefaultListModel();
        this.selectedList = new JList(this.selectedListModel);
        this.countLabel = new JLabel();
        this.annotateButton = new JButton("Annotate");
        this.annotateButton.setToolTipText("Annotate using GeneCruiser for Affymetrix data");
        this.annotateButton.setEnabled(false);
        this.annotateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LinkedList<String> list = new LinkedList<String>();
                for (int i = 0; i < AnnotateListPanel.this.selectedListModel.getSize(); ++i) {
                    list.add(AnnotateListPanel.this.selectedListModel.getElementAt(i).toString());
                }
                Session.getSession().getApplication().annotate(list);
            }
        });
        this.add((Component)this.countLabel, "North");
        this.add((Component)new JScrollPane(this.selectedList), "Center");
        this.add((Component)this.annotateButton, "South");
        this.setSelectedListContent(new LinkedList<DataPoint>());
    }

    public void setSelectedListContent(Collection<DataPoint> content) {
        this.selectedListModel.removeAllElements();
        this.countLabel.setText(content.size() + " Points selected");
        this.annotateButton.setEnabled(content.size() > 0);
        for (DataPoint row : content) {
            this.selectedListModel.addElement(row.toString());
        }
    }

    public void setSelectedListContentStrings(Collection<String> content) {
        this.selectedListModel.removeAllElements();
        this.countLabel.setText(content.size() + " Points selected");
        this.annotateButton.setEnabled(content.size() > 0);
        for (String row : content) {
            this.selectedListModel.addElement(row);
        }
    }
}

