/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.client.operation.parameter.Parameter;
import org.apache.log4j.Logger;

public class SingleSelectionParameter
extends Parameter {
    private static final Logger logger = Logger.getLogger(SingleSelectionParameter.class);
    private SelectionOption[] options;
    private int selectedIndex;

    public SingleSelectionParameter(String name, String description, SelectionOption[] options, int selectedIndex) throws IllegalArgumentException {
        super(name, description);
        if (options == null) {
            throw new IllegalArgumentException("Options array for single selection parameter " + name + " may not be null!");
        }
        if (options.length == 0) {
            throw new IllegalArgumentException("Options array for single selection parameter " + name + " may not be empty!");
        }
        this.options = options;
        if (selectedIndex < 0 || selectedIndex >= options.length) {
            throw new IllegalArgumentException("Given default selection index for parameter " + name + " was out of array bounds!");
        }
        this.selectedIndex = selectedIndex;
    }

    public SingleSelectionParameter(String name, String description) {
        super(name, description);
        this.options = null;
        this.selectedIndex = -1;
    }

    public Object[] getOptions() {
        assert (this.options != null);
        return this.options;
    }

    public int getSelectedIndex() {
        assert (this.selectedIndex != -1);
        return this.selectedIndex;
    }

    public Object getValue() {
        assert (this.selectedIndex != -1);
        assert (this.options != null);
        assert (this.options[this.selectedIndex] != null);
        logger.debug((Object)("returning value " + this.options[this.selectedIndex].getValue() + " from index " + this.selectedIndex));
        return this.options[this.selectedIndex].getValue();
    }

    public void setOptions(SelectionOption[] newOptions, int newSelectedIndex) throws IllegalArgumentException {
        this.options = newOptions;
        this.setSelectedIndex(newSelectedIndex);
    }

    public void setSelectedIndex(int newSelectedIndex) throws IllegalArgumentException {
        if (newSelectedIndex < 0 || newSelectedIndex >= this.options.length) {
            throw new IllegalArgumentException("given index " + newSelectedIndex + " for parameter " + this.getName() + " is out of bounds");
        }
        this.selectedIndex = newSelectedIndex;
    }

    public void setValue(Object newValue) {
        logger.debug((Object)("new value is " + newValue));
        for (int i = 0; i < this.options.length; ++i) {
            if (!this.options[i].getValue().equals(newValue.toString())) continue;
            this.setSelectedIndex(i);
            logger.debug((Object)("new index is " + i));
            return;
        }
        throw new IllegalArgumentException("illegal value for parameter " + this.getName() + ": " + newValue.toString());
    }

    public boolean checkValidityOf(Object valueObject) {
        return valueObject instanceof SelectionOption;
    }

    public String toString() {
        return this.getName() + ": " + this.options[this.selectedIndex].getValue();
    }

    public String getValueAsJava() {
        return "\"" + this.options[this.selectedIndex].getValue() + "\"";
    }

    public static class SelectionOption {
        private String name;
        private String value;

        public SelectionOption(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }

        public static SelectionOption[] convertStrings(String[] strings) {
            SelectionOption[] options = new SelectionOption[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                options[i] = new SelectionOption(strings[i], strings[i]);
            }
            return options;
        }
    }
}

