/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation;

import fi.csc.microarray.client.operation.ExecutionItem;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationCategory;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.LinkUtils;
import fi.csc.microarray.description.VVSADLParser;
import fi.csc.microarray.description.VVSADLSyntax;
import fi.csc.microarray.module.chipster.ChipsterInputTypes;
import java.awt.Color;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationDefinition
implements ExecutionItem {
    private static final Logger logger = Logger.getLogger(OperationDefinition.class);
    public static final OperationDefinition IMPORT_DEFINITION;
    public static String IDENTIFIER_SEPARATOR;
    private static Map<String, OperationDefinition> instances;
    private String name;
    private OperationCategory category;
    private LinkedList<Parameter> parameters = new LinkedList();
    private String description;
    private int colorCount;
    private int outputCount = 0;
    private LinkedList<InputDefinition> inputs = new LinkedList();
    Suitability evaluatedSuitability = null;
    private boolean hasSourceCode;

    public static OperationDefinition getInstance(String identifier) {
        return instances.get(identifier);
    }

    public OperationDefinition(String name, OperationCategory category, String description, boolean hasSourceCode) {
        this.name = name;
        this.category = category;
        this.hasSourceCode = hasSourceCode;
        if (category != null) {
            category.addOperation(this);
        }
        this.description = description;
        instances.put(name + IDENTIFIER_SEPARATOR + category.getName(), this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public OperationCategory getCategory() {
        return this.category;
    }

    @Override
    public String getCategoryName() {
        return this.category.getName();
    }

    public String getFullName() {
        return this.getCategoryName() + " / " + this.getName();
    }

    public List<Parameter> getDefaultParameters() {
        return this.parameters;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getJobPhrase() {
        return VVSADLParser.generateOperationIdentifier(this.category.getName(), this.name);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Suitability evaluateSuitabilityFor(Iterable<DataBean> data) {
        this.bindInputs(data);
        return this.getEvaluatedSuitability();
    }

    public LinkedList<Parameter> getParameters() {
        return this.parameters;
    }

    public void addParameter(Parameter parameter) {
        this.parameters.add(parameter);
    }

    public int getColorCount() {
        return this.colorCount;
    }

    public void addInput(String name, VVSADLSyntax.InputType type) {
        InputDefinition input = new InputDefinition(name, type);
        this.inputs.add(input);
    }

    public void addInput(String prefix, String postfix, VVSADLSyntax.InputType type) {
        InputDefinition input = new InputDefinition(prefix, postfix, type);
        this.inputs.add(input);
    }

    public LinkedList<Operation.DataBinding> bindInputs(Iterable<DataBean> inputValues) {
        LinkedList<Operation.DataBinding> bindings = new LinkedList<Operation.DataBinding>();
        LinkedList<DataBean> notProcessedInputValues = new LinkedList<DataBean>();
        for (DataBean bean : inputValues) {
            notProcessedInputValues.add(bean);
        }
        InputDefinition unboundPhenodataDefinition = null;
        logger.debug((Object)("binding " + notProcessedInputValues.size() + " values to " + this.inputs.size() + " formal inputs"));
        boolean shouldNormalise = false;
        for (InputDefinition inputDefinition : this.inputs) {
            inputDefinition.resetMulti();
            boolean foundBinding = false;
            LinkedList<DataBean> removedValues = new LinkedList<DataBean>();
            for (DataBean value : notProcessedInputValues) {
                logger.debug((Object)("  trying to bind " + value.getName() + " to " + inputDefinition.name + " (" + inputDefinition.type + ")"));
                if (!inputDefinition.type.isTypeOf(value)) continue;
                logger.debug((Object)("    bound successfully (" + value.getName() + " -> " + inputDefinition.getName() + ")"));
                bindings.add(new Operation.DataBinding(value, inputDefinition.getName(), inputDefinition.type));
                foundBinding = true;
                removedValues.add(value);
                if (!inputDefinition.isMulti()) break;
                inputDefinition.nextMulti();
            }
            notProcessedInputValues.removeAll(removedValues);
            if (foundBinding) continue;
            if (inputDefinition.name.contains("phenodata.tsv")) {
                foundBinding = true;
                unboundPhenodataDefinition = inputDefinition;
                continue;
            }
            logger.debug((Object)("  no binding found for " + inputDefinition.name));
            this.evaluatedSuitability = Suitability.NOT_ENOUGH_INPUTS;
            return null;
        }
        if (notProcessedInputValues.size() > 0) {
            logger.debug((Object)("  " + notProcessedInputValues.size() + " concrete inputs were not bound"));
            this.evaluatedSuitability = Suitability.TOO_MANY_INPUTS;
            return null;
        }
        logger.debug((Object)("we have " + bindings.size() + " bindings before phenodata retrieval"));
        if (unboundPhenodataDefinition != null) {
            DataBean dataBean;
            DataBean phenodata;
            boolean found = false;
            if (bindings.size() == 1 && (phenodata = LinkUtils.retrieveInherited(dataBean = ((Operation.DataBinding)bindings.getFirst()).getData(), DataBean.Link.ANNOTATION)) != null) {
                bindings.add(new Operation.DataBinding(phenodata, unboundPhenodataDefinition.getName(), ChipsterInputTypes.PHENODATA));
                found = true;
            }
            if (!found) {
                this.evaluatedSuitability = Suitability.NOT_ENOUGH_INPUTS;
                return null;
            }
        }
        logger.debug((Object)("we have " + bindings.size() + " bindings after phenodata retrieval"));
        this.evaluatedSuitability = shouldNormalise ? Suitability.SHOULD_NORMALISE_FIRST : Suitability.SUITABLE;
        return bindings;
    }

    public Suitability getEvaluatedSuitability() {
        return this.evaluatedSuitability;
    }

    public int getOutputCount() {
        return this.outputCount;
    }

    public void setOutputCount(int outputCount) {
        this.outputCount = outputCount;
    }

    public boolean hasSourceCode() {
        return this.hasSourceCode;
    }

    static {
        IDENTIFIER_SEPARATOR = "/";
        instances = new HashMap<String, OperationDefinition>();
        IMPORT_DEFINITION = new OperationDefinition("Raw data import", OperationCategory.IMPORT_CATEGORY, "Imports raw microarray data from an external file.", false);
    }

    public static class InputDefinition {
        private String name;
        private String postfix = null;
        private boolean multi = false;
        private int multiCounter;
        private VVSADLSyntax.InputType type;

        public InputDefinition(String name, VVSADLSyntax.InputType type) {
            this.resetMulti();
            this.name = name;
            this.type = type;
        }

        public InputDefinition(String prefix, String postfix, VVSADLSyntax.InputType type) {
            this.name = prefix;
            this.postfix = postfix;
            this.type = type;
            this.multi = true;
        }

        private String getName() {
            if (!this.multi) {
                return this.name;
            }
            return this.name + this.multiCounter + this.postfix;
        }

        private void nextMulti() {
            ++this.multiCounter;
        }

        public boolean isMulti() {
            return this.multi;
        }

        public void resetMulti() {
            this.multiCounter = 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Suitability {
        SUITABLE,
        SHOULD_NORMALISE_FIRST,
        IMPOSSIBLE,
        ALREADY_DONE,
        TOO_MANY_INPUTS,
        NOT_ENOUGH_INPUTS;

        private static final Color GREEN;
        private static final Color YELLOW;
        private static final Color RED;
        private static final Color COLOR_ALREADY_DONE;

        public boolean isImpossible() {
            return this == IMPOSSIBLE || this == NOT_ENOUGH_INPUTS || this == TOO_MANY_INPUTS;
        }

        public boolean isOk() {
            return this == SUITABLE;
        }

        public Color getIndicatorColor() {
            if (this.isImpossible()) {
                return RED;
            }
            if (this.isOk()) {
                return GREEN;
            }
            if (this == ALREADY_DONE) {
                return COLOR_ALREADY_DONE;
            }
            return YELLOW;
        }

        public String toString() {
            switch (this) {
                case SUITABLE: {
                    return "Suitable";
                }
                case SHOULD_NORMALISE_FIRST: {
                    return "Normalise first";
                }
                case IMPOSSIBLE: {
                    return "Impossible";
                }
                case ALREADY_DONE: {
                    return "Already done";
                }
                case TOO_MANY_INPUTS: {
                    return "Too many inputs";
                }
                case NOT_ENOUGH_INPUTS: {
                    return "Not enough inputs";
                }
            }
            throw new RuntimeException("unknown suitability: " + this.name());
        }

        static {
            GREEN = new Color(52, 196, 49);
            YELLOW = new Color(196, 186, 49);
            RED = new Color(196, 49, 49);
            COLOR_ALREADY_DONE = new Color(230, 180, 250);
        }
    }
}

