/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport;

import fi.csc.microarray.client.dataimport.ColumnType;

public class DataColumn {
    private ColumnType columnType;
    private int chipNumber;
    private int columnIndex;

    public DataColumn(ColumnType columnType, int chipNumber, int columnIndex) {
        this.columnType = columnType;
        this.chipNumber = chipNumber;
        this.columnIndex = columnIndex;
    }

    public int getChipNumber() {
        return this.chipNumber;
    }

    public void setChipNumber(int chipNumber) {
        this.chipNumber = chipNumber;
    }

    public ColumnType getColumnType() {
        return this.columnType;
    }

    public void setColumnType(ColumnType columnType) {
        if (columnType == null) {
            columnType = ColumnType.UNUSED_LABEL;
        }
        this.columnType = columnType;
    }

    public static DataColumn createEmptyDataColumn(int columnIndex) {
        return new DataColumn(ColumnType.UNUSED_LABEL, -1, columnIndex);
    }

    public static DataColumn createRowNumberColumn(int columnIndex) {
        return new DataColumn(ColumnType.ROW_NUMBER, -1, columnIndex);
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public String toString() {
        return "DataColumn [Type: " + this.getColumnType().getIdentifier() + " Chip: " + this.getChipNumber() + " Index: " + this.getColumnIndex() + "]";
    }
}

