/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport;

import fi.csc.microarray.client.dataimport.ColumnType;
import fi.csc.microarray.client.dataimport.DataColumn;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnTypePattern {
    private List<ColumnType> pattern;
    private int pointer;

    public ColumnTypePattern(List<ColumnType> pattern) {
        this.pattern = pattern;
        this.pointer = 0;
    }

    public List<ColumnType> getPattern() {
        return this.pattern;
    }

    public ColumnType getNext() {
        if (this.pattern == null || this.pattern.size() == 0) {
            return ColumnType.UNUSED_LABEL;
        }
        if (this.pointer >= this.pattern.size()) {
            this.pointer = 0;
        }
        return this.pattern.get(this.pointer++);
    }

    public static ColumnTypePattern createColumnTypePatternFromAllColumns(List<DataColumn> allColumns) {
        ArrayList<ColumnType> pattern = new ArrayList<ColumnType>();
        boolean isFirst = true;
        boolean firstUsedColumnFound = false;
        for (DataColumn column : allColumns) {
            if (isFirst) {
                isFirst = false;
                continue;
            }
            if (column.getColumnType().equals((Object)ColumnType.UNUSED_LABEL)) {
                if (firstUsedColumnFound) break;
                continue;
            }
            pattern.add(column.getColumnType());
            firstUsedColumnFound = true;
        }
        return new ColumnTypePattern(pattern);
    }

    public String toString() {
        StringBuffer pattern = new StringBuffer();
        for (ColumnType column : this.getPattern()) {
            pattern.append(column.getIdentifier());
            pattern.append(" - ");
        }
        return "Column type pattern: " + pattern.toString();
    }
}

