/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.data.tools;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.data.AbstractGraphVertex;
import fi.csc.microarray.client.data.GraphFoldingManager;
import fi.csc.microarray.client.data.GraphVertex;
import fi.csc.microarray.client.data.GroupVertex;
import fi.csc.microarray.client.data.MicroarrayGraph;
import fi.csc.microarray.databeans.DataBean;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jgraph.JGraph;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.CellView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionTool
extends BasicMarqueeHandler
implements MouseListener {
    private MicroarrayGraph graph;
    private static final Logger logger = Logger.getLogger(SelectionTool.class);
    private ClientApplication application = Session.getSession().getApplication();

    public SelectionTool(MicroarrayGraph graph) {
        this.graph = graph;
    }

    public void handleMarqueeEvent(MouseEvent e, JGraph graph, Rectangle2D bounds) {
        this.handleMarqueeEvent(e, (MicroarrayGraph)graph, bounds);
    }

    public void handleMarqueeEvent(MouseEvent e, MicroarrayGraph graph, Rectangle2D bounds) {
        CellView[] views;
        logger.debug((Object)("handleMarqueeEvent: isControlDown " + e.isControlDown()));
        ArrayList<AbstractGraphVertex> vertexesToSelect = new ArrayList<AbstractGraphVertex>();
        for (CellView view : views = graph.getGraphLayoutCache().getCellViews()) {
            AbstractGraphVertex vertex;
            if (view == null) continue;
            if (view.getCell() instanceof GroupVertex) {
                GroupVertex group = (GroupVertex)((Object)view.getCell());
                if (!group.isCollapsed() || !bounds.contains(group.getBounds())) continue;
                vertexesToSelect.add(group);
                continue;
            }
            if (!(view.getCell() instanceof AbstractGraphVertex) || !bounds.contains((vertex = (AbstractGraphVertex)((Object)view.getCell())).getBounds())) continue;
            vertexesToSelect.add(vertex);
        }
        if (e.isControlDown()) {
            this.setSelected(vertexesToSelect);
        } else {
            this.addSelected(vertexesToSelect);
        }
    }

    private void setSelected(AbstractGraphVertex vertex) {
        ArrayList<AbstractGraphVertex> vertexesToSelect = new ArrayList<AbstractGraphVertex>();
        vertexesToSelect.add(vertex);
        this.setSelected(vertexesToSelect);
    }

    private boolean isSelected(AbstractGraphVertex vertex) {
        if (vertex instanceof GraphVertex) {
            return this.application.getSelectionManager().getSelectedDataBeans().contains(((GraphVertex)vertex).getData());
        }
        return false;
    }

    private void setSelected(List<AbstractGraphVertex> vertexesToSelect) {
        boolean multiSelectionMode = vertexesToSelect.size() > 1 || vertexesToSelect.size() == 1 && vertexesToSelect.get(0) instanceof GroupVertex;
        this.application.getSelectionManager().clearAll(false, this.graph);
        this.select(vertexesToSelect, multiSelectionMode);
    }

    private void setSelectedGroup(GroupVertex group, MouseEvent e) {
        this.setSelected(group.getChildVertexes());
    }

    private void addSelected(List<AbstractGraphVertex> vertexesToSelect) {
        this.select(vertexesToSelect, true);
    }

    private void addSelected(AbstractGraphVertex vertex) {
        ArrayList<AbstractGraphVertex> vertexesToSelect = new ArrayList<AbstractGraphVertex>();
        vertexesToSelect.add(vertex);
        this.addSelected(vertexesToSelect);
    }

    private void select(List<AbstractGraphVertex> vertexesToSelect, boolean multiMode) {
        if (!multiMode) {
            this.application.getSelectionManager().clearAll(false, this.graph);
        }
        for (AbstractGraphVertex vertex : vertexesToSelect) {
            if (vertex instanceof GroupVertex) {
                for (DataBean selectedItem : ((GroupVertex)vertex).getChildrenData()) {
                    this.application.getSelectionManager().selectMultiple(selectedItem, this.graph);
                }
                continue;
            }
            DataBean data = ((GraphVertex)vertex).getData();
            if (this.application.getSelectionManager().isSelected(data)) {
                this.application.getSelectionManager().deselectMultiple(data, this.graph);
                continue;
            }
            this.application.getSelectionManager().selectMultiple(data, this.graph);
        }
    }

    public boolean isForceMarqueeEvent(MouseEvent e) {
        return !SwingUtilities.isLeftMouseButton(e) || this.isMarqueeTriggerEvent(e, this.graph) || GraphFoldingManager.getGroupByFoldingHandle(this.graph, e.getPoint()) != null;
    }

    public boolean isMarqueeTriggerEvent(MouseEvent e, JGraph graph) {
        Object clickedCell = graph.getFirstCellForLocation((double)e.getX(), (double)e.getY());
        if (clickedCell != null) {
            return false;
        }
        if (GraphFoldingManager.getGroupByFoldingHandle(graph, e.getPoint()) != null) {
            return false;
        }
        return super.isMarqueeTriggerEvent(e, graph);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.isMarqueeTriggerEvent(e, this.graph)) {
            this.application.getSelectionManager().clearAll(true, this.graph);
            super.mousePressed(e);
        } else if (SwingUtilities.isRightMouseButton(e)) {
            this.graph.setCursor(Cursor.getDefaultCursor());
            this.rightMouseButtonPressed(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.isMarqueeTriggerEvent(e, this.graph)) {
            super.mouseReleased(e);
        } else {
            e.consume();
        }
        this.graph.setCursor(Cursor.getDefaultCursor());
    }

    public void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            super.mouseDragged(e);
        }
    }

    private void mouseButtonClicked(MouseEvent e) {
        Object cell = this.graph.getFirstCellForLocation(e.getX(), e.getY());
        AbstractGraphVertex vertex = null;
        if (cell instanceof AbstractGraphVertex) {
            vertex = (AbstractGraphVertex)((Object)cell);
        }
        if (vertex != null) {
            if (e.isControlDown()) {
                this.addSelected(vertex);
            } else {
                this.setSelected(vertex);
            }
        }
    }

    private void rightMouseButtonPressed(MouseEvent e) {
        Object cell = this.graph.getFirstCellForLocation(e.getX(), e.getY());
        AbstractGraphVertex vertex = null;
        if (cell instanceof AbstractGraphVertex) {
            vertex = (AbstractGraphVertex)((Object)cell);
        }
        if (vertex != null) {
            if (e.isControlDown()) {
                this.addSelected(vertex);
            } else if (!this.isSelected(vertex)) {
                this.setSelected(vertex);
            }
        }
    }

    private void mouseButtonDoubleClicked(MouseEvent e) {
        Object cell = this.graph.getFirstCellForLocation(e.getX(), e.getY());
        logger.debug((Object)("Selected cell: " + cell));
        if (cell instanceof GraphVertex) {
            this.application.visualiseWithBestMethod();
        } else if (cell instanceof GroupVertex && ((GroupVertex)((Object)cell)).isCollapsed()) {
            this.setSelectedGroup((GroupVertex)((Object)cell), e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 1) {
            this.graph.setCursor(Cursor.getDefaultCursor());
            this.mouseButtonDoubleClicked(e);
        } else if (SwingUtilities.isLeftMouseButton(e) && !this.isMarqueeTriggerEvent(e, this.graph)) {
            this.mouseButtonClicked(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

