/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.data.tools;

import fi.csc.microarray.client.data.GraphPanel;
import fi.csc.microarray.client.data.MicroarrayGraph;
import fi.csc.microarray.client.data.tools.Tools;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class HandTool
extends MouseAdapter
implements MouseMotionListener {
    private GraphPanel graphPanel;
    private MicroarrayGraph graph;
    private static Point dragStartPoint = new Point();
    private static boolean isDragging = false;

    public HandTool(GraphPanel graphPanel) {
        this.graphPanel = graphPanel;
        this.graph = graphPanel.getGraph();
    }

    public void mouseReleased(MouseEvent e) {
        if (this.graphPanel.getSelectedTool() == Tools.HAND) {
            isDragging = false;
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.graphPanel.getSelectedTool() == Tools.HAND) {
            this.handToolDragging(e);
        }
    }

    private void handToolDragging(MouseEvent e) {
        SwingUtilities.convertPointToScreen(e.getPoint(), this.graphPanel.getScroller().getViewport());
        Point p = e.getPoint();
        if (!isDragging) {
            isDragging = true;
            dragStartPoint.setLocation(e.getPoint());
        }
        JViewport viewPort = this.graphPanel.getScroller().getViewport();
        Point scrollPosition = viewPort.getViewPosition();
        int dx = (int)(p.getX() - (double)HandTool.dragStartPoint.x);
        int dy = (int)(p.getY() - (double)HandTool.dragStartPoint.y);
        Point newScrollPosition = new Point(scrollPosition);
        newScrollPosition.x -= dx;
        newScrollPosition.y -= dy;
        if (this.canMoveVerticallyToPoint(newScrollPosition)) {
            newScrollPosition.y = scrollPosition.y;
            HandTool.dragStartPoint.y = e.getY();
        }
        if (this.canMoveHorizontally(newScrollPosition)) {
            newScrollPosition.x = scrollPosition.x;
            HandTool.dragStartPoint.x = e.getX();
        }
        viewPort.setViewPosition(newScrollPosition);
    }

    public void mouseMoved(MouseEvent e) {
    }

    private boolean canMoveVerticallyToPoint(Point p) {
        double newY = p.getY();
        int yLimit = this.graph.getHeight() - this.graphPanel.getScroller().getViewport().getHeight();
        return newY < 0.0 || newY > (double)yLimit;
    }

    private boolean canMoveHorizontally(Point p) {
        double newX = p.getX();
        int xLimit = this.graph.getWidth() - this.graphPanel.getScroller().getViewport().getWidth();
        return newX < 0.0 || newX > (double)xLimit;
    }
}

