/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.data.selection;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.data.selection.DatasetChoiceEvent;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItem;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSelectionManager {
    private static final Logger logger = Logger.getLogger(DataSelectionManager.class);
    private ClientApplication client;
    private LinkedList<DataItem> selectedDatas = new LinkedList();

    public DataSelectionManager(ClientApplication client) {
        this.client = client;
        this.clearAll(true, this);
    }

    public DataItem getSelectedItem() {
        return this.selectedDatas.isEmpty() ? null : this.selectedDatas.getLast();
    }

    public DataBean getSelectedDataBean() {
        DataItem selectedItem = this.getSelectedItem();
        if (selectedItem instanceof DataFolder) {
            return null;
        }
        return (DataBean)selectedItem;
    }

    public DataBean[] getSelectedDatasAsArray() {
        LinkedList<DataBean> beans = new LinkedList<DataBean>();
        for (DataBean bean : this.getSelectedDataBeans()) {
            beans.add(bean);
        }
        return beans.toArray(new DataBean[0]);
    }

    public List<DataBean> getSelectedDataBeans() {
        LinkedList<DataBean> list = new LinkedList<DataBean>();
        for (DataItem item : this.selectedDatas) {
            if (!(item instanceof DataBean)) continue;
            list.add((DataBean)item);
        }
        return list;
    }

    public void selectSingle(DataItem dataItem, Object source) {
        this.selectedDatas.clear();
        this.selectMultiple(dataItem, source);
    }

    public void selectMultiple(DataItem selectedItem, Object source) {
        if (!this.selectedDatas.contains(selectedItem)) {
            this.selectedDatas.add(selectedItem);
            this.client.dispatchEvent(new DatasetChoiceEvent(source));
        }
        if (logger.isDebugEnabled()) {
            String s = "selection contains:";
            for (DataItem item : this.selectedDatas) {
                s = s + " " + item.getName();
            }
            logger.debug((Object)s);
        }
    }

    public void deselectMultiple(DataItem selectedItem, Object source) {
        if (this.selectedDatas.contains(selectedItem)) {
            this.selectedDatas.remove(selectedItem);
            this.client.dispatchEvent(new DatasetChoiceEvent(source));
        }
        if (logger.isDebugEnabled()) {
            String s = "selection contains:";
            for (DataItem item : this.selectedDatas) {
                s = s + " " + item.getName();
            }
            logger.debug((Object)s);
        }
    }

    public void clearAll(boolean dispatchEvent, Object source) {
        this.selectedDatas.clear();
        if (dispatchEvent) {
            this.client.dispatchEvent(new DatasetChoiceEvent(source));
        }
    }

    public boolean isSelected(DataItem data) {
        return this.selectedDatas.contains(data);
    }
}

