/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.data;

import fi.csc.microarray.client.data.GraphPanel;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class ScrollAnimator
implements ActionListener {
    private Point from;
    private Dimension viewSize;
    private Point2D.Double viewTarget = new Point2D.Double();
    private int frame = 1;
    GraphPanel graphPanel;
    private Timer timer;
    private static boolean isBusy = false;
    private static ScrollAnimator latestAnimator;
    public static final int FRAME_COUNT = 10;
    public static final int SCROLL_MARGIN = 5;
    private static final Logger logger;

    public ScrollAnimator(GraphPanel graphPanel, Rectangle to) {
        logger.debug((Object)"Animator started");
        if (latestAnimator != null) {
            latestAnimator.kill();
        }
        latestAnimator = this;
        this.graphPanel = graphPanel;
        this.from = graphPanel.getScroller().getViewport().getViewPosition();
        this.viewSize = graphPanel.getGraph().fromScreenCoordinates(graphPanel.getScroller().getViewport().getSize());
        Rectangle area = new Rectangle(this.from, this.viewSize);
        area.grow(-5, -5);
        if (area.contains(to)) {
            logger.debug((Object)"Showing allready");
            return;
        }
        this.viewTarget.x = this.from.getX() < to.getX() ? to.getX() + to.getWidth() - this.viewSize.getWidth() + 5.0 : to.getX() - 5.0;
        this.viewTarget.y = this.from.getY() < to.getY() ? to.getY() + to.getHeight() - this.viewSize.getHeight() + 5.0 : to.getY() - 5.0;
        this.timer = new Timer(50, this);
        this.timer.start();
    }

    public void actionPerformed(ActionEvent e) {
        if (!isBusy) {
            isBusy = true;
            if (this.frame <= 10) {
                Point point = new Point();
                double factor = this.getFactor(this.frame);
                point.x = (int)(this.viewTarget.getX() - (this.viewTarget.getX() - this.from.getX()) * factor);
                point.y = (int)(this.viewTarget.getY() - (this.viewTarget.getY() - this.from.getY()) * factor);
                this.graphPanel.setViewPosition(this.graphPanel.getGraph().toScreen(point));
            } else {
                this.graphPanel.setViewPosition(this.graphPanel.getGraph().toScreen(this.viewTarget));
                this.timer.stop();
                latestAnimator = null;
            }
            isBusy = false;
        }
        ++this.frame;
    }

    private void kill() {
        if (this.timer != null) {
            this.timer.stop();
        }
        latestAnimator = null;
        logger.debug((Object)"ScrollAnimator killed");
    }

    private double getFactor(double frame) {
        return 1.0 / frame - 0.1;
    }

    static {
        logger = Logger.getLogger(ScrollAnimator.class);
    }
}

