/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.data;

import fi.csc.microarray.client.data.AbstractGraphVertex;
import fi.csc.microarray.client.data.GraphVertex;
import fi.csc.microarray.client.data.MicroarrayGraph;
import fi.csc.microarray.databeans.DataBean;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class LayoutManager {
    private MicroarrayGraph graph;
    private static final Logger logger = Logger.getLogger(LayoutManager.class);

    public LayoutManager(MicroarrayGraph graph) {
        this.graph = graph;
    }

    public void updateLayout(AbstractGraphVertex inserted) {
        if (!(inserted instanceof GraphVertex)) {
            throw new IllegalArgumentException("vertex of type " + ((Object)((Object)inserted)).getClass().getSimpleName() + " not supported");
        }
        GraphVertex vertex = (GraphVertex)inserted;
        logger.debug((Object)(vertex.getData().getName() + " is root: " + vertex.isRoot()));
        if (vertex.isRoot()) {
            vertex.setPosition(this.getNewRootPosition());
        } else {
            Point preferredPlace = this.getPreferredPlace(vertex);
            vertex.setPosition(preferredPlace);
        }
        logger.debug((Object)(vertex.getData().getName() + " got bounds: " + vertex.getBounds()));
    }

    private Point getNewRootPosition() {
        Dimension dim = this.graph.getGraphSize();
        return new Point((int)dim.getWidth(), 30);
    }

    private Point getPreferredPlace(GraphVertex vertex) {
        int leftSourceX = Integer.MAX_VALUE;
        int bottomSourceY = 0;
        ArrayList<Integer> sourceXs = new ArrayList<Integer>();
        for (DataBean sourceBean : vertex.getData().getLinkTargets(DataBean.Link.DERIVATION)) {
            GraphVertex source = this.graph.getVertexMap().get(sourceBean);
            if (source.getX() < leftSourceX) {
                leftSourceX = source.getX();
            }
            sourceXs.add(source.getX());
            if (source.getY() <= bottomSourceY) continue;
            bottomSourceY = source.getY();
        }
        int sourceY = bottomSourceY + vertex.getMarginY() + vertex.getDefaultHeight();
        Point potentialPosition = new Point(leftSourceX, sourceY);
        if (this.getIntersectingVertex(potentialPosition, vertex) == null) {
            return potentialPosition;
        }
        Iterator i$ = sourceXs.iterator();
        while (i$.hasNext()) {
            int sourceX = (Integer)i$.next();
            Point point = new Point(sourceX, sourceY);
            if (this.getIntersectingVertex(point, vertex) != null) continue;
            return point;
        }
        boolean done = false;
        while (!done) {
            AbstractGraphVertex intersectingCell = this.getIntersectingVertex(potentialPosition, vertex);
            if (intersectingCell != null && intersectingCell instanceof GraphVertex) {
                GraphVertex graphCell = (GraphVertex)intersectingCell;
                boolean haveSameRoot = false;
                for (GraphVertex cell : vertex.getRootVerticesOfThisVertex()) {
                    if (!graphCell.getRootVerticesOfThisVertex().contains((Object)cell)) continue;
                    haveSameRoot = true;
                    break;
                }
                if (haveSameRoot) {
                    potentialPosition = new Point((int)(potentialPosition.getX() + (double)vertex.getDefaultWidth() + (double)vertex.getMarginX()), (int)potentialPosition.getY());
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        }
        return potentialPosition;
    }

    private AbstractGraphVertex getIntersectingVertex(Point newPoint, GraphVertex vertex) {
        Dimension dim = new Dimension(40, 20);
        Rectangle newPlace = new Rectangle(newPoint, dim);
        for (AbstractGraphVertex cell : this.graph.getVisibleVertexes()) {
            logger.debug((Object)("does " + (Object)((Object)cell) + " intersect " + vertex.getData().getName() + ": " + (cell.getBounds().intersects(newPlace) && cell != vertex)));
            if (!cell.getBounds().intersects(newPlace) || cell == vertex) continue;
            return cell;
        }
        return null;
    }
}

