/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.data;

import fi.csc.microarray.client.data.GraphPanel;
import fi.csc.microarray.client.data.GraphRenderer;
import fi.csc.microarray.client.data.GroupVertex;
import fi.csc.microarray.client.data.MicroarrayGraph;
import fi.csc.microarray.client.data.tools.Tools;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.event.MouseInputAdapter;
import org.apache.log4j.Logger;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;

public class GraphFoldingManager
extends MouseInputAdapter {
    private static Logger logger = Logger.getLogger(GraphFoldingManager.class);
    private GraphPanel graphPanel;

    public GraphFoldingManager(GraphPanel graphPanel) {
        this.graphPanel = graphPanel;
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getSource() instanceof MicroarrayGraph && this.graphPanel.getSelectedTool() == Tools.SELECT) {
            MicroarrayGraph graph = (MicroarrayGraph)e.getSource();
            CellView view = GraphFoldingManager.getGroupByFoldingHandle(graph, e.getPoint());
            if (view != null) {
                if (view.isLeaf() && view.getCell() instanceof GroupVertex) {
                    ((GroupVertex)((Object)view.getCell())).expand();
                } else {
                    ((GroupVertex)((Object)view.getCell())).collapse();
                }
            } else {
                logger.debug((Object)"Cell view is null");
            }
            e.consume();
        }
    }

    public static CellView getGroupByFoldingHandle(JGraph graph, Point2D pt) {
        CellView[] views = graph.getGraphLayoutCache().getCellViews();
        for (int i = 0; i < views.length; ++i) {
            GraphRenderer groupRenderer;
            if (views[i] == null || !(views[i].getCell() instanceof GroupVertex)) continue;
            Point2D containerPoint = graph.fromScreen((Point2D)pt.clone());
            if (!views[i].getBounds().contains(containerPoint.getX(), containerPoint.getY())) continue;
            Rectangle2D groupBounds = views[i].getBounds();
            containerPoint.setLocation(containerPoint.getX() - groupBounds.getX(), containerPoint.getY() - groupBounds.getY());
            Component renderer = views[i].getRendererComponent(graph, false, false, false);
            if (!(renderer instanceof GraphRenderer) || !(groupRenderer = (GraphRenderer)((Object)renderer)).inHitRegion(containerPoint)) continue;
            return views[i];
        }
        return null;
    }
}

