/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client;

import com.jgoodies.looks.HeaderStyle;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import com.jgoodies.uif_lite.panel.SimpleInternalFrame;
import fi.csc.microarray.ApplicationConstants;
import fi.csc.microarray.ErrorReportAsException;
import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.AnnotationLauncher;
import fi.csc.microarray.client.Authenticator;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.ClientContextMenu;
import fi.csc.microarray.client.ClientListener;
import fi.csc.microarray.client.HelpMapping;
import fi.csc.microarray.client.MicroarrayMenuBar;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.data.DetailsPanel;
import fi.csc.microarray.client.data.GraphPanel;
import fi.csc.microarray.client.data.TreePanel;
import fi.csc.microarray.client.data.selection.DatasetChoiceEvent;
import fi.csc.microarray.client.dataimport.ImportScreen;
import fi.csc.microarray.client.dataimport.ImportSession;
import fi.csc.microarray.client.dataimport.ImportUtils;
import fi.csc.microarray.client.dialog.ChipsterDialog;
import fi.csc.microarray.client.dialog.ClipboardImportDialog;
import fi.csc.microarray.client.dialog.DatasetNamingAccessory;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.client.dialog.ErrorDialogUtils;
import fi.csc.microarray.client.dialog.URLImportDialog;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.OperationPanel;
import fi.csc.microarray.client.screen.ChildScreenPool;
import fi.csc.microarray.client.screen.HistoryScreen;
import fi.csc.microarray.client.screen.ShowSourceScreen;
import fi.csc.microarray.client.screen.TaskManagerScreen;
import fi.csc.microarray.client.tasks.Task;
import fi.csc.microarray.client.tasks.TaskException;
import fi.csc.microarray.client.tasks.TaskExecutor;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.VisualisationPanel;
import fi.csc.microarray.client.visualisation.VisualisationToolBar;
import fi.csc.microarray.client.workflow.WorkflowManager;
import fi.csc.microarray.databeans.ContentType;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataChangeEvent;
import fi.csc.microarray.databeans.DataChangeListener;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.biobeans.BioBean;
import fi.csc.microarray.description.VVSADLParser;
import fi.csc.microarray.messaging.auth.AuthenticationRequestListener;
import fi.csc.microarray.messaging.auth.ClientLoginListener;
import fi.csc.microarray.util.BrowserLauncher;
import fi.csc.microarray.util.Exceptions;
import fi.csc.microarray.util.GeneralFileFilter;
import fi.csc.microarray.util.MemUtil;
import fi.csc.microarray.util.SplashScreen;
import fi.csc.microarray.util.config.ConfigurationLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSplitPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingClientApplication
extends ClientApplication {
    private static final int METADATA_FETCH_TIMEOUT_SECONDS = 15;
    private static final long SLOW_VISUALISATION_LIMIT = 3000L;
    private static final long VERY_SLOW_VISUALISATION_LIMIT = 10000L;
    private static Logger logger;
    private JFrame mainFrame = null;
    private JPanel rightSideViewChanger = null;
    private JPanel leftSideContentPane = null;
    private JSplitPane rightSplit = null;
    private JSplitPane leftSplit = null;
    private JSplitPane mainSplit = null;
    private JPanel statusBar = null;
    private JLabel statusLabel = null;
    private JProgressBar jobStatusIndicator = null;
    private JFileChooser importFileChooser = null;
    private MicroarrayMenuBar menuBar;
    private TaskManagerScreen taskManagerScreen;
    private SimpleInternalFrame treeFrame;
    private SimpleInternalFrame graphFrame;
    private SimpleInternalFrame operationsFrame;
    private SimpleInternalFrame visualisationFrame;
    private SimpleInternalFrame detailsFrame;
    private ChildScreenPool childScreens;
    private TreePanel tree;
    private DetailsPanel details;
    private GraphPanel graphPanel;
    private OperationPanel operationsPanel;
    private VisualisationPanel visualisationPanel;
    private HistoryScreen historyScreen;
    private AnnotationLauncher annotationLauncher;
    private JFileChooser dirChooser;
    private JProgressBar memoryIndicator;
    private JButton jobListButton;
    private SplashScreen splashScreen;
    private ClientListener clientListener;
    private AuthenticationRequestListener overridingARL;
    private int oldTaskCount = 0;
    private Timer blinker;
    private static float fontSize;
    private boolean unsavedChanges = false;

    public SwingClientApplication(ClientListener clientListener, AuthenticationRequestListener overridingARL) throws MicroarrayException, IOException {
        this.clientListener = clientListener;
        this.overridingARL = overridingARL;
        this.splashScreen = new SplashScreen(VisualConstants.SPLASH_SCREEN);
        this.reportInitialisation("Initialising " + ApplicationConstants.APPLICATION_TITLE, true);
        try {
            this.initialiseApplication();
        }
        catch (Exception e) {
            this.splashScreen.close();
            throw new MicroarrayException(e);
        }
        logger = Logger.getLogger(SwingClientApplication.class);
    }

    @Override
    public void reportInitialisation(String report, boolean newline) {
        if (newline) {
            this.splashScreen.writeLine(report);
        } else {
            this.splashScreen.write(report);
        }
    }

    protected void initialiseGUI() throws MicroarrayException, IOException {
        try {
            this.definitionsInitialisedLatch.await(15L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (this.parsedCategories == null) {
            throw new MicroarrayException("metadata was not received (analyser not functional?)");
        }
        this.mainFrame = new JFrame();
        this.updateWindowTitle(0);
        this.childScreens = new ChildScreenPool(this.mainFrame);
        SwingClientApplication.setPlastic3DLookAndFeel(this.mainFrame);
        this.mainFrame.setLocationByPlatform(true);
        this.taskManagerScreen = this.getTaskManagerScreen();
        this.historyScreen = new HistoryScreen();
        this.annotationLauncher = new AnnotationLauncher();
        this.childScreens.put("History", this.historyScreen);
        this.childScreens.put("ShowSource", new ShowSourceScreen());
        this.childScreens.put("Import", new ImportScreen());
        this.childScreens.put("TaskList", this.taskManagerScreen);
        try {
            this.operationsPanel = new OperationPanel(this.parsedCategories);
        }
        catch (VVSADLParser.ParseException e) {
            logger.error((Object)"VVSADL parse failed", (Throwable)e);
            throw new MicroarrayException(e);
        }
        this.visualisationPanel = new VisualisationPanel();
        this.operationsFrame = this.getOperationsFrame();
        this.visualisationFrame = this.getVisualisationFrame();
        this.rightSplit = new JSplitPane(0, this.operationsFrame, this.visualisationFrame);
        this.rightSplit.setDividerLocation(250);
        this.leftSideContentPane = new JPanel(new BorderLayout());
        this.details = new DetailsPanel(this.leftSideContentPane);
        this.leftSideContentPane.setBorder(BorderFactory.createEmptyBorder());
        this.tree = new TreePanel(this.manager.getRootFolder());
        this.graphPanel = new GraphPanel();
        this.treeFrame = this.getTreeFrame();
        this.graphFrame = this.getGraphFrame();
        this.leftSplit = new JSplitPane(0, this.treeFrame, this.graphFrame);
        this.leftSplit.setDividerLocation(250);
        this.leftSplit.setResizeWeight(0.3);
        this.detailsFrame = this.getDetailsFrame();
        this.leftSideContentPane.add((Component)this.leftSplit, "Center");
        this.leftSideContentPane.add((Component)this.detailsFrame, "South");
        this.rightSideViewChanger = new JPanel(new BorderLayout());
        this.rightSideViewChanger.add((Component)this.rightSplit, "Center");
        this.rightSideViewChanger.setBorder(BorderFactory.createEmptyBorder());
        this.mainSplit = new JSplitPane(1, this.leftSideContentPane, this.rightSideViewChanger);
        this.mainSplit.setDividerLocation(280);
        this.mainSplit.setResizeWeight(0.25);
        this.menuBar = new MicroarrayMenuBar(this);
        this.menuBar.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
        this.mainFrame.getContentPane().setLayout(new BorderLayout());
        this.mainFrame.getContentPane().add((Component)this.mainSplit, "Center");
        this.mainFrame.getContentPane().add((Component)this.getStatusBar(), "South");
        this.mainFrame.setJMenuBar(this.menuBar);
        this.menuBar.updateMenuStatus();
        this.mainFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SwingClientApplication.this.quit();
            }
        });
        this.mainFrame.setIconImage(VisualConstants.APPLICATION_ICON.getImage());
        this.mainFrame.pack();
        this.mainFrame.setVisible(true);
        this.mainFrame.setDefaultCloseOperation(0);
        this.manager.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
                SwingClientApplication.this.unsavedChanges = true;
            }
        });
        super.setEventsEnabled(true);
        this.manager.setEventsEnabled(true);
        this.splashScreen.close();
        if (this.clientListener != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SwingClientApplication.this.clientListener.onSuccessfulInitialisation();
                }
            });
        }
    }

    private void updateWindowTitle(Integer jobCount) {
        String jobString = jobCount > 0 ? jobCount + " jobs / " : "";
        this.mainFrame.setTitle(jobString + ApplicationConstants.APPLICATION_TITLE);
    }

    public SimpleInternalFrame getVisualisationFrame() {
        if (this.visualisationFrame == null) {
            this.visualisationFrame = new SimpleInternalFrame("Data visualisation");
            this.visualisationFrame.setToolBar(new VisualisationToolBar());
            this.visualisationFrame.add(this.visualisationPanel);
            return this.visualisationFrame;
        }
        return this.visualisationFrame;
    }

    public SimpleInternalFrame getOperationsFrame() {
        if (this.operationsFrame == null) {
            this.operationsFrame = new SimpleInternalFrame("Analysis tools");
            this.operationsFrame.setContent(this.operationsPanel);
        }
        return this.operationsFrame;
    }

    public SimpleInternalFrame getGraphFrame() throws MicroarrayException {
        if (this.graphFrame == null) {
            this.graphFrame = new SimpleInternalFrame("Workflow view", this.graphPanel.getButtonToolBar(), this.graphPanel.getScroller());
        }
        return this.graphFrame;
    }

    public SimpleInternalFrame getTreeFrame() throws MicroarrayException {
        if (this.treeFrame == null) {
            this.treeFrame = new SimpleInternalFrame("Datasets");
            this.treeFrame.add(this.tree);
            return this.treeFrame;
        }
        return this.treeFrame;
    }

    public SimpleInternalFrame getDetailsFrame() throws MicroarrayException {
        if (this.detailsFrame == null) {
            class DetailsFrame
            extends SimpleInternalFrame
            implements PropertyChangeListener {
                public DetailsFrame() {
                    super("Notes for dataset");
                }

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt instanceof DatasetChoiceEvent) {
                        DatasetChoiceEvent dce = (DatasetChoiceEvent)evt;
                        if (dce.getNewValue() != null) {
                            this.setTitle("Notes for dataset " + dce.getNewValue());
                        } else {
                            this.setTitle("Notes for dataset");
                        }
                    }
                }
            }
            DetailsFrame detailsFrameWithListener = new DetailsFrame();
            this.addPropertyChangeListener(detailsFrameWithListener);
            this.detailsFrame = detailsFrameWithListener;
            this.detailsFrame.add(this.details);
            return this.detailsFrame;
        }
        return this.detailsFrame;
    }

    public static void setPlastic3DLookAndFeel(Component componentTreeRoot) {
        Plastic3DLookAndFeel.setPlasticTheme((PlasticTheme)new CustomExperienceBlue());
        try {
            UIManager.installLookAndFeel("Plastic3D", new Plastic3DLookAndFeel().getClass().getName());
            UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e1) {
            e1.printStackTrace();
        }
        UIDefaults defaults = UIManager.getDefaults();
        defaults.putAll(VisualConstants.getUIDefaults());
        SwingUtilities.updateComponentTreeUI(componentTreeRoot);
    }

    public void setFontSize(float size) {
        fontSize = size;
        SwingClientApplication.setPlastic3DLookAndFeel(this.mainFrame);
    }

    public float getFontSize() {
        return fontSize;
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }

    public JPanel getStatusBar() {
        if (this.statusBar == null) {
            this.jobStatusIndicator = new JProgressBar();
            this.jobStatusIndicator.setName("jobStatusIndicator");
            this.jobStatusIndicator.setStringPainted(true);
            int height = (int)this.jobStatusIndicator.getPreferredSize().getHeight();
            this.memoryIndicator = new JProgressBar(0, 100);
            this.memoryIndicator.setStringPainted(true);
            this.memoryIndicator.setToolTipText("Shows how much of the available memory is allocated. Click the indicator to release unused memory (garbage collection).");
            this.memoryIndicator.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                    SwingClientApplication.this.garbageCollect();
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                }
            });
            this.statusLabel = new JLabel();
            String labelText = "Connected to broker at " + MicroarrayConfiguration.getValue("messaging", "broker_host");
            this.statusLabel.setText(labelText);
            this.statusLabel.setBorder(this.jobStatusIndicator.getBorder());
            this.statusLabel.setPreferredSize(new Dimension(this.statusLabel.getPreferredSize().width, height));
            this.jobListButton = new JButton(VisualConstants.ARROW_UP_ICON);
            this.jobListButton.setPreferredSize(new Dimension(height, height + 1));
            this.jobListButton.setName("jobListButton");
            this.jobListButton.setToolTipText("View tasks");
            this.jobListButton.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                    SwingClientApplication.this.flipTaskListVisibility(true);
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                }
            });
            this.taskCountChanged(0, false);
            this.statusBar = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.weightx = 1.0;
            c.fill = 2;
            c.insets.set(0, 0, 0, 5);
            this.statusBar.add((Component)this.statusLabel, c);
            c.gridx = 1;
            c.weightx = 0.0;
            c.insets.set(0, 0, 0, 0);
            c.fill = 0;
            this.statusBar.add((Component)this.jobListButton, c);
            c.gridx = 2;
            this.statusBar.add((Component)this.jobStatusIndicator, c);
            c.insets.set(0, 5, 0, 0);
            c.gridx = 3;
            this.statusBar.add((Component)this.memoryIndicator, c);
        }
        return this.statusBar;
    }

    @Override
    public void flipTaskListVisibility(boolean closeIfVisible) {
        this.taskManagerScreen.refreshTasks();
        boolean wasVisible = this.childScreens.get("TaskList").getFrame().isVisible();
        boolean wasShowing = this.childScreens.get("TaskList").getFrame().isShowing();
        boolean wasNotIconified = true;
        if ((this.childScreens.get("TaskList").getFrame().getExtendedState() & 1) == 1) {
            wasNotIconified = false;
        }
        if (wasVisible && wasShowing && wasNotIconified && closeIfVisible) {
            this.childScreens.get("TaskList").getFrame().setVisible(false);
            this.jobListButton.setIcon(VisualConstants.ARROW_UP_ICON);
            this.jobListButton.setToolTipText("View Task manager");
        } else {
            this.childScreens.get("TaskList").getFrame().setVisible(true);
            this.childScreens.get("TaskList").getFrame().setExtendedState(0);
            this.childScreens.get("TaskList").getFrame().toFront();
            this.childScreens.get("TaskList").getFrame().setFocusable(true);
            this.childScreens.get("TaskList").getFrame().requestFocus();
            this.childScreens.get("TaskList").getFrame().toFront();
            this.jobListButton.setIcon(VisualConstants.ARROW_DOWN_ICON);
            this.jobListButton.setToolTipText("Hide Task manager");
        }
    }

    @Override
    public DataFolder initializeFolderForImport(String folderName) {
        DataFolder root = this.manager.getRootFolder();
        if (folderName == null) {
            logger.debug((Object)("initializing for import " + folderName + ": is null => using root"));
            return root;
        }
        if (ImportUtils.getFolderNames(false).contains(folderName)) {
            logger.debug((Object)("initializing for import " + folderName + ": exists already"));
            DataFolder folderToSelect = folderName.equals(root.getName()) ? root : root.getChildFolder(folderName);
            this.getSelectionManager().selectSingle(folderToSelect, this);
            return folderToSelect;
        }
        logger.debug((Object)("initializing for import " + folderName + ": creating new "));
        DataFolder folder = Session.getSession().getDataManager().createFolder(root, folderName);
        this.getSelectionManager().selectSingle(folder, this);
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void importData(String dataSetName, ContentType contentType, String folderName, Object dataSource) {
        block19: {
            this.setBusyMode(true);
            logger.debug((Object)("Importing dataset " + dataSetName + ". The content type is " + contentType.getDescription()));
            DataFolder folder = this.initializeFolderForImport(folderName);
            try {
                InputStream input;
                if (dataSource instanceof File) {
                    input = new FileInputStream((File)dataSource);
                } else if (dataSource instanceof URL) {
                    URL url = (URL)dataSource;
                    try {
                        input = url.openStream();
                    }
                    catch (FileNotFoundException fnfe) {
                        this.showDialog("File not found.", null, "File not found. Check that the typed URL is pointing to a valid location", DialogInfo.Severity.ERROR, false);
                        this.setBusyMode(false);
                        return;
                    }
                    catch (IOException ioe) {
                        this.showDialog("Import failed.", null, "Error occured while importing data from URL", DialogInfo.Severity.ERROR, false);
                        this.setBusyMode(false);
                        return;
                    }
                } else if (dataSource instanceof InputStream) {
                    logger.info((Object)"loading data from a plain stream, caching can not be used!");
                    input = (InputStream)dataSource;
                } else {
                    throw new IllegalArgumentException("unknown dataSource type: " + dataSource.getClass().getSimpleName());
                }
                DataBean data = this.manager.createDataBean(dataSetName, input);
                data.setContentType(contentType);
                Operation importOperation = new Operation(OperationDefinition.IMPORT_DEFINITION, new DataBean[]{data});
                data.setOperation(importOperation);
                folder.addChild(data);
                DataBean targetData = data;
                for (DataItem source : folder.getChildren()) {
                    DataBean sourceData;
                    if (!(source instanceof DataBean) || (sourceData = (DataBean)source).equals(targetData) || !sourceData.getOperation().getDefinition().equals(OperationDefinition.IMPORT_DEFINITION)) continue;
                    logger.debug((Object)("Created GROUPING link between " + sourceData.getName() + " and " + targetData.getName()));
                    this.createLink(sourceData, targetData, DataBean.Link.GROUPING);
                }
                this.getSelectionManager().selectSingle(data, this);
                break block19;
                {
                    catch (MicroarrayException e) {
                        this.reportException(e);
                        break block19;
                    }
                    catch (IOException e) {
                        this.reportException(e);
                        break block19;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.setBusyMode(false);
            }
        }
    }

    public void showErrorDialog(String title, Exception error) {
        this.showDialog(title, null, Exceptions.getStackTrace(error), DialogInfo.Severity.ERROR, false);
    }

    public void showDialog(String title, DialogInfo.Severity severity, boolean modal) {
        this.showDialog(title, null, null, severity, modal);
    }

    @Override
    public void showDialog(String title, String message, String details, DialogInfo.Severity severity, boolean modal) {
        this.showDialog(title, message, details, severity, modal, ChipsterDialog.DetailsVisibility.DETAILS_HIDDEN);
    }

    @Override
    public void showDialog(String title, String message, String details, DialogInfo.Severity severity, boolean modal, ChipsterDialog.DetailsVisibility detailsVisibility) {
        DialogInfo dialogInfo = new DialogInfo(severity, title, message, details);
        ChipsterDialog.showDialog(this.mainFrame, dialogInfo, detailsVisibility, modal);
    }

    @Override
    public void saveWorkflow() {
        try {
            this.workflowManager.initialiseScriptDirectory();
            JFileChooser fileChooser = ImportUtils.getFixedFileChooser(WorkflowManager.SCRIPT_DIRECTORY);
            String[] extensions = new String[]{"bsh"};
            fileChooser.addChoosableFileFilter(new GeneralFileFilter("workflows in BeanShell format", extensions));
            fileChooser.setSelectedFile(new File("workflow.bsh"));
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.setMultiSelectionEnabled(false);
            int ret = fileChooser.showSaveDialog(null);
            if (ret == 0) {
                this.workflowManager.saveSelectedWorkflow(fileChooser.getSelectedFile());
                this.unsavedChanges = false;
            }
            this.menuBar.updateMenuStatus();
        }
        catch (IOException e) {
            this.reportException(e);
        }
    }

    @Override
    public void showHistoryScreenFor(DataBean data) {
        this.historyScreen.setData(data);
        this.childScreens.show("History", true);
    }

    @Override
    public void showDetailsFor(DataBean data) {
        this.details.setViewedData(data);
    }

    @Override
    public Icon getIconFor(DataItem element) {
        if (element instanceof DataFolder) {
            return VisualConstants.ICON_TYPE_FOLDER;
        }
        DataBean bean = (DataBean)element;
        if (bean.fetchFeature("/phenodata").exists()) {
            return VisualConstants.ICON_TYPE_PHENODATA;
        }
        return bean.getContentType().getIcon();
    }

    public void restoreDefaultView() {
        this.leftSplit.setDividerLocation(250);
        this.mainSplit.setDividerLocation(280);
        this.rightSplit.setDividerLocation(250);
        this.mainSplit.validate();
    }

    public void minimiseLeftSide() {
        this.mainSplit.setDividerLocation(0);
    }

    public void minimiseOperations() {
        this.rightSplit.setDividerLocation(0);
    }

    @Override
    public void reportTaskError(Task task) throws MicroarrayException {
        String title = "Running " + task.getNamePrettyPrinted() + " failed. ";
        String message = "You may have used a tool or parameters which are unsuitable for the selected dataset, or\nthere might be a bug in the analysis tool itself.\n\nThe details below may provide hints about the problem. The most useful information is usually at the few last lines.";
        DialogInfo dialogInfo = new DialogInfo(DialogInfo.Severity.WARNING, title, message, task.getScreenOutput());
        ChipsterDialog.showDialog(this.mainFrame, dialogInfo, ChipsterDialog.DetailsVisibility.DETAILS_ALWAYS_VISIBLE, false);
    }

    @Override
    public void reportException(Exception e) {
        DialogInfo dialogInfo = new DialogInfo();
        dialogInfo.setSeverity(DialogInfo.Severity.ERROR);
        dialogInfo.setTitle("An error has occurred and the action was not performed successfully.");
        dialogInfo.setMessage("If problem persist, please check that your data is valid. For more information open the details panel below.");
        if (e instanceof ErrorReportAsException) {
            ErrorReportAsException report = (ErrorReportAsException)e;
            dialogInfo.setTitle(report.getTitle());
            dialogInfo.setMessage(report.getMessage());
            dialogInfo.setDetails(report.getDetails());
        } else if (e instanceof MicroarrayException) {
            MicroarrayException me = (MicroarrayException)e;
            String details = "";
            if (ErrorDialogUtils.getMessage(me.getExtraInfo()) != null) {
                details = details + ErrorDialogUtils.getMessage(me.getExtraInfo()) + "\n";
            }
            if (ErrorDialogUtils.getScreenOutput(me.getExtraInfo()) != null) {
                details = details + ErrorDialogUtils.getScreenOutput(me.getExtraInfo());
            }
            dialogInfo.setDetails(details);
        } else {
            dialogInfo.setDetails(Exceptions.getStackTrace(e));
        }
        ChipsterDialog.showDialog(this.mainFrame, dialogInfo, ChipsterDialog.DetailsVisibility.DETAILS_HIDDEN, false);
        e.printStackTrace();
        if (logger != null) {
            logger.error((Object)"client got exception", (Throwable)e);
        }
    }

    public void onException(JMSException e) {
        this.reportException((Exception)((Object)e));
    }

    @Override
    protected void taskCountChanged(int taskCount, boolean useBlinking) {
        String indicatorText;
        boolean jobStarted = this.oldTaskCount < taskCount;
        this.oldTaskCount = taskCount;
        if (taskCount == 0) {
            indicatorText = "Ready";
            this.jobStatusIndicator.setIndeterminate(false);
        } else {
            indicatorText = taskCount == 1 ? taskCount + " job running" : taskCount + " jobs running";
            this.jobStatusIndicator.setIndeterminate(true);
        }
        this.jobStatusIndicator.setString(indicatorText);
        if (logger != null) {
            logger.debug((Object)("job count " + taskCount));
        }
        if (useBlinking && jobStarted) {
            this.blinkProgressBar();
        }
        this.updateWindowTitle(taskCount);
        this.taskManagerScreen.refreshTasks();
    }

    private void blinkProgressBar() {
        if (this.blinker != null) {
            this.blinker.stop();
            this.jobStatusIndicator.setFont(this.jobStatusIndicator.getFont().deriveFont(0));
        }
        class Blinker
        implements ActionListener {
            private boolean isBold = false;
            private int repeats;
            private int repeated;

            public Blinker(int repeats) {
                this.repeats = repeats;
                this.repeated = 0;
            }

            public void actionPerformed(ActionEvent e) {
                if (this.repeated == this.repeats) {
                    SwingClientApplication.this.jobStatusIndicator.setFont(SwingClientApplication.this.jobStatusIndicator.getFont().deriveFont(0));
                    ((Timer)e.getSource()).stop();
                    return;
                }
                if (this.isBold) {
                    SwingClientApplication.this.jobStatusIndicator.setFont(SwingClientApplication.this.jobStatusIndicator.getFont().deriveFont(0));
                    this.isBold = false;
                } else {
                    SwingClientApplication.this.jobStatusIndicator.setFont(SwingClientApplication.this.jobStatusIndicator.getFont().deriveFont(1));
                    this.isBold = true;
                }
                ++this.repeated;
            }
        }
        this.blinker = new Timer(350, new Blinker(6));
        this.blinker.start();
    }

    private void updateMemoryIndicator() {
        this.memoryIndicator.setString(MemUtil.getMemInfo());
        this.memoryIndicator.setValue((int)((float)MemUtil.getUsed() / (float)Runtime.getRuntime().maxMemory() * 100.0f));
    }

    public void showChildScreen(String name, boolean packed) {
        this.childScreens.show(name, packed);
    }

    public void showMaximisedVisualisation(boolean maximised) {
        if (maximised) {
            this.minimiseLeftSide();
            this.minimiseOperations();
        } else {
            this.restoreDefaultView();
        }
        this.rightSideViewChanger.validate();
    }

    @Override
    public void showPopupMenuFor(MouseEvent e, DataItem data) {
        ArrayList<DataItem> datas = new ArrayList<DataItem>();
        datas.add(data);
        this.showPopupMenuFor(e, datas);
    }

    @Override
    public void showPopupMenuFor(MouseEvent e, List<DataItem> datas) {
        ClientContextMenu popup = new ClientContextMenu(this);
        popup.setOptionsFor(datas);
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    public boolean isSelectedDataVisualisable() {
        return this.getDefaultVisualisationForSelection() != VisualisationMethod.NONE;
    }

    private VisualisationMethod getDefaultVisualisationForSelection() {
        logger.debug((Object)"getting default visualisation");
        if (this.getSelectionManager().getSelectedDataBeans() == null || this.getSelectionManager().getSelectedDataBeans().size() == 0) {
            return VisualisationMethod.NONE;
        }
        try {
            List<DataBean> beans = this.getSelectionManager().getSelectedDataBeans();
            if (beans.size() == 1) {
                return new BioBean(beans.get(0)).getDefaultVisualisation();
            }
            VisualisationMethod defaultMethodForDatas = null;
            for (DataBean bean : beans) {
                VisualisationMethod method = new BioBean(bean).getDefaultVisualisation();
                if (defaultMethodForDatas == null && VisualisationMethod.isApplicableForMultipleDatas(method)) {
                    defaultMethodForDatas = method;
                    continue;
                }
                if (defaultMethodForDatas == method) continue;
                defaultMethodForDatas = null;
                logger.debug((Object)("Method " + (Object)((Object)method) + " can not be used to visualise selected datas"));
                break;
            }
            if (defaultMethodForDatas != null) {
                logger.debug((Object)("Method " + defaultMethodForDatas + " will be used to visualise selected datas"));
                return defaultMethodForDatas;
            }
            DataBean firstData = beans.get(0);
            for (VisualisationMethod method : VisualisationMethod.getApplicableForMultipleDatas()) {
                if (method == VisualisationMethod.NONE || !method.isApplicableTo(firstData)) continue;
                boolean isSuitableMethod = true;
                for (DataBean otherData : beans) {
                    if (otherData.equals(firstData) || method.isApplicableTo(otherData)) continue;
                    isSuitableMethod = false;
                    logger.debug((Object)("Method " + (Object)((Object)method) + " can not be used to visualise selected datas"));
                    break;
                }
                if (!isSuitableMethod) continue;
                logger.debug((Object)("Method " + (Object)((Object)method) + " will be used to visualise selected datas"));
                return method;
            }
            return VisualisationMethod.NONE;
        }
        catch (Exception e) {
            this.reportException(e);
            return VisualisationMethod.NONE;
        }
    }

    @Override
    public void visualiseWithBestMethod() {
        this.setVisualisationMethod(this.getDefaultVisualisationForSelection());
    }

    public void deleteFolder(DataFolder folder, boolean confirmBeforeActing) {
        JLabel confirmMessage;
        if (confirmBeforeActing && JOptionPane.showConfirmDialog(this.mainFrame, confirmMessage = new JLabel("Really delete folder " + folder.getName() + " and its content?"), "Delete Datasets", 0) != 0) {
            return;
        }
        this.deleteDataFolder(folder);
    }

    @Override
    public void deleteDatas(List<DataBean> datas, boolean confirmBeforeActing) {
        if (datas.size() == 1) {
            this.deleteData(datas.get(0), confirmBeforeActing);
        } else if (datas.size() > 1) {
            JLabel confirmMessage;
            if (confirmBeforeActing && JOptionPane.showConfirmDialog(this.mainFrame, confirmMessage = new JLabel("Really delete " + datas.size() + " datasets?"), "Delete datasets", 0) != 0) {
                return;
            }
            for (DataBean data : datas) {
                this.deleteData(data, false);
            }
        }
    }

    @Override
    public void deleteData(DataItem data, boolean confirmBeforeActing) {
        JLabel confirmMessage;
        if (confirmBeforeActing && JOptionPane.showConfirmDialog(this.mainFrame, confirmMessage = new JLabel("Really delete " + data.getName() + "?"), "Delete dataset", 0) != 0) {
            return;
        }
        if (data instanceof DataBean) {
            this.deleteDataBean((DataBean)data);
        } else {
            this.deleteDataFolder((DataFolder)data);
        }
    }

    private void deleteDataBean(DataBean bean) {
        logger.debug((Object)("removing bean " + bean.getName()));
        this.getSelectionManager().clearAll(true, this);
        for (DataBean.Link linkType : DataBean.Link.values()) {
            for (DataBean target : bean.getLinkTargets(linkType)) {
                bean.removeLink(linkType, target);
            }
            for (DataBean source : bean.getLinkSources(linkType)) {
                source.removeLink(linkType, bean);
            }
        }
        DataFolder folder = bean.getParent();
        if (folder != null) {
            folder.removeChild(bean);
        }
        this.getSelectionManager().clearAll(true, this);
    }

    private void deleteDataFolder(DataFolder folder) {
        logger.debug((Object)("removing folder " + folder.getName()));
        this.getSelectionManager().clearAll(true, this);
        Iterable<DataItem> children = folder.getChildren();
        LinkedList<DataItem> childrenToBeRemoved = new LinkedList<DataItem>();
        for (DataItem item : children) {
            childrenToBeRemoved.add(item);
        }
        for (DataItem item : childrenToBeRemoved) {
            this.deleteData(item, false);
        }
        DataFolder parent = folder.getParent();
        if (parent != null) {
            parent.removeChild(folder);
        }
        this.getSelectionManager().selectSingle(this.manager.getRootFolder(), this);
    }

    public JFileChooser getImportFileChooser() {
        if (this.importFileChooser == null) {
            this.importFileChooser = ImportUtils.getFixedFileChooser();
            DatasetNamingAccessory access = new DatasetNamingAccessory(this.importFileChooser);
            this.importFileChooser.setAccessory(access);
            String description = "common microarray filetypes (cel, spot, gpr, txt, csv, tsv)";
            String[] extensions = new String[]{"cel", "spot", "gpr", "txt", "csv", "tsv"};
            this.importFileChooser.addChoosableFileFilter(new GeneralFileFilter(description, extensions));
            this.importFileChooser.setAcceptAllFileFilterUsed(true);
        }
        return this.importFileChooser;
    }

    public void openFileImport() throws MicroarrayException, IOException {
        JFileChooser fc = this.getImportFileChooser();
        fc.setMultiSelectionEnabled(true);
        DatasetNamingAccessory access = (DatasetNamingAccessory)this.importFileChooser.getAccessory();
        access.setDefaults();
        int ret = fc.showOpenDialog(null);
        if (ret == 0) {
            ArrayList<File> files = new ArrayList<File>();
            for (File file : fc.getSelectedFiles()) {
                files.add(file);
            }
            ImportSession importSession = new ImportSession(ImportSession.Source.FILES, files, access.getImportFolder(), access.skipActionChooser());
            ImportUtils.executeImport(importSession);
        }
    }

    public void openURLImport() throws MicroarrayException, IOException {
        URLImportDialog urlImportDlg = new URLImportDialog(this);
        URL selectedURL = urlImportDlg.getSelectedURL();
        String importFolder = urlImportDlg.getSelectedFolderName();
        if (selectedURL != null) {
            File file = ImportUtils.createTempFile(ImportUtils.convertToDatasetName(ImportUtils.URLToFilename(selectedURL)), ImportUtils.getExtension(ImportUtils.URLToFilename(selectedURL)));
            ImportUtils.getURLFileLoader().loadFileFromURL(selectedURL, file, importFolder, urlImportDlg.isSkipSelected());
        }
    }

    public void openClipboardImport() throws MicroarrayException, IOException {
        new ClipboardImportDialog(this);
    }

    @Override
    protected void quit() {
        int returnValue = -1;
        if (this.taskExecutor.getRunningTaskCount() > 0) {
            String message = "";
            message = this.taskExecutor.getRunningTaskCount() == 1 ? message + "There is a running task.  Are you sure you want to cancel the running task?" : message + "There are " + this.taskExecutor.getRunningTaskCount() + " running tasks. " + "Are you sure you want to cancel all running tasks?";
            Object[] options = new Object[]{"Cancel running tasks", "Cancel"};
            returnValue = JOptionPane.showOptionDialog(this.getMainFrame(), message, "Confirm close", 0, 3, null, options, options[0]);
            if (returnValue == 0) {
                this.taskExecutor.killAll();
            } else {
                return;
            }
        }
        returnValue = -1;
        if (this.unsavedChanges) {
            Object[] options = new Object[]{"Save and close", "Close without saving", "Cancel"};
            returnValue = JOptionPane.showOptionDialog(this.getMainFrame(), "Do you want the workspace to be saved before closing Chipster?", "Confirm close", 1, 3, null, options, options[0]);
        }
        if (returnValue == 0) {
            try {
                this.setBusyMode(true);
                Session.getSession().getDataManager().saveSnapshot(ClientApplication.SNAPSHOT_DIR);
                this.setBusyMode(false);
            }
            catch (Exception exp) {
                this.setBusyMode(false);
                this.showErrorDialog("Workspace saving failed", exp);
                return;
            }
        } else if (returnValue == 2) {
            return;
        }
        this.childScreens.disposeAll();
        this.mainFrame.setVisible(false);
        super.quit();
        this.mainFrame.dispose();
        System.exit(0);
    }

    public void openDirectoryImportDialog() {
        JFileChooser fc = this.getDirChooser();
        fc.setSelectedFile(new File(""));
        int ret = fc.showOpenDialog(null);
        if (ret == 0) {
            File selectedFile = fc.getSelectedFile();
            super.importWholeDirectory(selectedFile);
        }
    }

    public static void start() {
        ClientListener shutdownListener = new ClientListener(){

            public void onSuccessfulInitialisation() {
            }

            public void onFailedInitialisation() {
                System.exit(1);
            }
        };
        SwingClientApplication.start(shutdownListener, null);
    }

    public static void start(ClientListener clientListener, AuthenticationRequestListener overridingARL) {
        block2: {
            try {
                new SwingClientApplication(clientListener, overridingARL);
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (logger == null) break block2;
                logger.error((Object)t.getMessage());
                logger.error((Object)t);
            }
        }
    }

    public static void main(String[] args) throws IOException {
        try {
            MicroarrayConfiguration.loadConfiguration();
        }
        catch (ConfigurationLoader.OldConfigurationFormatException e) {
            SwingClientApplication.reportOldConfigurationFormatException(e);
        }
        SwingClientApplication.start();
    }

    public static void reportOldConfigurationFormatException(ConfigurationLoader.OldConfigurationFormatException e) {
        DialogInfo dialogInfo = new DialogInfo(DialogInfo.Severity.ERROR, "Chipster configuration file not compatible", "Configuration file is from the previous version of the software. You can remove nami-work-files directory from your home directory so the new configuration is created automatically.", "Reason: " + e.getMessage());
        ChipsterDialog.showDialog(null, dialogInfo, ChipsterDialog.DetailsVisibility.DETAILS_HIDDEN, true);
        throw new RuntimeException("configuration not compatible, will not start");
    }

    @Override
    public void showSourceFor(String operationName) throws TaskException {
        this.childScreens.show("ShowSource", true, operationName);
    }

    public void exportFolder(DataFolder data) throws MicroarrayException, IOException {
        File file = new File(data.getName().replace(" ", "_"));
        JFileChooser fc = this.getDirChooser();
        fc.setFileSelectionMode(1);
        fc.setSelectedFile(file);
        logger.debug((Object)("Exporting File: " + fc.getSelectedFile().getAbsolutePath()));
        int ret = fc.showSaveDialog(null);
        if (ret == 0) {
            File selected = new File(fc.getSelectedFile().getAbsolutePath() + File.separator + file.getName());
            selected.mkdirs();
            this.exportDataFolder(data, selected);
        }
    }

    private void exportDataFolder(DataFolder source, File dir) throws IOException, MicroarrayException {
        for (DataItem child : source.getChildren()) {
            if (child instanceof DataBean) {
                String filename = this.createFilename((DataBean)child);
                filename = dir.getAbsolutePath() + File.separator + filename;
                logger.debug((Object)("Exporting dataBean " + child.getName() + " into " + filename));
                this.exportToFile((DataBean)child, new File(filename));
                continue;
            }
            if (!(child instanceof DataFolder)) continue;
            logger.debug((Object)("Exporting dataFolder " + child.getName()));
            String foldername = dir.getAbsolutePath() + File.separator + child.getName().replace(" ", "_");
            File file = new File(foldername);
            file.mkdir();
            this.exportDataFolder((DataFolder)child, file);
        }
    }

    public void exportDataset(DataBean data) throws MicroarrayException, IOException {
        JFileChooser fc = ImportUtils.getFixedFileChooser();
        fc.setDialogType(1);
        String proposedName = this.createFilename(data);
        fc.setSelectedFile(new File(proposedName));
        int ret = fc.showSaveDialog(null);
        if (ret == 0) {
            File selectedFile = fc.getSelectedFile();
            this.exportToFile(data, selectedFile);
        }
    }

    private String createFilename(DataBean data) {
        String proposedName = data.getName().replace(" ", "_");
        return proposedName;
    }

    @Override
    protected AuthenticationRequestListener getAuthenticationRequestListener() {
        AuthenticationRequestListener authenticator = this.overridingARL != null ? this.overridingARL : new Authenticator();
        authenticator.setLoginListener(new ClientLoginListener(){

            public void firstLogin() {
                try {
                    SwingClientApplication.this.initialiseGUI();
                }
                catch (Exception e) {
                    SwingClientApplication.this.reportException(e);
                }
            }

            public void loginCancelled() {
                System.exit(1);
            }
        });
        return authenticator;
    }

    @Override
    public void annotate(List<String> probesets) {
        this.annotationLauncher.setProbeset(probesets);
    }

    @Override
    public void setMaximisedVisualisationMode(boolean maximisedVisualisationMode) {
        this.showMaximisedVisualisation(maximisedVisualisationMode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setVisualisationMethod(VisualisationMethod visualisationMethod, List<Visualisation.Variable> variables) {
        long estimate = visualisationMethod.estimateDuration(this.getSelectionManager().getSelectedDataBeans());
        if (estimate > 3000L) {
            int severity;
            int returnValue = -1;
            String message = "";
            if (estimate > 10000L) {
                message = message + "Are you sure you want to visualise extremely large dataset, which may cause program to stop responding?";
                severity = 2;
            } else {
                message = message + "Are you sure you want to visualise large dataset, which may take several seconds?";
                severity = 3;
            }
            Object[] options = new Object[]{"Cancel", "Visualise"};
            returnValue = JOptionPane.showOptionDialog(this.getMainFrame(), message, "Cancel visualisation", 0, severity, null, options, options[0]);
            if (returnValue != 1) return;
            super.setVisualisationMethod(visualisationMethod, variables);
            return;
        } else {
            super.setVisualisationMethod(visualisationMethod, variables);
        }
    }

    public void exportSelectedItem() {
        try {
            if (this.getSelectionManager().getSelectedItem() instanceof DataBean) {
                this.exportDataset(this.getSelectionManager().getSelectedDataBean());
            } else if (this.getSelectionManager().getSelectedItem() instanceof DataFolder) {
                this.exportFolder((DataFolder)this.getSelectionManager().getSelectedItem());
            }
        }
        catch (Exception e) {
            this.reportException(e);
        }
    }

    private JFileChooser getDirChooser() {
        if (this.dirChooser == null) {
            this.dirChooser = ImportUtils.getFixedFileChooser();
            this.dirChooser.setFileSelectionMode(1);
            String description = "Data Directories";
            String[] extensions = new String[]{};
            this.dirChooser.setFileFilter(new GeneralFileFilter(description, extensions));
            this.dirChooser.setAcceptAllFileFilterUsed(false);
        }
        return this.dirChooser;
    }

    public void openImportTool(ImportSession importSession) {
        ImportScreen importScreen = (ImportScreen)this.childScreens.get("Import");
        importScreen.setImportSession(importSession);
        importScreen.updateTable(false);
        this.childScreens.show("Import", false);
    }

    @Override
    public void setBusyMode(boolean busy) {
        if (busy) {
            Cursor cursor = new Cursor(3);
            this.mainFrame.setCursor(cursor);
        } else {
            Cursor cursor = new Cursor(0);
            this.mainFrame.setCursor(cursor);
        }
    }

    @Override
    public void viewHelpFor(OperationDefinition definition) {
        this.viewHelp(HelpMapping.mapToHelppage(definition));
    }

    @Override
    public void viewHelp(String page) {
        try {
            BrowserLauncher.openURL("https://extras.csc.fi/biosciences/" + page);
        }
        catch (Exception e) {
            this.reportException(e);
        }
    }

    protected void garbageCollect() {
        System.gc();
        this.updateMemoryIndicator();
    }

    public TaskManagerScreen getTaskManagerScreen() {
        TaskExecutor jobExecutor = Session.getSession().getJobExecutor("client-job-executor");
        return new TaskManagerScreen(jobExecutor);
    }

    @Override
    public void createLink(DataBean source, DataBean target, DataBean.Link type) {
        source.addLink(type, target);
    }

    @Override
    public void removeLink(DataBean source, DataBean target, DataBean.Link type) {
        source.removeLink(type, target);
    }

    @Override
    public void showImportToolFor(File file, String destinationFolder, boolean skipActionChooser) {
        ImportSession importSession = new ImportSession(ImportSession.Source.FILES, new File[]{file}, destinationFolder, skipActionChooser);
        this.openImportTool(importSession);
    }

    @Override
    public List<DataItem> loadSnapshot(File snapshotDir) throws IOException, MicroarrayException {
        List<DataItem> newItems = super.loadSnapshot(snapshotDir);
        this.getSelectionManager().selectSingle(newItems.get(newItems.size() - 1), this);
        return newItems;
    }

    @Override
    public void heartBeat() {
        this.updateMemoryIndicator();
    }

    @Override
    public DataManager getDataManager() {
        return this.manager;
    }

    public void setUnsavedChanges(boolean value) {
        this.unsavedChanges = value;
    }

    static {
        fontSize = 11.0f;
    }

    private static class CustomExperienceBlue
    extends ExperienceBlue {
        private CustomExperienceBlue() {
        }

        public ColorUIResource getFocusColor() {
            return new ColorUIResource(VisualConstants.PLASTIC3D_FOCUS_COLOR);
        }

        public FontUIResource getControlTextFont() {
            return new FontUIResource(super.getControlTextFont().deriveFont(fontSize));
        }

        public FontUIResource getTitleTextFont() {
            return new FontUIResource(super.getTitleTextFont().deriveFont(fontSize));
        }

        public FontUIResource getSubTextFont() {
            return new FontUIResource(super.getSubTextFont().deriveFont(fontSize));
        }

        public FontUIResource getSystemTextFont() {
            return new FontUIResource(super.getSystemTextFont().deriveFont(fontSize));
        }

        public FontUIResource getUserTextFont() {
            return new FontUIResource(super.getUserTextFont().deriveFont(fontSize));
        }

        public FontUIResource getWindowTitleFont() {
            return new FontUIResource(super.getWindowTitleFont().deriveFont(fontSize));
        }

        public FontUIResource getMenuTextFont() {
            return new FontUIResource(super.getMenuTextFont().deriveFont(fontSize));
        }
    }
}

