/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client;

import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.ClientTestHelper;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.util.config.ConfigurationLoader;
import java.io.IOException;

public class HCClientTestInitialiser
implements ClientTestHelper.TestImplementation {
    public void implementGUITest(ClientTestHelper.ShutdownCallback shutdownCallback) throws Exception {
        ClientApplication app = Session.getSession().getApplication();
        DataManager manager = Session.getSession().getDataManager();
        app.importData("hierarchical.tsv", manager.guessContentType("hierarchical.tsv"), "HC", this.getClass().getResource("/hierarchical.tsv"));
        app.importData("hcnParent.tsv", manager.guessContentType("hcnParent.tsv"), "HC", this.getClass().getResource("/hcnParent.tsv"));
        DataBean hc = null;
        DataBean parent = null;
        for (DataBean bean : app.getAllDataBeans()) {
            if (bean.getName().equals("hierarchical.tsv")) {
                hc = bean;
            }
            if (!bean.getName().equals("hcnParent.tsv")) continue;
            parent = bean;
        }
        app.createLink(hc, parent, DataBean.Link.DERIVATION);
        app.getSelectionManager().selectSingle(hc, this);
        app.setVisualisationMethod(VisualisationMethod.HIERARCHICAL, null);
    }

    public static void main(String[] args) throws InterruptedException, IOException, ConfigurationLoader.OldConfigurationFormatException {
        MicroarrayConfiguration.loadConfiguration();
        new ClientTestHelper().runTest(new HCClientTestInitialiser());
    }
}

