/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client;

import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.dialog.RenameDialog;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientContextMenu
extends JPopupMenu
implements ActionListener,
PopupMenuListener {
    private static final Logger logger = Logger.getLogger(ClientContextMenu.class);
    private SwingClientApplication application;
    private DataItem selectedItem;
    private JMenuItem visualiseMenuItem;
    private JMenuItem renameMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenuItem importMenuItem;
    private JMenuItem exportMenuItem;
    private JMenuItem historyMenuItem;
    private JMenu linktoMenu;
    private JMenu unlinkMenu;
    private List<JMenuItem> linkDestinations;
    private Map<JMenuItem, DataBean> linkMap;
    private List<JMenuItem> unlinkDestinations;
    private Map<JMenuItem, BeanLinkConnector> unlinkMap;

    public ClientContextMenu(SwingClientApplication application) {
        this.application = application;
        this.addPopupMenuListener(this);
        this.visualiseMenuItem = new JMenuItem("Visualise");
        this.visualiseMenuItem.setFont(this.getFont().deriveFont(1));
        this.linktoMenu = new JMenu("Link to");
        this.linktoMenu.setIcon(VisualConstants.LINK_MENUICON);
        this.unlinkMenu = new JMenu("Unlink from");
        this.unlinkMenu.setIcon(VisualConstants.UNLINK_MENUICON);
        this.renameMenuItem = new JMenuItem("Rename");
        this.deleteMenuItem = new JMenuItem("Delete");
        this.deleteMenuItem.setIcon(VisualConstants.DELETE_MENUICON);
        this.importMenuItem = new JMenuItem("Import Chip File...");
        this.exportMenuItem = new JMenuItem("Export...");
        this.exportMenuItem.setIcon(VisualConstants.EXPORT_MENUICON);
        this.historyMenuItem = new JMenuItem("View history as text");
        this.historyMenuItem.setIcon(VisualConstants.GENERATE_HISTORY_ICON);
        this.visualiseMenuItem.addActionListener(this);
        this.renameMenuItem.addActionListener(this);
        this.deleteMenuItem.addActionListener(this);
        this.importMenuItem.addActionListener(this);
        this.exportMenuItem.addActionListener(this);
        this.historyMenuItem.addActionListener(this);
    }

    public void setOptionsFor(List<DataItem> items) {
        boolean isLinkable;
        boolean multipleSelected;
        boolean bl = multipleSelected = items.size() > 1;
        if (items != null && items.size() > 0) {
            this.selectedItem = items.get(0);
        }
        this.removeAll();
        this.linkDestinations = new ArrayList<JMenuItem>();
        this.linkMap = new HashMap<JMenuItem, DataBean>();
        this.unlinkDestinations = new ArrayList<JMenuItem>();
        this.unlinkMap = new HashMap<JMenuItem, BeanLinkConnector>();
        if (items != null && items.size() > 0) {
            this.add(this.visualiseMenuItem);
            this.addSeparator();
            this.add(this.linktoMenu);
            this.add(this.unlinkMenu);
            this.addSeparator();
            this.add(this.renameMenuItem);
            this.add(this.deleteMenuItem);
            this.addSeparator();
            this.add(this.exportMenuItem);
            this.add(this.historyMenuItem);
            if (multipleSelected) {
                this.visualiseMenuItem.setEnabled(this.application.isSelectedDataVisualisable());
                this.renameMenuItem.setEnabled(false);
                this.exportMenuItem.setEnabled(false);
                this.historyMenuItem.setEnabled(false);
                isLinkable = false;
            } else if (this.selectedItem instanceof DataBean) {
                this.visualiseMenuItem.setEnabled(true);
                this.renameMenuItem.setEnabled(true);
                this.exportMenuItem.setEnabled(true);
                this.historyMenuItem.setEnabled(true);
                isLinkable = !((DataBean)this.selectedItem).fetchFeature("/phenodata").exists();
            } else {
                this.visualiseMenuItem.setEnabled(false);
                this.renameMenuItem.setEnabled(true);
                this.exportMenuItem.setEnabled(true);
                this.historyMenuItem.setEnabled(false);
                isLinkable = false;
            }
        } else {
            this.add(this.importMenuItem);
            isLinkable = false;
        }
        this.linktoMenu.setEnabled(isLinkable);
        this.unlinkMenu.setEnabled(isLinkable);
        if (isLinkable) {
            DataBean bean = (DataBean)this.selectedItem;
            if (this.application.getAllDataBeans().size() > 1) {
                List<DataBean> allDatas = this.application.getAllDataBeans();
                allDatas.remove(this.selectedItem);
                for (DataBean data : allDatas) {
                    JMenuItem link = new JMenuItem(data.getName());
                    link.addActionListener(this);
                    this.linkDestinations.add(link);
                    this.linktoMenu.add(link);
                    this.linkMap.put(link, data);
                }
            } else {
                this.linktoMenu.setEnabled(false);
            }
            if (ClientContextMenu.getAllLinks(bean).size() > 0) {
                for (BeanLinkConnector target : ClientContextMenu.getAllLinks(bean)) {
                    JMenuItem unlink = new JMenuItem(target.getDataBean().getName() + " (" + target.getLink().toString() + ")");
                    unlink.addActionListener(this);
                    this.unlinkDestinations.add(unlink);
                    this.unlinkMenu.add(unlink);
                    this.unlinkMap.put(unlink, target);
                }
            } else {
                this.unlinkMenu.setEnabled(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.visualiseMenuItem) {
            this.application.visualiseWithBestMethod();
        } else if (source == this.renameMenuItem) {
            new RenameDialog(this.application, this.selectedItem);
        } else if (source == this.deleteMenuItem) {
            if (this.selectedItem instanceof DataFolder) {
                this.application.deleteFolder((DataFolder)this.selectedItem, true);
            } else {
                this.application.deleteDatas(this.application.getSelectionManager().getSelectedDataBeans(), true);
            }
        } else if (source == this.importMenuItem) {
            try {
                this.application.openFileImport();
            }
            catch (Exception me) {
                this.application.reportException(me);
            }
        } else if (source == this.exportMenuItem) {
            this.application.exportSelectedItem();
        } else if (source == this.historyMenuItem) {
            if (this.selectedItem instanceof DataBean) {
                logger.debug((Object)"History activated");
                DataBean data = (DataBean)this.selectedItem;
                if (data != null) {
                    this.application.showHistoryScreenFor(data);
                }
            }
        } else if (this.linkDestinations.contains(source)) {
            DataBean.Link[] links = DataBean.Link.userEditableValues();
            Object selectedLinkType = JOptionPane.showInputDialog(this, "Choose link type", "Link type", 3, null, (Object[])links, (Object)links[0]);
            if (selectedLinkType instanceof DataBean.Link) {
                DataBean.Link linkType = (DataBean.Link)((Object)selectedLinkType);
                DataBean linkDest = (DataBean)this.selectedItem;
                DataBean linkSource = this.linkMap.get((JMenuItem)source);
                this.application.createLink(linkSource, linkDest, linkType);
            }
        } else if (this.unlinkDestinations.contains(source)) {
            DataBean item = (DataBean)this.selectedItem;
            BeanLinkConnector connector = this.unlinkMap.get((JMenuItem)source);
            logger.debug((Object)("Removing link from/to " + item.getName()));
            ClientContextMenu.printLinksForData(item);
            if (connector.isSource()) {
                this.application.removeLink(connector.getDataBean(), item, connector.getLink());
            } else {
                this.application.removeLink(item, connector.getDataBean(), connector.getLink());
            }
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        if (this.selectedItem instanceof DataBean) {
            this.historyMenuItem.setEnabled(true);
        } else {
            this.historyMenuItem.setEnabled(false);
        }
    }

    private static List<BeanLinkConnector> getAllLinks(DataBean data) {
        ArrayList<BeanLinkConnector> allTargets = new ArrayList<BeanLinkConnector>();
        for (DataBean.Link linkType : DataBean.Link.values()) {
            for (DataBean target : data.getLinkTargets(linkType)) {
                if (allTargets.contains(target)) continue;
                allTargets.add(new BeanLinkConnector(target, linkType, false));
            }
            for (DataBean source : data.getLinkSources(linkType)) {
                if (allTargets.contains(source)) continue;
                allTargets.add(new BeanLinkConnector(source, linkType, true));
            }
        }
        Collections.sort(allTargets, new Comparator<BeanLinkConnector>(){

            @Override
            public int compare(BeanLinkConnector o1, BeanLinkConnector o2) {
                return o1.getDataBean().getName().compareTo(o2.getDataBean().getName());
            }
        });
        return allTargets;
    }

    public static void printLinksForData(DataBean data) {
        for (DataBean.Link type : DataBean.Link.values()) {
            for (DataBean source : data.getLinkSources(type)) {
                logger.debug((Object)(source.getName() + " <" + (Object)((Object)type) + "> " + data.getName()));
            }
        }
        for (DataBean.Link type : DataBean.Link.values()) {
            for (DataBean target : data.getLinkTargets(type)) {
                logger.debug((Object)(data.getName() + " <" + (Object)((Object)type) + "> " + target.getName()));
            }
        }
    }

    private static class BeanLinkConnector {
        private DataBean bean;
        private DataBean.Link link;
        private boolean isSource;

        public BeanLinkConnector(DataBean bean, DataBean.Link link, boolean isSource) {
            this.bean = bean;
            this.link = link;
            this.isSource = isSource;
        }

        public DataBean getDataBean() {
            return this.bean;
        }

        public DataBean.Link getLink() {
            return this.link;
        }

        public boolean isSource() {
            return this.isSource;
        }

        public boolean equals(Object obj) {
            if (obj instanceof BeanLinkConnector) {
                BeanLinkConnector connector = (BeanLinkConnector)obj;
                return connector.getDataBean().equals(this.bean) && connector.getLink().equals((Object)this.link) && connector.isSource() == this.isSource;
            }
            return false;
        }
    }
}

