/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.util.BrowserLauncher;
import fi.csc.microarray.util.GeneCruiserAPI;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationLauncher {
    private static final String URL_PLACEHOLDER = "***";
    private static Logger logger;
    private GeneCruiserAPI annotateAPI = new GeneCruiserAPI();
    private List<String> identifiers;

    public AnnotationLauncher() throws MicroarrayException {
        if (logger == null) {
            logger = Logger.getLogger(AnnotationLauncher.class);
        }
    }

    public AnnotationLauncher(LinkedList<String> probesets) throws MicroarrayException {
        this();
        this.setProbeset(probesets);
    }

    private String getAnnotationAsHtml() {
        String result = "";
        try {
            int x;
            String[][] reply = this.annotateAPI.annotate(this.identifiers);
            if (logger.isDebugEnabled()) {
                for (x = 0; x < reply.length; ++x) {
                    String row = "";
                    for (int y = 0; y < reply[x].length; ++y) {
                        row = row + reply[x][y] + "\t";
                    }
                    logger.debug((Object)row);
                }
            }
            result = result + "<html><head></head><body style=\"font-size:11\">";
            result = result + "<h2>Annotations by GeneCruiser (Broad Institute / MIT)</h2>";
            result = result + "<table border='1'>";
            for (x = 0; x < reply.length; ++x) {
                int y;
                if (x == 0) {
                    result = result + "<tr>";
                    result = result + "<td width=\"90\"><strong>Probeset ID</strong></td>";
                    for (y = 0; y < reply[x].length; ++y) {
                        String widthModifier = y == 2 ? " width=\"80\"" : "";
                        result = result + "<td valign=\"top\"" + widthModifier + "><strong>" + reply[x][y].replace('\n', ' ') + "</strong></td>";
                    }
                    result = result + "</tr>";
                    continue;
                }
                result = result + "<tr>";
                result = result + "<td>" + this.identifiers.get(x - 1) + "</td>";
                for (y = 0; y < reply[0].length; ++y) {
                    if (y < reply[x].length) {
                        String field = reply[0][y];
                        String data = reply[x][y];
                        String url = null;
                        if (field.trim().equals("UniProt")) {
                            url = "http://srs.ebi.ac.uk/srs6bin/cgi-bin/wgetz?-e+[SWALL-ACC:***]";
                        } else if (field.trim().equals("LocusLink")) {
                            url = "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=gene&cmd=Retrieve&dopt=Graphics&list_uids=***";
                        } else if (field.trim().equals("RefSeq")) {
                            url = "http://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?val=***";
                        }
                        if (field.contains("GO ID")) {
                            String[] splitted;
                            url = "http://amigo.geneontology.org/cgi-bin/amigo/term-details.cgi?term=GO:";
                            result = result + "<td>";
                            for (String str : splitted = data.split(",")) {
                                result = result + "<a href=\"" + url + str.trim() + "\">" + str.trim() + "</a>";
                                if (str.equals(splitted[splitted.length - 1])) continue;
                                result = result + ", ";
                            }
                            result = result + "&nbsp;</td>";
                            continue;
                        }
                        if (url != null && data != null && !data.trim().equals("")) {
                            String link = url.replace(URL_PLACEHOLDER, data);
                            result = result + "<td><a href=\"" + link + "\">" + data + "</a></td>";
                            continue;
                        }
                        if (data == null || data.trim().equals("")) {
                            data = "&nbsp;";
                        }
                        result = result + "<td>" + data + "</td>";
                        continue;
                    }
                    result = result + "<td>&nbsp;</td>";
                }
                result = result + "</tr>";
            }
            result = result + "</table>";
            result = result + "<p><em>Total of " + (reply.length - 1) + " probesets searched.</em></p>";
            result = result + "</body></html>";
        }
        catch (MicroarrayException me) {
            me.printStackTrace();
            result = "GeneCruiser service could not be used: " + me.getClass().getSimpleName() + me.getMessage() != null ? "(" + me.getMessage() + ")" : "";
        }
        return result;
    }

    private String writeToFile(String content) {
        try {
            File temp = File.createTempFile("annotation", ".html");
            temp.deleteOnExit();
            BufferedWriter out = new BufferedWriter(new FileWriter(temp));
            out.write(content);
            out.close();
            return temp.getCanonicalPath();
        }
        catch (IOException e) {
            Session.getSession().getApplication().reportException(e);
            return null;
        }
    }

    public void setProbeset(List<String> probesets) {
        this.identifiers = probesets;
        String path = this.writeToFile(this.getAnnotationAsHtml());
        try {
            BrowserLauncher.openURL(path);
        }
        catch (Exception e) {
            Session.getSession().getApplication().reportException(e);
        }
    }
}

