/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser;

import fi.csc.microarray.client.tasks.Task;
import fi.csc.microarray.client.tasks.TaskEventListener;
import fi.csc.microarray.client.tasks.TaskException;
import fi.csc.microarray.client.tasks.TaskExecutor;
import fi.csc.microarray.databeans.fs.FSDataManager;
import fi.csc.microarray.messaging.MessagingTestBase;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeSuite;

public class AnalysisTestBase
extends MessagingTestBase {
    protected FSDataManager manager;
    protected TaskExecutor executor;

    @BeforeSuite(alwaysRun=true)
    protected void setUp() throws Exception {
        super.setUp();
        this.manager = new FSDataManager();
        this.executor = new TaskExecutor(this.endpoint, this.manager);
    }

    @AfterSuite(alwaysRun=true)
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected void executeJob(Task job) throws TaskException, InterruptedException {
        this.executeJob(job, 60000L, TimeUnit.MILLISECONDS, Task.State.COMPLETED);
    }

    protected void executeJob(Task job, long timeout, TimeUnit timeUnit) throws TaskException, InterruptedException {
        this.executeJob(job, timeout, timeUnit, Task.State.COMPLETED);
    }

    protected void executeJob(Task job, Task.State expectedEndState) throws TaskException, InterruptedException {
        this.executeJob(job, 60000L, TimeUnit.MILLISECONDS, expectedEndState);
    }

    protected void executeJob(Task job, long timeout, TimeUnit timeUnit, Task.State expectedEndState) throws TaskException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        job.addTaskEventListener(new JobResultListener(latch));
        this.executor.startExecuting(job);
        latch.await(timeout, timeUnit);
        Task.State endState = job.getState();
        Assert.assertEquals((Object)((Object)endState), (Object)((Object)expectedEndState));
    }

    class JobResultListener
    implements TaskEventListener {
        private CountDownLatch latch;

        public JobResultListener(CountDownLatch latch) {
            this.latch = latch;
        }

        public void onStateChange(Task job, Task.State oldState, Task.State newState) {
            if (newState.isFinished()) {
                this.latch.countDown();
            }
        }
    }
}

