/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.proto.repository.Array;
import fi.csc.microarray.proto.repository.Experiment;
import fi.csc.microarray.proto.repository.Query;
import fi.csc.microarray.proto.repository.Repository;
import fi.csc.microarray.proto.repository.schema.ParameterClass;
import java.io.IOException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RepositoryTest {
    @Test
    public void testDummyRepository() throws InstantiationException, IllegalAccessException, ClassNotFoundException, MicroarrayException, IOException {
        ParameterClass pc;
        System.setProperty("nami.repository.available.dummy", "fi.csc.microarray.proto.repository.dummy.DummyRepository");
        Repository dummyRepository = null;
        for (Repository rep : Repository.getAvailableRepositories()) {
            if (!rep.getType().contains("Dummy")) continue;
            dummyRepository = rep;
            break;
        }
        Assert.assertTrue(((pc = dummyRepository.getRootClass()) != null ? 1 : 0) != 0);
        Assert.assertTrue((pc.getSubclasses().length > 0 ? 1 : 0) != 0);
        Query query = new Query("something/else AND something/more", null);
        Assert.assertTrue((boolean)query.isValid());
        Iterable<Experiment> experiments = dummyRepository.executeQuery(query);
        Assert.assertTrue((boolean)experiments.iterator().hasNext());
        for (Experiment experiment : experiments) {
            Assert.assertTrue((experiment.getDescription() != null ? 1 : 0) != 0);
            Iterable<String> arrayNames = experiment.getArrayNames();
            for (String arrayName : arrayNames) {
                Array array = experiment.getArray(arrayName);
                Assert.assertTrue((array != null ? 1 : 0) != 0);
                Assert.assertTrue((boolean)arrayName.equals(array.getName()));
                Assert.assertTrue((array.getContents().read() > 0 ? 1 : 0) != 0);
            }
        }
    }
}

