/*
 * Decompiled with CFR 0.152.
 */
package com.nexes.wizard;

import com.nexes.wizard.WizardController;
import com.nexes.wizard.WizardModel;
import com.nexes.wizard.WizardPanelDescriptor;
import fi.csc.microarray.client.VisualConstants;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class Wizard
extends WindowAdapter
implements PropertyChangeListener {
    public static final int FINISH_RETURN_CODE = 0;
    public static final int CANCEL_RETURN_CODE = 1;
    public static final int ERROR_RETURN_CODE = 2;
    public static final String NEXT_BUTTON_ACTION_COMMAND = "NextButtonActionCommand";
    public static final String BACK_BUTTON_ACTION_COMMAND = "BackButtonActionCommand";
    public static final String CANCEL_BUTTON_ACTION_COMMAND = "CancelButtonActionCommand";
    public static final String FINISH_BUTTON_ACTION_COMMAND = "FinishButtonActionCommand";
    public static final String START_NAVIGATION_PANEL = "StartNavigationPanel";
    public static final String FINISH_NAVIGATION_PANEL = "FinishNavigationPanel";
    public static final String NEXT_NAVIGATION_PANEL = "NextNavigationPanel";
    public static final String FINISH_NEXT_NAVIGATION_PANEL = "FinishNextNavigationPanel";
    static String BACK_TEXT = "Back";
    static String NEXT_TEXT = "Next";
    static String FINISH_TEXT = "Finish";
    static String CANCEL_TEXT = "Cancel";
    private WizardModel wizardModel;
    private WizardController wizardController;
    private JDialog wizardDialog;
    private JPanel contentPanel;
    private CardLayout contentLayout;
    private JPanel buttonPanel;
    private CardLayout buttonLayout;
    private Map<String, JButton> backButtons = new HashMap<String, JButton>();
    private Map<String, JButton> nextButtons = new HashMap<String, JButton>();
    private Map<String, JButton> cancelButtons = new HashMap<String, JButton>();
    private Map<String, JButton> finishButtons = new HashMap<String, JButton>();
    private int returnCode;

    public Wizard() {
        this((Frame)null);
    }

    public Wizard(Dialog owner) {
        this.wizardModel = new WizardModel();
        this.wizardDialog = new JDialog(owner);
        this.initComponents();
    }

    public Wizard(Frame owner) {
        this.wizardModel = new WizardModel();
        this.wizardDialog = new JDialog(owner);
        this.initComponents();
        if (owner != null) {
            this.wizardDialog.setLocationRelativeTo(owner);
        }
    }

    public JDialog getDialog() {
        return this.wizardDialog;
    }

    public Component getOwner() {
        return this.wizardDialog.getOwner();
    }

    public void setTitle(String s) {
        this.wizardDialog.setTitle(s);
    }

    public String getTitle() {
        return this.wizardDialog.getTitle();
    }

    public void setModal(boolean b) {
        this.wizardDialog.setModal(b);
    }

    public boolean isModal() {
        return this.wizardDialog.isModal();
    }

    public int showModalDialog() {
        this.wizardDialog.setModal(true);
        this.wizardDialog.pack();
        this.wizardDialog.setVisible(true);
        return this.returnCode;
    }

    public WizardModel getModel() {
        return this.wizardModel;
    }

    public void registerWizardPanel(Object id, WizardPanelDescriptor panel) {
        this.contentPanel.add(panel.getPanelComponent(), id);
        panel.setWizard(this);
        this.wizardModel.registerPanel(id, panel);
    }

    public void setCurrentPanel(Object id) {
        WizardPanelDescriptor oldPanelDescriptor;
        if (id == null) {
            this.close(2);
        }
        if ((oldPanelDescriptor = this.wizardModel.getCurrentPanelDescriptor()) != null) {
            oldPanelDescriptor.aboutToHidePanel();
        }
        this.wizardModel.setCurrentPanel(id);
        this.wizardModel.getCurrentPanelDescriptor().aboutToDisplayPanel();
        this.contentLayout.show(this.contentPanel, id.toString());
        String panelType = this.wizardModel.getCurrentPanelDescriptor().getButtonPanelType();
        this.buttonLayout.show(this.buttonPanel, panelType);
        this.wizardModel.getCurrentPanelDescriptor().displayingPanel();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        JButton button;
        String panelType = this.wizardModel.getCurrentPanelDescriptor().getButtonPanelType();
        if (evt.getPropertyName().equals("currentPanelDescriptorProperty")) {
            this.wizardController.resetButtonsToPanelRules();
        } else if (evt.getPropertyName().equals("nextButtonTextProperty")) {
            JButton button2 = this.nextButtons.get(panelType);
            if (button2 != null) {
                button2.setText(evt.getNewValue().toString());
            }
        } else if (evt.getPropertyName().equals("finishButtonTextProperty")) {
            JButton button3 = this.finishButtons.get(panelType);
            if (button3 != null) {
                button3.setText(evt.getNewValue().toString());
            }
        } else if (evt.getPropertyName().equals("backButtonTextProperty")) {
            JButton button4 = this.backButtons.get(panelType);
            if (button4 != null) {
                button4.setText(evt.getNewValue().toString());
            }
        } else if (evt.getPropertyName().equals("cancelButtonTextProperty")) {
            JButton button5 = this.cancelButtons.get(panelType);
            if (button5 != null) {
                button5.setText(evt.getNewValue().toString());
            }
        } else if (evt.getPropertyName().equals("nextButtonEnabledProperty")) {
            JButton button6 = this.nextButtons.get(panelType);
            if (button6 != null) {
                button6.setEnabled((Boolean)evt.getNewValue());
            }
        } else if (evt.getPropertyName().equals("finishButtonEnabledProperty")) {
            JButton button7 = this.finishButtons.get(panelType);
            if (button7 != null) {
                button7.setEnabled((Boolean)evt.getNewValue());
            }
        } else if (evt.getPropertyName().equals("backButtonEnabledProperty")) {
            JButton button8 = this.backButtons.get(panelType);
            if (button8 != null) {
                button8.setEnabled((Boolean)evt.getNewValue());
            }
        } else if (evt.getPropertyName().equals("cancelButtonEnabledProperty") && (button = this.cancelButtons.get(panelType)) != null) {
            button.setEnabled((Boolean)evt.getNewValue());
        }
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public boolean getBackButtonEnabled() {
        return this.wizardModel.getBackButtonEnabled();
    }

    public void setBackButtonEnabled(boolean newValue) {
        this.wizardModel.setBackButtonEnabled(new Boolean(newValue));
    }

    public boolean getNextButtonEnabled() {
        return this.wizardModel.getNextButtonEnabled();
    }

    public void setNextButtonEnabled(boolean newValue) {
        this.wizardModel.setNextButtonEnabled(new Boolean(newValue));
    }

    public boolean getFinishButtonEnabled() {
        return this.wizardModel.getFinishButtonEnabled();
    }

    public void setFinishButtonEnabled(boolean newValue) {
        this.wizardModel.setFinishButtonEnabled(new Boolean(newValue));
    }

    public boolean getCancelButtonEnabled() {
        return this.wizardModel.getCancelButtonEnabled();
    }

    public void setCancelButtonEnabled(boolean newValue) {
        this.wizardModel.setCancelButtonEnabled(new Boolean(newValue));
    }

    void close(int code) {
        this.returnCode = code;
        this.wizardDialog.dispose();
    }

    private void createButtonPanels() {
        this.buttonPanel = new JPanel();
        this.buttonLayout = new CardLayout();
        this.buttonPanel.setLayout(this.buttonLayout);
        JButton nButton = new JButton(NEXT_TEXT, VisualConstants.IMPORT_NEXT_ICON);
        JButton cButton = new JButton(CANCEL_TEXT, VisualConstants.IMPORT_CANCEL_ICON);
        nButton.setHorizontalTextPosition(2);
        nButton.setActionCommand(NEXT_BUTTON_ACTION_COMMAND);
        cButton.setActionCommand(CANCEL_BUTTON_ACTION_COMMAND);
        nButton.addActionListener(this.wizardController);
        cButton.addActionListener(this.wizardController);
        this.nextButtons.put(START_NAVIGATION_PANEL, nButton);
        this.cancelButtons.put(START_NAVIGATION_PANEL, cButton);
        JPanel flowPanel = new JPanel();
        flowPanel.setLayout(new FlowLayout(2));
        Box box = new Box(0);
        flowPanel.add(box);
        this.buttonPanel.add((Component)flowPanel, START_NAVIGATION_PANEL);
        box.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        box.add(nButton);
        box.add(Box.createHorizontalStrut(30));
        box.add(cButton);
        JButton bButton = new JButton(BACK_TEXT, VisualConstants.IMPORT_BACK_ICON);
        nButton = new JButton(NEXT_TEXT, VisualConstants.IMPORT_NEXT_ICON);
        cButton = new JButton(CANCEL_TEXT, VisualConstants.IMPORT_CANCEL_ICON);
        nButton.setHorizontalTextPosition(2);
        bButton.setActionCommand(BACK_BUTTON_ACTION_COMMAND);
        nButton.setActionCommand(NEXT_BUTTON_ACTION_COMMAND);
        cButton.setActionCommand(CANCEL_BUTTON_ACTION_COMMAND);
        bButton.addActionListener(this.wizardController);
        nButton.addActionListener(this.wizardController);
        cButton.addActionListener(this.wizardController);
        this.backButtons.put(NEXT_NAVIGATION_PANEL, bButton);
        this.nextButtons.put(NEXT_NAVIGATION_PANEL, nButton);
        this.cancelButtons.put(NEXT_NAVIGATION_PANEL, cButton);
        flowPanel = new JPanel();
        flowPanel.setLayout(new FlowLayout(2));
        box = new Box(0);
        flowPanel.add(box);
        this.buttonPanel.add((Component)flowPanel, NEXT_NAVIGATION_PANEL);
        box.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        box.add(bButton);
        box.add(Box.createHorizontalStrut(10));
        box.add(nButton);
        box.add(Box.createHorizontalStrut(30));
        box.add(cButton);
        bButton = new JButton(BACK_TEXT, VisualConstants.IMPORT_BACK_ICON);
        cButton = new JButton(CANCEL_TEXT, VisualConstants.IMPORT_CANCEL_ICON);
        JButton fButton = new JButton(FINISH_TEXT, VisualConstants.IMPORT_FINISH_ICON);
        fButton.setHorizontalTextPosition(2);
        bButton.setActionCommand(BACK_BUTTON_ACTION_COMMAND);
        cButton.setActionCommand(CANCEL_BUTTON_ACTION_COMMAND);
        fButton.setActionCommand(FINISH_BUTTON_ACTION_COMMAND);
        bButton.addActionListener(this.wizardController);
        cButton.addActionListener(this.wizardController);
        fButton.addActionListener(this.wizardController);
        this.backButtons.put(FINISH_NAVIGATION_PANEL, bButton);
        this.finishButtons.put(FINISH_NAVIGATION_PANEL, fButton);
        this.cancelButtons.put(FINISH_NAVIGATION_PANEL, cButton);
        flowPanel = new JPanel();
        flowPanel.setLayout(new FlowLayout(2));
        box = new Box(0);
        flowPanel.add(box);
        this.buttonPanel.add((Component)flowPanel, FINISH_NAVIGATION_PANEL);
        box.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        box.add(bButton);
        box.add(Box.createHorizontalStrut(10));
        box.add(fButton);
        box.add(Box.createHorizontalStrut(30));
        box.add(cButton);
        bButton = new JButton(BACK_TEXT, VisualConstants.IMPORT_BACK_ICON);
        nButton = new JButton(NEXT_TEXT, VisualConstants.IMPORT_NEXT_ICON);
        cButton = new JButton(CANCEL_TEXT, VisualConstants.IMPORT_CANCEL_ICON);
        fButton = new JButton(FINISH_TEXT, VisualConstants.IMPORT_FINISH_ICON);
        nButton.setHorizontalTextPosition(2);
        fButton.setHorizontalTextPosition(2);
        bButton.setActionCommand(BACK_BUTTON_ACTION_COMMAND);
        nButton.setActionCommand(NEXT_BUTTON_ACTION_COMMAND);
        cButton.setActionCommand(CANCEL_BUTTON_ACTION_COMMAND);
        fButton.setActionCommand(FINISH_BUTTON_ACTION_COMMAND);
        bButton.addActionListener(this.wizardController);
        nButton.addActionListener(this.wizardController);
        cButton.addActionListener(this.wizardController);
        fButton.addActionListener(this.wizardController);
        this.backButtons.put(FINISH_NEXT_NAVIGATION_PANEL, bButton);
        this.nextButtons.put(FINISH_NEXT_NAVIGATION_PANEL, nButton);
        this.finishButtons.put(FINISH_NEXT_NAVIGATION_PANEL, fButton);
        this.cancelButtons.put(FINISH_NEXT_NAVIGATION_PANEL, cButton);
        flowPanel = new JPanel();
        flowPanel.setLayout(new FlowLayout(2));
        box = new Box(0);
        flowPanel.add(box);
        this.buttonPanel.add((Component)flowPanel, FINISH_NEXT_NAVIGATION_PANEL);
        box.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        box.add(bButton);
        box.add(Box.createHorizontalStrut(10));
        box.add(nButton);
        box.add(Box.createHorizontalStrut(10));
        box.add(fButton);
        box.add(Box.createHorizontalStrut(30));
        box.add(cButton);
    }

    private void initComponents() {
        this.wizardModel.addPropertyChangeListener(this);
        this.wizardController = new WizardController(this);
        this.wizardDialog.getContentPane().setLayout(new BorderLayout());
        this.wizardDialog.addWindowListener(this);
        this.contentPanel = new JPanel();
        this.contentPanel.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        this.contentLayout = new CardLayout();
        this.contentPanel.setLayout(this.contentLayout);
        JPanel navigationPanel = new JPanel();
        navigationPanel.setLayout(new BorderLayout());
        JSeparator separator = new JSeparator();
        navigationPanel.add((Component)separator, "North");
        this.createButtonPanels();
        navigationPanel.add((Component)this.buttonPanel, "East");
        this.wizardDialog.getContentPane().add((Component)navigationPanel, "South");
        this.wizardDialog.getContentPane().add((Component)this.contentPanel, "Center");
    }

    public void windowClosing(WindowEvent e) {
        this.returnCode = 1;
    }
}

