/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.vdb;

import gov.nih.nlm.ncbi.vdb.klib.KDbg;
import gov.nih.nlm.ncbi.vdb.klib.VDBException;
import gov.nih.nlm.ncbi.vdb.klib.VDBObject;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.vdb.PathType;
import gov.nih.nlm.ncbi.vdb.vdb.VDBDependencies;

public class VDBManager
extends VDBObject {
    public static VDBManager make() throws VDBException {
        long obj = VDBManager.Make();
        if (obj == 0L) {
            throw new VDBException();
        }
        return new VDBManager(obj);
    }

    public VDBDependencies makeVDBDependencies(String path) throws VDBException {
        return VDBDependencies.make(this.getSelf(), path);
    }

    public PathType pathType(String path) {
        int type = VDBManager.PathType(this.getSelf(), path);
        PathType t = PathType.byId(type);
        if (KDbg.jni()) {
            SRAToolkit.errPrintln("VDBManager::pathType(" + path + ") = " + (Object)((Object)t));
        }
        return t;
    }

    @Override
    protected VDBObject create(long obj) {
        return new VDBManager(obj);
    }

    private VDBManager(long obj) {
        super(obj);
    }

    @Override
    protected native long Duplicate(long var1);

    @Override
    protected native boolean Release(long var1);

    private static native long Make();

    private static native int PathType(long var0, String var2);

    private static void duplicateAfterRelease() {
        try {
            SRAToolkit.setDebug();
            VDBManager mgr = null;
            SRAToolkit.debugPrintln("mgr = " + mgr);
            SRAToolkit.debugPrintln("calling VDBManager.make()");
            mgr = VDBManager.make();
            SRAToolkit.debugPrintln("mgr = " + mgr);
            SRAToolkit.debugPrintln("calling VDBManager.release()");
            mgr.release();
            SRAToolkit.debugPrintln("mgr = " + mgr);
            try {
                SRAToolkit.debugPrintln("calling VDBManager.duplicate()");
                VDBManager mgr2 = (VDBManager)mgr.duplicate();
                SRAToolkit.debugPrintln("mgr2 = " + mgr2);
            }
            catch (Exception e) {
                SRAToolkit.debugPrintln("expected exception: duplicate was called after release: " + e);
            }
        }
        catch (Exception e) {
            SRAToolkit.debugPrintln("Exception caught: " + e);
        }
    }

    private static void pathTypeTest() {
        try {
            SRAToolkit.setDebug();
            SRAToolkit.debugPrintln("calling VDBManager.make()");
            VDBManager mgr = VDBManager.make();
            SRAToolkit.debugPrintln("mgr = " + mgr);
            SRAToolkit.debugPrintln("calling VDBManager.duplicate()");
            VDBManager mgr2 = (VDBManager)mgr.duplicate();
            SRAToolkit.debugPrintln("mgr2 = " + mgr2);
            SRAToolkit.debugPrintln("calling VDBManager.release()");
            mgr.release();
            SRAToolkit.debugPrintln("mgr = " + mgr);
            String path = null;
            PathType t = mgr2.pathType(path);
            SRAToolkit.debugPrintln("pathType(" + path + ") = " + (Object)((Object)t));
            if (t != PathType.UNKNOWN) {
                throw new Exception("Unexpected type for " + path);
            }
            t = mgr2.pathType(path);
            SRAToolkit.debugPrintln("pathType(" + path + ") = " + (Object)((Object)t));
            if (t != PathType.TABLE) {
                throw new Exception("Unexpected type for " + path);
            }
            t = mgr2.pathType(path);
            SRAToolkit.debugPrintln("pathType(" + path + ") = " + (Object)((Object)t));
            if (t != PathType.DATABASE) {
                throw new Exception("Unexpected type for " + path);
            }
            t = mgr2.pathType(path);
            SRAToolkit.debugPrintln("pathType(" + path + ") = " + (Object)((Object)t));
            SRAToolkit.debugPrintln("calling VDBManager2.release()");
            mgr2.release();
            SRAToolkit.debugPrintln("mgr2 = " + mgr2);
            SRAToolkit.debugPrintln("calling VDBManager.release2()");
            mgr.release();
            SRAToolkit.debugPrintln("mgr = " + mgr);
            SRAToolkit.debugPrintln("calling VDBManager2.release2()");
            mgr2.release();
            SRAToolkit.debugPrintln("mgr2 = " + mgr2);
        }
        catch (Exception e) {
            SRAToolkit.debugPrintln("Exception caught: " + e);
        }
    }
}

