/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.vdb;

import gov.nih.nlm.ncbi.vdb.klib.KDbg;
import gov.nih.nlm.ncbi.vdb.klib.KRef;
import gov.nih.nlm.ncbi.vdb.klib.VDBDuplicateException;
import gov.nih.nlm.ncbi.vdb.klib.VDBMakeException;
import gov.nih.nlm.ncbi.vdb.klib.VDBObject;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.RefseqItf;
import gov.nih.nlm.ncbi.vdb.sratoolkit.util.logging.Handler;
import gov.nih.nlm.ncbi.vdb.vdb.VDBDependenciesFeedback;

public class VDBDependencies
extends VDBObject
implements RefseqItf {
    private VDBDependenciesFeedback feedback;

    static VDBDependencies make(long mgr, String path) throws VDBMakeException {
        VDBDependenciesFeedback feedback = new VDBDependenciesFeedback();
        long obj = VDBDependencies.Make(mgr, path, feedback);
        if (KDbg.jni()) {
            SRAToolkit.errPrintln("VDBDependencies::make(" + path + ") = " + obj);
        }
        if (obj == 0L) {
            throw new VDBMakeException();
        }
        return new VDBDependencies(obj, feedback);
    }

    @Override
    public KRef duplicate() throws VDBDuplicateException {
        long dup = this.Duplicate(this.getSelf());
        if (dup == 0L) {
            throw new VDBDuplicateException();
        }
        return new VDBDependencies(dup, this.feedback);
    }

    @Override
    public int getCount() {
        if (this.getSelf() == 0L) {
            return 0;
        }
        return VDBDependencies.Count(this.getSelf());
    }

    @Override
    public String getSeqId(int idx) throws Exception {
        this.selfCheck();
        return VDBDependencies.SeqId(this.getSelf(), idx);
    }

    @Override
    public String getPathLocal(int idx) throws Exception {
        return this.getPath(idx);
    }

    @Override
    public String getPathRemote(int idx) throws Exception {
        this.selfCheck();
        String result = VDBDependencies.PathRemote(this.getSelf(), idx);
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    public String getPathCache(int idx) throws Exception {
        this.selfCheck();
        String result = VDBDependencies.PathCache(this.getSelf(), idx);
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    public boolean isLocal(int idx) throws Exception {
        this.selfCheck();
        return VDBDependencies.Local(this.getSelf(), idx);
    }

    public String getPath(int idx) throws Exception {
        this.selfCheck();
        String result = VDBDependencies.Path(this.getSelf(), idx);
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    protected VDBObject create(long obj) {
        Handler.reportError("VDBDependencies.create() should not be called");
        return null;
    }

    private VDBDependencies(long obj, VDBDependenciesFeedback feedback) {
        super(obj);
    }

    private void selfCheck() throws Exception {
        if (this.getSelf() == 0L) {
            throw new Exception("Trying to access VDBDependencies data with count == 0");
        }
    }

    @Override
    protected native long Duplicate(long var1);

    @Override
    protected native boolean Release(long var1);

    private static native long Make(long var0, String var2, VDBDependenciesFeedback var3);

    private static native int Count(long var0);

    private static native boolean Local(long var0, int var2);

    private static native String Name(long var0, int var2);

    private static native String Path(long var0, int var2);

    private static native String PathRemote(long var0, int var2);

    private static native String PathCache(long var0, int var2);

    private static native String SeqId(long var0, int var2);
}

