/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl;

import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.RefseqItf;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.Refseq;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.RefseqFactory;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.RefseqList;
import gov.nih.nlm.ncbi.vdb.sratoolkit.util.logging.Handler;

class ResolvedRefseqList
extends RefseqList {
    ResolvedRefseqList(RefseqItf papa) {
        this.addAll(papa);
    }

    @Override
    protected void addAll(RefseqItf papa) {
        if (papa == null) {
            return;
        }
        int count = papa.getCount();
        for (int i = 0; i < count; ++i) {
            try {
                boolean local = papa.isLocal(i);
                if (!local) {
                    String seqId = papa.getSeqId(i);
                    String path = papa.getPathLocal(i);
                    String remote = papa.getPathRemote(i);
                    String cache = papa.getPathCache(i);
                    Refseq refseq = RefseqFactory.makeRefseq(local, seqId, path, remote, cache);
                    Handler.reportStatusDbg(refseq.toString(true));
                    this.add(refseq);
                    continue;
                }
                ++this.localCount;
                continue;
            }
            catch (Exception e) {
                SRAToolkit.errPrintln(e);
            }
        }
    }
}

