/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl;

import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.io.OrphanFile;
import gov.nih.nlm.ncbi.vdb.sratoolkit.net.WebAccessor;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.ResolvedPath;
import gov.nih.nlm.ncbi.vdb.sratoolkit.util.logging.Handler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.util.Random;

public abstract class RefseqWebRepository {
    protected String local;
    protected String remote;
    private Random random;

    RefseqWebRepository(String local, String remote, boolean mkLocal) throws Exception {
        this.local = local;
        if (local == null) {
            if (mkLocal) {
                throw new NullPointerException("local is null in RefseqWebRepository()");
            }
        } else {
            File f = new File(local);
            if (!f.exists()) {
                if (mkLocal) {
                    if (!f.mkdirs()) {
                        throw new Exception("Cannot mkdirs " + local);
                    }
                } else {
                    throw new Exception("Cannot find " + local);
                }
            }
        }
        this.remote = remote;
        this.random = new Random();
    }

    Status contains(ResolvedPath obj) {
        File f = new File(this.getPathCache(obj));
        if (f.exists() && f.length() > 0L) {
            try {
                int sz = this.getSize(obj);
                if ((long)sz != f.length()) {
                    return Status.NEEDS_DOWNLOAD;
                }
                return Status.CONTAINS;
            }
            catch (Exception e) {
                SRAToolkit.stackTracePrint(e);
                return Status.ERROR;
            }
        }
        return Status.NEEDS_DOWNLOAD;
    }

    public String download(String name) throws Exception {
        String local = this.local + File.separator + name;
        return this.download(this.remote + File.separator + name, local);
    }

    String download(String from, String to) throws Exception {
        String lock = this.mkLockName(to);
        String tmp = this.mkTmpName(to);
        OrphanFile fLock = new OrphanFile(lock);
        if (fLock.exists()) {
            long date = fLock.lastModified();
            long t = (System.currentTimeMillis() - date) / 1000L;
            if (t < 86400L) {
                Handler.reportStatusDbg(lock + " found: canceling download");
                Handler.reportWarning("Lock file " + lock + " exists: download canceled");
                return null;
            }
            Handler.reportStatusDbg(lock + " found and ignored as too old");
            this.clean(to, null, null, true);
        } else {
            Handler.reportStatusDbg(lock + " not found");
        }
        Handler.reportStatusDbg("creating " + lock);
        fLock.createNewFile();
        fLock.setLastModified(System.currentTimeMillis());
        boolean ok = WebAccessor.download(from, tmp);
        if (ok) {
            Handler.reportStatusDbg("renaming " + tmp + " -> " + to);
            File f1 = new File(tmp);
            if (!f1.exists()) {
                throw new FileNotFoundException(tmp);
            }
            File f2 = new File(to);
            ok = f1.renameTo(f2);
        }
        this.clean(to, fLock, tmp, !ok);
        if (ok) {
            return to;
        }
        return null;
    }

    abstract int getSize(ResolvedPath var1) throws Exception;

    abstract String download(ResolvedPath var1) throws Exception;

    abstract String getPackedPath(String var1);

    abstract String getPathCache(ResolvedPath var1);

    abstract String getPathRemote(ResolvedPath var1);

    private void clean(String cache, File lock, String tmp, boolean rmSelf) {
        File f;
        String tmpName = this.mkTmpPrefix(cache);
        File fTmpName = new File(tmpName);
        File dir = fTmpName.getParentFile();
        final String tmpPfx = fTmpName.getName();
        if (tmp != null && (f = new File(tmp)).exists()) {
            Handler.reportStatusDbg("removing " + tmp);
            f.delete();
        }
        if (rmSelf && (f = new File(cache)).exists()) {
            Handler.reportStatusDbg("removing " + cache);
            f.delete();
        }
        Handler.reportStatusDbg("listing " + dir.getAbsolutePath() + " for old temporary files");
        File[] tmps = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(tmpPfx);
            }
        });
        for (int i = 0; i < tmps.length; ++i) {
            Handler.reportStatusDbg("removing " + tmps[i].getAbsolutePath());
            tmps[i].delete();
        }
        if (lock != null) {
            Handler.reportStatusDbg("removing " + lock.getAbsolutePath());
            lock.delete();
        }
    }

    private String mkTmpPrefix(String prefix) {
        return prefix + ".tmp";
    }

    private String mkTmpName(String prefix) throws Exception {
        for (int i = 0; i < 999; ++i) {
            String name = this.mkTmpPrefix(prefix) + "." + this.random.nextInt(100000) + ".tmp";
            if (new File(name).exists()) continue;
            return name;
        }
        throw new Exception("Cannot generate tmp file name for " + prefix);
    }

    private String mkLockName(String prefix) {
        return prefix + ".lock";
    }

    static enum Status {
        CONTAINS,
        NEEDS_DOWNLOAD,
        ERROR;

    }
}

