/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl;

import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.ResolvedPath;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.RefseqWebRepository;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.SraCache;

public class RefseqRepository {
    private RefseqWebRepository impl;
    private SraCache cache = new SraCache();

    protected boolean pack(ResolvedPath obj) {
        return false;
    }

    RefseqRepository(RefseqWebRepository remote) {
        this.impl = remote;
    }

    public boolean contains(ResolvedPath obj) {
        return this.resolve(obj, Force.FALSE);
    }

    public boolean download(ResolvedPath obj) {
        return this.resolve(obj, Force.TRUE);
    }

    public boolean resolveNoCache(ResolvedPath obj) {
        return this.resolve(obj, Force.NO_CACHE);
    }

    private boolean resolve(ResolvedPath obj, Force force) {
        this.pack(obj);
        if (force == Force.FALSE && this.cache.contains(obj)) {
            return true;
        }
        boolean ok = false;
        boolean toDownload = false;
        if (force == Force.TRUE) {
            toDownload = true;
        } else {
            RefseqWebRepository.Status status = this.impl.contains(obj);
            if (status == RefseqWebRepository.Status.NEEDS_DOWNLOAD) {
                toDownload = true;
            } else if (status == RefseqWebRepository.Status.CONTAINS) {
                ok = true;
            }
        }
        try {
            String local;
            if (toDownload && force != Force.FALSE && (local = this.impl.download(obj)) != null) {
                ok = true;
            }
        }
        catch (Exception e) {
            SRAToolkit.stackTracePrint(e);
        }
        if (ok) {
            this.cache.add(obj);
        }
        return ok;
    }

    private static enum Force {
        FALSE,
        NO_CACHE,
        TRUE;

    }
}

