/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl;

import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.FlatRefseqWebRepository;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.NonFlatRefseqWebRepository;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.PackedRefseqList;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.PackedRefseqRepository;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.PackedTestRefseqList;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.Refseq;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.RefseqList;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.RefseqPackedHelper;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.RefseqRepository;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.RefseqWebRepository;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.ResolvedRefseq;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.ResolvedRefseqList;
import gov.nih.nlm.ncbi.vdb.vdb.VDBDependencies;

public class RefseqFactory {
    private Pack type;
    private RefseqPackedHelper packed;
    private String testLocal;
    private String testRemote;

    public static RefseqFactory make() {
        return new RefseqFactory(Pack.NONE);
    }

    public static RefseqFactory makeWithPackingAfterListing(RefseqPackedHelper packed) {
        return new RefseqFactory(Pack.AFTER_LISTING, packed);
    }

    public static RefseqFactory makeWithPackingBeforeDownload(RefseqPackedHelper packed) {
        return new RefseqFactory(Pack.BEFORE_DOWNLOAD, packed);
    }

    public static RefseqFactory makeWithTestPackingAfterListing(RefseqPackedHelper packed, String local, String remote) {
        return new RefseqFactory(Pack.TEST_AFTER_LISTING, packed, local, remote);
    }

    public static RefseqFactory makeResolved() {
        return new RefseqFactory(Pack.ALREADY_RESOLVED);
    }

    private RefseqFactory(Pack type) {
        this(type, null);
    }

    private RefseqFactory(Pack type, RefseqPackedHelper packed) {
        this(type, packed, null, null);
    }

    private RefseqFactory(Pack type, RefseqPackedHelper packed, String local, String remote) {
        this.type = type;
        this.packed = packed;
        this.testLocal = local;
        this.testRemote = remote;
    }

    static Refseq makeRefseq(boolean local, String seqId, String pathLocal) {
        return new Refseq(local, seqId, pathLocal);
    }

    static Refseq makeRefseq(boolean local, String seqId, String pathLocal, String pathRemote, String pathCache) throws Exception {
        return new ResolvedRefseq(local, seqId, pathLocal, pathRemote, pathCache);
    }

    public static RefseqWebRepository makeFlatWebRepository(String local, String remote, boolean mkLocal) throws Exception {
        return new FlatRefseqWebRepository(local, remote, mkLocal);
    }

    public static RefseqWebRepository makeNonFlatWebRepository() throws Exception {
        return new NonFlatRefseqWebRepository(null, null, false);
    }

    public static RefseqWebRepository makeNonFlatWebRepository(String local, String remote, boolean mkLocal) throws Exception {
        return new NonFlatRefseqWebRepository(local, remote, mkLocal);
    }

    public RefseqList makeList() {
        return this.makeList(null);
    }

    public RefseqList makeList(VDBDependencies dep) {
        switch (this.type) {
            case AFTER_LISTING: {
                return PackedRefseqList.make(dep, this.packed);
            }
            case TEST_AFTER_LISTING: {
                return new PackedTestRefseqList(dep, this.packed, this.testLocal, this.testRemote);
            }
            case ALREADY_RESOLVED: {
                return new ResolvedRefseqList(dep);
            }
        }
        return RefseqList.make(dep);
    }

    public RefseqRepository makeRepository(RefseqWebRepository remote) {
        switch (this.type) {
            case BEFORE_DOWNLOAD: {
                return new PackedRefseqRepository(remote, this.packed);
            }
        }
        return new RefseqRepository(remote);
    }

    private static enum Pack {
        NONE,
        AFTER_LISTING,
        BEFORE_DOWNLOAD,
        TEST_AFTER_LISTING,
        ALREADY_RESOLVED;

    }
}

