/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl;

import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.ResolvedPath;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.PackVisitor;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.RefseqPackedHelper;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.RefseqRepository;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.RefseqWebRepository;

class PackedRefseqRepository
extends RefseqRepository {
    private RefseqPackedHelper packed;

    PackedRefseqRepository(RefseqWebRepository remote, RefseqPackedHelper packed) {
        super(remote);
        this.packed = packed;
    }

    @Override
    protected boolean pack(ResolvedPath obj) {
        String packedName = this.packed.packedFileName(obj.accession());
        if (packedName != null) {
            SRAToolkit.errPrintln("PackedRefseqRepository::resolve: setPackedSeqFile " + packedName);
            PackVisitor v = new PackVisitor(packedName);
            if (!obj.accept(v)) {
                SRAToolkit.errPrintln("Bad object type in PackedRefseqRepository::pack: " + obj);
            }
            SRAToolkit.errPrintln("PackedRefseqRepository::resolve: cache " + obj.cache());
            return true;
        }
        return false;
    }
}

