/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl;

import gov.nih.nlm.ncbi.vdb.sratoolkit.net.WebAccessor;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.ResolvedPath;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.PathVisitor;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.RefseqWebRepository;
import java.io.File;
import java.io.IOException;

class FlatRefseqWebRepository
extends RefseqWebRepository {
    FlatRefseqWebRepository(String local, String remote, boolean mkLocal) throws Exception {
        super(local, remote, mkLocal);
    }

    boolean hasConnection() {
        return WebAccessor.canConnect(this.remote);
    }

    @Override
    int getSize(ResolvedPath obj) throws IOException {
        return WebAccessor.getSize(this.getPathRemote(obj));
    }

    @Override
    String download(ResolvedPath obj) throws Exception {
        String local = this.getPathCache(obj);
        return this.download(this.getPathRemote(obj), local);
    }

    @Override
    String getPackedPath(String name) {
        return this.getPathCache(name);
    }

    @Override
    String getPathCache(ResolvedPath obj) {
        PathVisitor v = new PathVisitor();
        obj.accept(v);
        return this.getPathCache(v.getSeqIdFile());
    }

    @Override
    String getPathRemote(ResolvedPath obj) {
        PathVisitor v = new PathVisitor();
        obj.accept(v);
        return this.remote + File.separator + v.getSeqIdFile();
    }

    private String getPathCache(String name) {
        return this.local + File.separator + name;
    }
}

