/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.refseq;

import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.net.WebAccessor;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.ResolvedPathVisitor;
import gov.nih.nlm.ncbi.vdb.sratoolkit.util.logging.Handler;
import java.io.File;
import java.io.IOException;

public abstract class ResolvedPath {
    private Long remoteSize;

    public abstract String accession();

    public abstract String local();

    public abstract String remote();

    public abstract String cache();

    public Long remoteSize() {
        return this.remoteSize;
    }

    public boolean foundLocally() {
        boolean found;
        String local = this.local();
        if (local == null) {
            return false;
        }
        if (local.length() == 0) {
            return false;
        }
        long sLocal = 0L;
        File fLocal = new File(local);
        if (fLocal.exists() && (sLocal = fLocal.length()) == 0L) {
            Handler.reportStatusTop(local + " is empty. It will be re-downloaded");
            return false;
        }
        if (!fLocal.isFile()) {
            Handler.reportStatusTop(local + " (not a file) is found locally: consider it complete");
            return true;
        }
        if (this.remoteSize == null) {
            try {
                boolean found2;
                long sRemote = WebAccessor.getSize(this.remote());
                if (sRemote == 0L) {
                    Handler.reportStatusTop("Cannot check remote file size for " + local + ": consider it complete");
                    return true;
                }
                this.remoteSize = new Long(sRemote);
                boolean bl = found2 = sLocal == sRemote;
                if (found2) {
                    Handler.reportStatusTop(local + "(" + sLocal + ") is found and is complete");
                } else {
                    Handler.reportStatusTop(local + "(" + sLocal + ") is incomplete. Expected size is " + sRemote + ". It will be re-downloaded");
                }
                return found2;
            }
            catch (IOException e) {
                SRAToolkit.stackTracePrint(e);
                Handler.reportStatusTop(e + " Cannot check remote file size for " + local + ": consider it complete");
                return true;
            }
        }
        boolean bl = found = sLocal == this.remoteSize;
        if (found) {
            Handler.reportStatusInfo(local + "(" + sLocal + ") is found and is complete");
        } else {
            Handler.reportStatusTop(local + "(" + sLocal + ") is incomplete. Expected size is " + this.remoteSize + ". It will be re-downloaded");
        }
        return found;
    }

    public boolean accept(ResolvedPathVisitor v) {
        return true;
    }

    String toString(boolean detailed) {
        return this.toString();
    }
}

