/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.refseq;

import gov.nih.nlm.ncbi.vdb.kfg.KConfig;
import gov.nih.nlm.ncbi.vdb.klib.VDBException;
import gov.nih.nlm.ncbi.vdb.klib.VDBMakeException;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.Args;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.ResolvedPath;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.VDBManagerProxy;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.VResolverProxy;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.VResolverResult;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.Refseq;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.RefseqFactory;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.RefseqList;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.RefseqPackedHelper;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.RefseqRepository;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.RefseqWebRepository;
import gov.nih.nlm.ncbi.vdb.sratoolkit.util.logging.Handler;
import gov.nih.nlm.ncbi.vdb.vdb.PathType;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Iterator;

public class RefseqMgr {
    private KConfig m_cfg;
    private VDBManagerProxy mgr;
    private RefseqRepository repository;
    private RefseqFactory factory;
    private VResolverProxy resolver;
    private static boolean detailed;

    public RefseqMgr() throws Exception {
        this(null);
    }

    public RefseqMgr(KConfig cfg) throws Exception {
        this(null, null, Type.RESOLVED, cfg);
    }

    public RefseqMgr(String local, String remote, KConfig cfg) throws Exception {
        this(local, remote, Type.FLAT, cfg);
    }

    private RefseqMgr(String local, String remote, Type type, KConfig cfg) throws Exception {
        RefseqWebRepository web = null;
        switch (type) {
            case FLAT: {
                web = RefseqFactory.makeFlatWebRepository(local, remote, true);
                break;
            }
            case RESOLVED: {
                web = RefseqFactory.makeNonFlatWebRepository();
                break;
            }
            default: {
                web = RefseqFactory.makeNonFlatWebRepository(local, remote, true);
            }
        }
        RefseqPackedHelper packed = null;
        if (type != Type.RESOLVED) {
            String fPacked = web.download("packed.txt");
            packed = new RefseqPackedHelper(fPacked);
        }
        switch (type) {
            case FLAT: {
                this.factory = RefseqFactory.makeWithPackingAfterListing(packed);
                break;
            }
            case NON_FLAT: {
                this.factory = RefseqFactory.makeWithTestPackingAfterListing(packed, local, remote);
                break;
            }
            default: {
                this.factory = RefseqFactory.makeResolved();
            }
        }
        this.mgr = new VDBManagerProxy(this.factory);
        if (this.mgr == null) {
            throw new Exception("failure during VDBManagerProxy creating");
        }
        this.repository = this.factory.makeRepository(web);
        if (cfg == null) {
            this.m_cfg = cfg = KConfig.make();
        }
        this.resolver = new VResolverProxy(cfg);
    }

    protected void finalize() throws Throwable {
        if (this.m_cfg == null) {
            return;
        }
        this.m_cfg.release();
    }

    public RefseqList listReferences(String path) throws FileNotFoundException {
        if (path == null) {
            throw new NullPointerException();
        }
        Handler.reportStatusInfo("Listing " + path + " dependencies...");
        return this.listReferences(new File(path));
    }

    public RefseqList listReferences(String[] paths) {
        RefseqList result = this.factory.makeList();
        for (int i = 0; i < paths.length; ++i) {
            try {
                result.addAll(this.listReferences(paths[i]));
                continue;
            }
            catch (FileNotFoundException e) {
                Handler.reportError(e);
            }
        }
        return result;
    }

    public RefseqList listReferences(Iterator<String> paths) {
        RefseqList result = this.factory.makeList();
        while (paths.hasNext()) {
            try {
                result.addAll(this.listReferences(paths.next()));
            }
            catch (FileNotFoundException e) {
                Handler.reportError(e);
            }
        }
        return result;
    }

    public RefseqList _listReferences(String path) throws FileNotFoundException {
        if (path == null) {
            throw new NullPointerException();
        }
        RefseqList res = this.factory.makeList();
        PathType type = this.mgr.pathType(path);
        switch (type) {
            case TABLE: {
                Handler.reportStatusInfo(path + " is a TABLE: skipping.");
                break;
            }
            case DATABASE: {
                Handler.reportStatusInfo(path + " is a DATABASE: listing dependencies...");
                RefseqList found = this.listObjReferences(path);
                int s = found.externalCount();
                int u = found.unresolvedCount();
                Handler.reportStatusInfo("DATABASE " + path + " has " + s + " external reference" + (s == 1 ? "" : "s") + " (" + u + " unresolved)");
                res.addAll(found);
                break;
            }
            case DIR: {
                Handler.reportStatusInfo(path + " is a directory: going in...");
                res.addAll(this.listDirReferences(new File(path)));
                break;
            }
            default: {
                Handler.reportStatusInfo(path + " is neither directory nor database(" + (Object)((Object)type) + "): skipping.");
            }
        }
        return res;
    }

    public RefseqList listReferences(File file) throws FileNotFoundException {
        if (file == null) {
            throw new NullPointerException();
        }
        String path = file.getAbsolutePath();
        if (!file.exists()) {
            throw new FileNotFoundException(path + " not found");
        }
        RefseqList res = this.factory.makeList();
        PathType type = this.mgr.pathType(file);
        switch (type) {
            case TABLE: {
                Handler.reportStatusInfo(path + " is a TABLE: skipping.");
                break;
            }
            case DATABASE: {
                Handler.reportStatusInfo(path + " is a DATABASE: listing dependencies...");
                RefseqList found = this.listObjReferences(path);
                int s = found.externalCount();
                int u = found.unresolvedCount();
                Handler.reportStatusInfo("DATABASE " + path + " has " + s + " external reference" + (s == 1 ? "" : "s") + " (" + u + " unresolved)");
                res.addAll(found);
                break;
            }
            default: {
                if (file.isDirectory()) {
                    Handler.reportStatusInfo(path + " is a directory: going in...");
                    res.addAll(this.listDirReferences(file));
                    break;
                }
                Handler.reportStatusInfo(path + " is neither directory nor database: skipping.");
            }
        }
        return res;
    }

    public boolean resolve(RefseqList refseqs) {
        boolean ok = true;
        Iterator<Refseq> it = refseqs.externalIterator();
        while (it.hasNext()) {
            Refseq r = it.next();
            if (r.isResolved()) continue;
            ok &= this.repository.resolveNoCache(r);
        }
        return ok;
    }

    public boolean resolve(ResolvedPath obj) {
        Handler.reportStatusDbg("resolve " + obj.toString(true));
        return this.repository.resolveNoCache(obj);
    }

    public boolean download(ResolvedPath obj) {
        Handler.reportStatusDbg("download " + obj.toString(true));
        return this.repository.download(obj);
    }

    public VResolverResult resolveSra(String accession) throws Exception {
        VResolverResult paths = this.resolver.resolveAcc(accession);
        return paths;
    }

    public VResolverResult resolveUrl(String url) throws Exception {
        VResolverResult paths = this.resolver.resolveUrl(url);
        return paths;
    }

    private boolean list(String path) throws FileNotFoundException {
        RefseqList l = this.listReferences(path);
        if (l.count() > 0) {
            SRAToolkit.debugPrintln(path + " " + l.toString(detailed));
        }
        return true;
    }

    private boolean resolve(String path) throws FileNotFoundException {
        boolean ok = true;
        RefseqList l = this.listReferences(path);
        int i = 0;
        Iterator<Refseq> it = l.externalIterator();
        while (it.hasNext()) {
            SRAToolkit.debugPrintln(i++);
            Refseq r = it.next();
            SRAToolkit.debugPrintln(r);
            SRAToolkit.debugPrintln("SeqIdFile = " + r.getSeqIdFile());
            SRAToolkit.debugPrintln("resolveNoCache " + r.toString(true));
            ok &= this.repository.resolveNoCache(r);
        }
        l = this.listReferences(path);
        it = l.externalIterator();
        while (it.hasNext()) {
            SRAToolkit.debugPrintln(it.next());
        }
        return ok;
    }

    private RefseqList listObjReferences(String path) {
        try {
            return this.mgr.listDependencies(path);
        }
        catch (VDBMakeException e) {
            Handler.reportError("Failed to list dependencied of " + path);
        }
        catch (VDBException e) {
            Handler.reportError(e);
        }
        return this.factory.makeList();
    }

    private RefseqList listDirReferences(File dir) {
        RefseqList res = this.factory.makeList();
        File[] files = dir.listFiles();
        if (files == null) {
            Handler.reportError(dir.getAbsolutePath() + ".listFiles() = null");
        }
        for (int i = 0; i < files.length; ++i) {
            try {
                res.addAll(this.listReferences(files[i].getAbsolutePath()));
                continue;
            }
            catch (FileNotFoundException e) {
                Handler.reportError(e);
            }
        }
        return res;
    }

    private static void test(RefseqMgr mgr, String path) throws FileNotFoundException {
        SRAToolkit.debugPrintln("testing " + path);
        RefseqList l = mgr.listReferences(path);
        SRAToolkit.debugPrintln("references(" + path + ") = " + l);
        SRAToolkit.debugPrintln();
    }

    public static void main(String[] args) {
        block14: {
            SRAToolkit.setDebug();
            System.loadLibrary("vdb_jni");
            try {
                String home = System.getenv("HOME");
                if (home == null) {
                    home = System.getenv("USERPROFILE");
                }
                if (home == null) {
                    SRAToolkit.debugPrintln("Homeless");
                    System.exit(1);
                }
                RefseqMgr mgr = new RefseqMgr();
                if (args.length == 0) {
                    Handler.muteStatus();
                    detailed = false;
                    break block14;
                }
                if (args[0].equals("list")) {
                    for (int i = 1; i < args.length; ++i) {
                        if (Args.processArg(args[i])) continue;
                        Handler.muteStatus();
                        if (new File(args[i]).exists()) {
                            RefseqList l = mgr.listReferences(args[i]);
                            SRAToolkit.debugPrintln(args[i] + " has " + l.count() + " reference[s] : " + l.externalCount() + " external + " + l.localCount() + " local:");
                            SRAToolkit.debugPrintln(l.resolvedCount() + " resolved + " + l.unresolvedCount() + " unresolved: ");
                            Iterator<Refseq> it = l.externalIterator();
                            while (it.hasNext()) {
                                Refseq r = it.next();
                                SRAToolkit.debugPrintln(r + (r.isResolved() ? ": resolved" : ": unresolved"));
                            }
                            continue;
                        }
                        SRAToolkit.debugPrintln(mgr.resolveSra(args[i]));
                    }
                    break block14;
                }
                if (args[0].equals("resolve")) {
                    for (int i = 1; i < args.length; ++i) {
                        if (Args.processArg(args[i])) continue;
                        RefseqList l = mgr.listReferences(args[i]);
                        SRAToolkit.debugPrintln(args[i] + " has " + l.count() + " reference[s] : " + l.externalCount() + " external + " + l.localCount() + " local:");
                        SRAToolkit.debugPrintln(l.resolvedCount() + " resolved + " + l.unresolvedCount() + " unresolved");
                        SRAToolkit.debugPrintln("Resolving...");
                        mgr.resolve(l);
                        l = mgr.listReferences(args[i]);
                        SRAToolkit.debugPrintln(args[i] + " has " + l.count() + " reference[s] : " + l.externalCount() + " external + " + l.localCount() + " local:");
                        SRAToolkit.debugPrintln(l.resolvedCount() + " resolved + " + l.unresolvedCount() + " unresolved");
                    }
                } else {
                    for (int i = 0; i < args.length; ++i) {
                        if (args[i].equals("detailed")) {
                            detailed = true;
                            continue;
                        }
                        mgr.resolve(args[i]);
                    }
                }
            }
            catch (Exception e) {
                SRAToolkit.debugPrintln("Exception caught: " + e);
                SRAToolkit.stackTracePrint(e);
            }
        }
        SRAToolkit.debugPrintln("exiting main");
    }

    static enum Type {
        FLAT,
        NON_FLAT,
        RESOLVED;

    }
}

