/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.gui;

import gov.nih.nlm.ncbi.vdb.kfg.KConfig;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.Command;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.SRAToolkitConsole;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.SRAToolkitRepositoryPreferences;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;

public class SRAToolkitPreferences
extends JFrame {
    private KConfig kfg;
    private SRAToolkit app;
    private SRAToolkitConsole console;
    private JTabbedPane tPane;

    public SRAToolkitPreferences(SRAToolkitConsole _console, SRAToolkit _app) {
        super("Preferences");
        this.setLayout(new BorderLayout());
        this.app = _app;
        this.console = _console;
        try {
            this.kfg = KConfig.make();
        }
        catch (Exception e) {
            SRAToolkit.stackTracePrint(e);
        }
        this.buildTabPane();
        this.add((Component)this.tPane, "Center");
        this.setSize(600, 400);
        this.setVisible(true);
    }

    public void readyToUpdate() {
        if (this.app != null) {
            SRAToolkit.debugPrintln("ready to update...");
            Command first = SRAToolkit.makeCreateDirectoriesCommand(this.app);
            Command second = SRAToolkitConsole.makeUpdateConsoleCommand(this.app, this.console);
            try {
                this.app.addToEventQueue(Command.makeSerialCommandPair(first, second));
            }
            catch (Exception e) {
                SRAToolkit.stackTracePrint(e);
            }
        } else {
            SRAToolkit.debugPrintln("app is null");
        }
    }

    public void closePreferences() {
        try {
            this.kfg.release();
            this.dispose();
        }
        catch (Exception e) {
            SRAToolkit.stackTracePrint(e);
        }
    }

    private void buildTabPane() {
        this.tPane = new JTabbedPane();
        SRAToolkitRepositoryPreferences rep = SRAToolkitRepositoryPreferences.make(this, this.kfg);
        this.tPane.addTab("Repository", rep);
    }
}

