/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.gui;

import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkitNode;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.RightPanelColumnView;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.SRAToolkitConsole;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.SRAToolkitConsoleShell;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SRAToolkitConsoleRightPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private SRAToolkit app;
    private SRAToolkitConsole console;
    private RightPanelColumnView columns;
    private SRAToolkitConsoleShell shell;
    private JTabbedPane tPane;
    private int view = 0;

    public SRAToolkitConsoleRightPanel(SRAToolkit _app, SRAToolkitConsole _console) {
        this.setLayout(new BorderLayout());
        this.app = _app;
        this.console = _console;
        this.tPane = new JTabbedPane();
        SRAToolkitNode root = this.app.getSelectedRoot();
        if (root != null) {
            this.columns = new RightPanelColumnView(this, root);
            this.tPane.addTab("Columns", this.columns);
        } else {
            SRAToolkit.debugPrintln("Selected root is NULL - wont build right panel");
        }
        try {
            this.shell = new SRAToolkitConsoleShell(this.app.getShell());
        }
        catch (Exception e) {
            SRAToolkit.stackTracePrint(e);
        }
        this.tPane.addTab("Shell", this.shell);
        this.tPane.addChangeListener(new TabChangeListener());
        this.setPreferredSize(new Dimension(770, 900));
        this.add((Component)this.tPane, "Center");
    }

    public void relayEventToConsole(String which, Object obj) {
        this.console.interpretEvent(which, obj);
    }

    public void updateTree(SRAToolkitNode _root) {
        SRAToolkitNode root = _root;
        this.columns = new RightPanelColumnView(this, root);
        this.tPane.setComponentAt(0, this.columns);
    }

    class TabChangeListener
    implements ChangeListener {
        TabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
        }
    }
}

