/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.gui;

import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.SRAToolkitConsole;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.SRAToolkitPreferences;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.Version;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SRAToolkitConsoleMenuBar
extends JPanel {
    private static final long serialVersionUID = 1L;
    private SRAToolkit app;
    private SRAToolkitConsole console;

    private JMenu buildToolkitTab() {
        JMenu toolKit = new JMenu("SRA-Toolkit");
        JMenuItem about = new JMenuItem("About SRAToolKit");
        about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame f = new JFrame("About SRAToolkit");
                f.setLayout(new BorderLayout());
                JPanel panel = new JPanel();
                JLabel versLabel = new JLabel();
                versLabel.setText("<html><br/>Version: " + Version.version() + "<br/></html>");
                versLabel.setHorizontalAlignment(0);
                JLabel aboutLabel = new JLabel();
                aboutLabel.setText("<html>The SRAToolkit provides a graphical interface<br/>        to manage your configuration.</html>");
                aboutLabel.setHorizontalAlignment(0);
                aboutLabel.setHorizontalTextPosition(0);
                panel.add(versLabel);
                panel.add(aboutLabel);
                f.add((Component)versLabel, "North");
                f.add((Component)aboutLabel, "Center");
                f.setSize(400, 300);
                f.setVisible(true);
            }
        });
        JMenuItem preferences = new JMenuItem("Preferences");
        preferences.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SRAToolkitPreferences(SRAToolkitConsoleMenuBar.this.console, SRAToolkitConsoleMenuBar.this.app);
            }
        });
        JMenuItem quit = new JMenuItem("Quit");
        quit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        toolKit.add(about);
        toolKit.addSeparator();
        toolKit.add(preferences);
        toolKit.addSeparator();
        toolKit.add(quit);
        return toolKit;
    }

    private JMenu buildFileTab() {
        JMenu file = new JMenu("File");
        JMenu _new = new JMenu("New");
        JMenuItem nWindow = new JMenuItem("Window");
        nWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SRAToolkitConsole.make(SRAToolkitConsoleMenuBar.this.app);
            }
        });
        JMenuItem nFolder = new JMenuItem("Folder");
        _new.add(nWindow);
        JMenuItem open = new JMenuItem("Open");
        open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame f = new JFrame("Save As");
                f.setSize(300, 300);
                f.setVisible(true);
            }
        });
        JMenu openRecent = new JMenu("OpenRecent");
        JMenuItem close = new JMenuItem("Close Window");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        JMenuItem save = new JMenuItem("Save");
        JMenuItem saveAs = new JMenuItem("Save As");
        saveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame f = new JFrame("Save As");
                f.setSize(300, 300);
                f.setVisible(true);
            }
        });
        JMenuItem dup = new JMenuItem("Duplicate");
        JMenuItem rename = new JMenuItem("Rename");
        JMenuItem delete = new JMenuItem("Delete");
        JMenuItem _import = new JMenuItem("Import Repository");
        _import.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SRAToolkitConsoleMenuBar.this.console.interpretEvent("import", null);
            }
        });
        JMenuItem print = new JMenuItem("Print");
        print.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame f = new JFrame("Print");
                f.setSize(300, 300);
                f.setVisible(true);
            }
        });
        file.add(_new);
        file.addSeparator();
        file.add(close);
        file.addSeparator();
        file.add(_import);
        return file;
    }

    private JMenu buildEditTab() {
        JMenu edit = new JMenu("Edit");
        JMenuItem undo = new JMenuItem("Undo");
        JMenuItem redo = new JMenuItem("Redo");
        JMenuItem copy = new JMenuItem("Copy");
        JMenuItem paste = new JMenuItem("Paste");
        JMenuItem selectAll = new JMenuItem("Select All");
        JMenuItem find = new JMenuItem("Find");
        find.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame f = new JFrame("Find");
                f.setSize(300, 300);
                f.setVisible(true);
            }
        });
        edit.add(undo);
        edit.add(redo);
        edit.addSeparator();
        edit.add(copy);
        edit.add(paste);
        edit.add(selectAll);
        edit.addSeparator();
        edit.add(find);
        return edit;
    }

    private JMenu buildViewTab() {
        JMenu view = new JMenu("View");
        ButtonGroup group1 = new ButtonGroup();
        ButtonGroup group3 = new ButtonGroup();
        JRadioButtonMenuItem list = new JRadioButtonMenuItem("List");
        list.setSelected(true);
        list.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
            }
        });
        JRadioButtonMenuItem icon = new JRadioButtonMenuItem("Icons");
        icon.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
            }
        });
        JRadioButtonMenuItem columns = new JRadioButtonMenuItem("Columns");
        columns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        group1.add(list);
        group1.add(icon);
        group1.add(columns);
        JMenu arrange = new JMenu("Arrange by...");
        JRadioButtonMenuItem name = new JRadioButtonMenuItem("Name");
        name.setSelected(true);
        JRadioButtonMenuItem date = new JRadioButtonMenuItem("Date");
        JRadioButtonMenuItem size = new JRadioButtonMenuItem("File Size");
        group3.add(name);
        group3.add(date);
        group3.add(size);
        arrange.add(name);
        arrange.add(date);
        arrange.add(size);
        JRadioButtonMenuItem path = new JRadioButtonMenuItem("Show Path");
        group3.add(path);
        JMenuItem options = new JMenuItem("View Options");
        options.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame f = new JFrame("Options");
                f.setSize(300, 300);
                f.setVisible(true);
            }
        });
        view.add(list);
        view.add(icon);
        view.add(columns);
        view.addSeparator();
        view.add(arrange);
        view.add(path);
        view.addSeparator();
        view.add(options);
        return view;
    }

    private JMenu buildHelpTab() {
        JMenu help = new JMenu("Help");
        JMenuItem search = new JMenuItem("Search");
        search.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        help.add(search);
        return help;
    }

    public String convertToMultiline(String orig) {
        return "<html>" + orig.replaceAll("\n", "<br/>") + "</html>";
    }

    public SRAToolkitConsoleMenuBar(SRAToolkitConsole _console, SRAToolkit _app) {
        this.app = _app;
        this.console = _console;
        JMenuBar mBar = new JMenuBar();
        this.setLayout(new BorderLayout());
        mBar.setPreferredSize(new Dimension(700, 35));
        mBar.add(this.buildToolkitTab());
        mBar.add(this.buildFileTab());
        mBar.add(this.buildHelpTab());
        mBar.add(Box.createHorizontalGlue());
        this.add(mBar);
    }
}

