/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.gui;

import gov.nih.nlm.ncbi.vdb.kfg.KConfig;
import gov.nih.nlm.ncbi.vdb.kfg.KConfigNode;
import gov.nih.nlm.ncbi.vdb.kfs.KFSPath;
import gov.nih.nlm.ncbi.vdb.kfs.KGapConfig;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.Command;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkitNode;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.InitialConfigurationSemaphore;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.SRAToolkitConfigMgr;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.SRAToolkitConsoleLeftPanel;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.SRAToolkitConsoleMenuBar;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.SRAToolkitConsoleRightPanel;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.SRAToolkitConsoleShell;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.UpdateConsoleCommand;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.UpdateRightPanelCommand;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class SRAToolkitConsole
extends WindowAdapter
implements WindowListener {
    private SRAToolkit app;
    private SRAToolkitConsoleMenuBar mBar;
    private SRAToolkitConsoleLeftPanel lPanel;
    private SRAToolkitConsoleRightPanel rPanel;
    private SRAToolkitConsoleShell guiShell;
    private JFrame frame;
    private Thread shellThread;
    private Thread guiShellThread;
    private Thread appThread;
    private boolean isDLMgrOpen = false;

    public static void make(SRAToolkit _app) {
        try {
            SRAToolkitConsole console = new SRAToolkitConsole(_app);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized void windowClosed(WindowEvent evt) {
        if (this.app.getWindowCount() == 0) {
            System.exit(0);
        }
    }

    @Override
    public synchronized void windowClosing(WindowEvent evt) {
        this.app.decrementWindowCount();
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void setIsDLMgrOpen(boolean which) {
        this.isDLMgrOpen = which;
    }

    public void interpretEvent(String which, Object obj) {
        if (obj != null) {
            if (which.equals("scan")) {
                String[] paths = (String[])obj;
                this.app.scanForMissingRefseq(paths);
            } else if (which.equals("download")) {
                String[] paths = (String[])obj;
                this.app.httpDownload(paths);
            }
        } else if (which.equals("import")) {
            this.importRepository();
        } else if (which.equals("remove")) {
            // empty if block
        }
    }

    public void importRepository() {
        block18: {
            File file;
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String path = f.getAbsolutePath();
                    return (path = path.toLowerCase()).endsWith(".ngc");
                }

                @Override
                public String getDescription() {
                    return ".ngc";
                }
            });
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setApproveButtonText("OK");
            int opt = chooser.showOpenDialog(this.frame);
            if (opt == 0 && !(file = chooser.getSelectedFile()).isDirectory()) {
                try {
                    KConfig kfg = KConfig.make();
                    String repName = null;
                    boolean success = true;
                    try {
                        String path = file.getAbsolutePath();
                        KGapConfig ngc = KGapConfig.make(path);
                        if (ngc.advanceNextLine()) {
                            repName = ngc.getProjectId();
                            String encryptKey = ngc.getEncryptionKey();
                            String dlTicket = ngc.getDownloadTicket();
                            String description = ngc.getDescription();
                            success = this.app.addDBGapRepository(kfg, repName, encryptKey, dlTicket, description);
                        }
                    }
                    catch (Exception e) {
                        success = false;
                        SRAToolkit.stackTracePrint(e);
                    }
                    boolean cancel = false;
                    if (!success) break block18;
                    String presetPath = null;
                    try {
                        presetPath = kfg.readString("HOME") + "/ncbi/" + repName;
                    }
                    catch (Exception e) {
                        SRAToolkit.stackTracePrint(e);
                    }
                    int response = JOptionPane.showOptionDialog(this.frame, "Respository: " + repName + "\n" + "will be created in the default directory:\n" + "\n" + presetPath + "\n" + "\n" + "You can choose a different location.\n" + "( Please allow for sufficient disk space )\n", "Confirm", 1, 1, null, new String[]{"Browse", "Default", "CANCEL"}, null);
                    if (response == 0) {
                        JFileChooser repChooser = new JFileChooser();
                        repChooser.setFileSelectionMode(1);
                        repChooser.setApproveButtonText("OK");
                        int opt2 = repChooser.showOpenDialog(this.frame);
                        if (opt2 == 0) {
                            File dir = repChooser.getSelectedFile();
                            if (!dir.isDirectory()) {
                                dir = file.getParentFile();
                            }
                            String path = dir.toString();
                            this.setRepRootSystemPath(kfg, path, "protected", repName);
                        } else {
                            cancel = true;
                        }
                    } else if (response == 2 || response == -1) {
                        cancel = true;
                    }
                    if (cancel) {
                        JOptionPane.showMessageDialog(this.frame, "Import Canceled");
                    } else {
                        kfg.commit();
                        Command first = SRAToolkit.makeCreateDirectoriesCommand(this.app);
                        Command second = SRAToolkitConsole.makeUpdateConsoleCommand(this.app, this);
                        try {
                            this.app.addToEventQueue(Command.makeSerialCommandPair(first, second));
                        }
                        catch (Exception e) {
                            SRAToolkit.stackTracePrint(e);
                        }
                    }
                    kfg.release();
                }
                catch (Exception e) {
                    SRAToolkit.stackTracePrint(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRepRootSystemPath(KConfig kfg, String path, String subCat, String repName) throws Exception {
        KFSPath kfsPath = KFSPath.makeFromSystemString(path);
        KConfigNode rep = kfg.openNodeUpdate("/repository/user/" + subCat + "/" + repName);
        try {
            KConfigNode rootNode = rep.openNodeUpdate("root");
            try {
                rootNode.write(kfsPath.getPosixPathString());
            }
            finally {
                rootNode.release();
            }
        }
        finally {
            rep.release();
        }
    }

    public void updateConsole(SRAToolkit app, SRAToolkitConsole console) {
        SRAToolkitConsole.make(app);
        this.frame.setVisible(false);
        this.frame.dispose();
        app.decrementWindowCount();
    }

    public void updateRightPanel(SRAToolkitNode node) {
        this.rPanel.updateTree(node);
    }

    public static Command makeUpdateConsoleCommand(SRAToolkit app, Object obj) {
        return new UpdateConsoleCommand(app, obj);
    }

    public static Command makeUpdateRightPanelCommand(SRAToolkit app, Object obj, SRAToolkitNode root) {
        return new UpdateRightPanelCommand(app, obj, root);
    }

    public static void main(String[] args) {
        try {
            System.loadLibrary("vdb_jni");
        }
        catch (UnsatisfiedLinkError ul) {
            String path = SRAToolkitConsole.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            path = new File(path).getParentFile().getPath();
            try {
                String decodedPath = URLDecoder.decode(path, "UTF-8");
                SRAToolkit.debugPrintln(decodedPath);
                System.setProperty("java.library.path", decodedPath);
                Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
                fieldSysPath.setAccessible(true);
                fieldSysPath.set(null, null);
                System.loadLibrary("vdb_jni");
            }
            catch (Exception e) {
                SRAToolkit.stackTracePrint(e);
            }
        }
        try {
            SRAToolkit app;
            int minConfig;
            String name = System.getProperty("user.name");
            if ("root".equals(name)) {
                System.err.println("Warning: normally this application should not be run as root/superuser");
                boolean root = false;
                for (int i = 0; i < args.length; ++i) {
                    if (!args[i].equals("--root")) continue;
                    root = true;
                    break;
                }
                if (!root) {
                    System.exit(1);
                }
            }
            if ((minConfig = (app = SRAToolkit.make(args, false)).checkMinimumConfig()) != 61) {
                KConfig kfg = KConfig.make();
                app.createMinimumConfig(minConfig, kfg);
                InitialConfigurationSemaphore stop = new InitialConfigurationSemaphore();
                new SRAToolkitConfigMgr(kfg, stop);
                if (stop.getExited()) {
                    if (stop.getOK()) {
                        kfg.commit();
                        app.updateSRAToolkitApp();
                    }
                    kfg.release();
                    System.exit(0);
                } else {
                    SRAToolkitConfigMgr.clearDefaultConfigNode(kfg);
                    kfg.commit();
                    kfg.release();
                    app.updateSRAToolkitApp();
                }
            }
            SRAToolkitConsole.make(app);
        }
        catch (Exception e) {
            SRAToolkit.stackTracePrint(e);
        }
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    private SRAToolkitConsole(SRAToolkit _app) throws IOException {
        this.app = _app;
        this.app.incrementWindowCount();
        this.mBar = new SRAToolkitConsoleMenuBar(this, this.app);
        this.lPanel = SRAToolkitConsoleLeftPanel.make(this.app, this);
        this.rPanel = new SRAToolkitConsoleRightPanel(this.app, this);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int height = screenSize.height * 2 / 3;
        int width = screenSize.width * 3 / 5;
        try {
            GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            int width2 = gd.getDisplayMode().getWidth() * 3 / 5;
            if (width2 < width) {
                width = width2;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.frame = new JFrame("Java Console");
        this.frame.getContentPane().add((Component)this.mBar, "North");
        this.frame.getContentPane().add((Component)this.lPanel, "West");
        this.frame.getContentPane().add((Component)this.rPanel, "Center");
        this.frame.addWindowListener(this);
        this.frame.setLocation(4, 23);
        this.frame.setSize(width, height);
        this.frame.setVisible(true);
    }
}

