/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.app;

import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkitFTPRootNode;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkitLocalNode;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkitPrebuiltNode;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public abstract class SRAToolkitNode
implements TreeNode {
    public static final int REMOTE = 1;
    public static final int SITE = 2;
    public static final int LOCAL = 3;
    protected Vector<SRAToolkitNode> subnodes = null;
    protected boolean isBuilt = false;
    protected SRAToolkitNode parent;
    protected boolean isDir;
    protected String name;
    protected String path;
    protected String repository;
    protected int category;

    public String toString() {
        return this.getName();
    }

    public Enumeration<SRAToolkitNode> children() {
        if (!this.isDirectory()) {
            return null;
        }
        if (!this.isBuilt()) {
            try {
                this.makeChildren(this.getCategory());
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.subnodes.elements();
    }

    @Override
    public boolean getAllowsChildren() {
        return this.isDirectory();
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        if (!this.isDirectory()) {
            return null;
        }
        if (!this.isBuilt()) {
            try {
                this.makeChildren(this.getCategory());
            }
            catch (Exception e) {
                SRAToolkit.stackTracePrint(e);
                return null;
            }
        }
        return this.subnodes.elementAt(childIndex);
    }

    @Override
    public int getChildCount() {
        if (!this.isDirectory()) {
            return 0;
        }
        if (!this.isBuilt()) {
            try {
                this.makeChildren(this.getCategory());
            }
            catch (Exception e) {
                SRAToolkit.stackTracePrint(e);
                return 0;
            }
        }
        return this.subnodes.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException("null TreeNode");
        }
        if (!this.isDirectory()) {
            return -1;
        }
        if (node.getParent() != this) {
            return -1;
        }
        if (!this.isBuilt()) {
            try {
                this.makeChildren(this.getCategory());
            }
            catch (Exception e) {
                return -1;
            }
        }
        return this.subnodes.indexOf(node);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return !this.isDir;
    }

    public static SRAToolkitNode makePrebuiltNode(String name, String root, int cat, String repository, Vector<SRAToolkitNode> nodes) {
        return new SRAToolkitPrebuiltNode(name, root, cat, repository, nodes);
    }

    public static SRAToolkitNode makeLocalNode(String name, String root, int cat, String repository) {
        return new SRAToolkitLocalNode(name, root, cat, repository);
    }

    public static SRAToolkitNode makeRemoteNode(String name, String root, int cat, String repository) {
        return new SRAToolkitFTPRootNode(name, root, cat, repository);
    }

    public String getPath() {
        if (this.parent == null) {
            return this.path;
        }
        return this.parent.getPath() + "/" + this.path;
    }

    public String getName() {
        return this.name;
    }

    public int getCategory() {
        return this.category;
    }

    public String getRepository() {
        return this.repository;
    }

    public int getSubnodeCount() {
        return this.subnodes.size();
    }

    public boolean isDirectory() {
        return this.isDir;
    }

    public boolean isEmpty() {
        if (!this.isDir) {
            return true;
        }
        if (this.subnodes == null) {
            return false;
        }
        return this.subnodes.size() == 0;
    }

    public void setParent(SRAToolkitNode _parent) {
        this.parent = _parent;
    }

    protected abstract void makeChildren(int var1) throws Exception;

    protected void setIsBuilt(boolean which) {
        this.isBuilt = which;
    }

    protected boolean isBuilt() {
        return this.isBuilt;
    }

    protected SRAToolkitNode(String _name, String _path, int cat, String rep) {
        this.parent = null;
        this.isDir = true;
        this.name = _name;
        this.path = _path;
        this.category = cat;
        this.repository = rep;
        if (_name == null) {
            throw new RuntimeException("SRAToolkitNode - null name");
        }
    }

    protected SRAToolkitNode(SRAToolkitNode _parent, String _name, String _path, boolean _isDir, int cat, String rep) {
        this.parent = _parent;
        this.isDir = _isDir;
        this.name = _name;
        this.path = _path;
        this.category = cat;
        this.repository = rep;
        if (_name == null) {
            throw new RuntimeException("SRAToolkitNode - null name");
        }
    }
}

