/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.app;

import gov.nih.nlm.ncbi.vdb.sratoolkit.app.Command;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.CommandFactory;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.CommandListener;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.HttpDownloadCommand;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.RefseqMgr;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.ResolvedPath;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.SraListener;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.VResolverResult;
import gov.nih.nlm.ncbi.vdb.sratoolkit.util.logging.Handler;
import java.io.FileNotFoundException;

class ResolveSraFirer
implements SraListener {
    private CommandListener listener;
    private RefseqMgr mgr;

    ResolveSraFirer(CommandListener listener, RefseqMgr mgr) {
        this.listener = listener;
        this.mgr = mgr;
    }

    @Override
    public boolean event(ResolvedPath object) {
        VResolverResult res;
        try {
            HttpDownloadCommand c = new HttpDownloadCommand(object, this.mgr);
            ((Command)c).execute();
        }
        catch (Exception e) {
            SRAToolkit.stackTracePrint(e);
            return false;
        }
        try {
            res = this.mgr.resolveSra(object.accession());
        }
        catch (Exception e) {
            Handler.reportError("Cannot resolve: " + object);
            return false;
        }
        if (!res.foundLocally()) {
            Handler.reportError("Cannot find downloaded " + object);
            return false;
        }
        Command c = null;
        try {
            c = CommandFactory.makeResolveReferencesCommand(this.listener, this.mgr, ((ResolvedPath)res).local());
        }
        catch (FileNotFoundException e) {
            SRAToolkit.stackTracePrint(e);
            return false;
        }
        try {
            c.execute();
            return true;
        }
        catch (Exception e) {
            SRAToolkit.stackTracePrint(e);
            return false;
        }
    }
}

