/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.app;

import gov.nih.nlm.ncbi.vdb.kfg.KConfig;
import gov.nih.nlm.ncbi.vdb.kfg.KConfigNode;
import gov.nih.nlm.ncbi.vdb.klib.VDBException;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.KConfigNodeHelper;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.StdoutWriter;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.StringWriter;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.Writer;

public class KConfigHelper {
    static void out(KConfig kfg, Writer w) {
        String node = "Config";
        w.println("<" + node + ">");
        try {
            KConfigNode root = kfg.openNodeRead("/");
            String[] children = root.listChildren();
            for (int i = 0; i < children.length; ++i) {
                KConfigNode n = root.openNodeRead(children[i]);
                new KConfigNodeHelper(n, children[i]).out(w, 1);
            }
        }
        catch (VDBException e) {
            SRAToolkit.stackTracePrint(e);
        }
        w.println("</" + node + ">");
    }

    static void printConfig() {
        try {
            KConfigHelper.printConfig(KConfig.make());
        }
        catch (VDBException e) {
            SRAToolkit.stackTracePrint(e);
        }
    }

    static void printConfig(KConfig kfg) {
        KConfigHelper.out(kfg, new StdoutWriter());
    }

    public static String configToString() {
        try {
            return KConfigHelper.configToString(KConfig.make());
        }
        catch (VDBException e) {
            SRAToolkit.stackTracePrint(e);
            return "" + e;
        }
    }

    static String configToString(KConfig kfg) {
        StringWriter s = new StringWriter();
        KConfigHelper.out(kfg, s);
        return s.str();
    }

    public static void main(String[] args) {
        SRAToolkit.setDebug();
        System.loadLibrary("vdb_jni");
        KConfigHelper.printConfig();
    }
}

