/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.app;

import gov.nih.nlm.ncbi.vdb.sratoolkit.app.Command;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.RefseqMgr;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.ResolvedPath;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.SraListener;
import gov.nih.nlm.ncbi.vdb.sratoolkit.util.logging.Handler;

class HttpDownloadCommand
extends Command {
    private ResolvedPath obj;
    private RefseqMgr mgr;
    private SraListener listener;

    HttpDownloadCommand(ResolvedPath obj, RefseqMgr mgr) {
        this(obj, mgr, null);
    }

    HttpDownloadCommand(ResolvedPath obj, RefseqMgr mgr, SraListener listener) {
        if (obj == null || mgr == null) {
            throw new NullPointerException();
        }
        this.obj = obj;
        this.mgr = mgr;
        this.listener = listener;
    }

    @Override
    protected boolean execute() throws Exception {
        String acc = this.obj.accession();
        Handler.reportStatusTop(this.myNumber() + "Resolving " + acc + "...");
        boolean ok = this.mgr.resolve(this.obj);
        if (ok) {
            Handler.reportStatusTop(this.myNumber() + acc + " was resolved");
            if (this.listener != null) {
                return this.listener.event(this.obj);
            }
            return true;
        }
        Handler.reportStatusTop(this.myNumber() + "failed resolving of " + acc);
        return false;
    }
}

