/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.kfs;

import gov.nih.nlm.ncbi.vdb.kfs.KFSPosixPath;
import gov.nih.nlm.ncbi.vdb.kfs.KFSWindowsPath;
import gov.nih.nlm.ncbi.vdb.klib.KDbg;
import gov.nih.nlm.ncbi.vdb.klib.VDBException;
import gov.nih.nlm.ncbi.vdb.klib.VDBSystem;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public abstract class KFSPath {
    protected Vector<String> path;
    private String origPosix;
    private String origSystem;
    static Boolean isWindows = VDBSystem.systemIsWindows();

    public static KFSPath makeFromPosixString(String string) throws VDBException {
        Vector<String> new_path = KFSPath.parsePosix(string);
        return isWindows != false ? new KFSWindowsPath(new_path, true, string) : new KFSPosixPath(new_path, true, string);
    }

    public static KFSPath makeFromSystemString(String string) throws VDBException {
        Vector<String> new_path = KFSPath.parseSystem(string);
        return isWindows != false ? new KFSWindowsPath(new_path, false, string) : new KFSPosixPath(new_path, false, string);
    }

    public String toString() {
        return this.getPosixPathString();
    }

    public String getPosixPathString() {
        String string = "";
        if (this.path.isEmpty()) {
            string = "/";
        } else {
            for (int i = 0; i < this.path.size(); ++i) {
                string = string + "/" + this.path.elementAt(i);
            }
        }
        return this.debug("getPosixPathString", string);
    }

    public String getSystemPathString() {
        return this.debug("getSystemPathString", this._getSystemPathString());
    }

    protected abstract String _getSystemPathString();

    private String debug(String function, String string) {
        if (KDbg.path()) {
            SRAToolkit.errPrintln("KFSPath::" + function + "(from ");
            if (this.origPosix != null) {
                SRAToolkit.errPrintln("POSIX = " + this.origPosix);
            } else {
                SRAToolkit.errPrintln("SYSTEM = " + this.origSystem);
            }
            SRAToolkit.errPrintln(") = " + string);
        }
        return string;
    }

    public static String posixStringToSystemString(String path) throws VDBException {
        KFSPath kp = KFSPath.makeFromPosixString(path);
        return kp.getSystemPathString();
    }

    public static String systemStringToPosixString(String path) throws VDBException {
        KFSPath kp = KFSPath.makeFromSystemString(path);
        return kp.getPosixPathString();
    }

    protected KFSPath(Vector<String> _path, boolean posix, String orig) {
        this.path = _path;
        if (posix) {
            this.origPosix = orig;
        } else {
            this.origSystem = orig;
        }
    }

    private static Vector<String> parsePosix(String string) throws VDBException {
        if (string == null) {
            throw new VDBException();
        }
        if (string.length() == 0) {
            throw new VDBException();
        }
        if (string.indexOf("\\") != -1) {
            throw new VDBException();
        }
        Vector<String> path = new Vector<String>();
        if (!string.equals("/")) {
            String s = string;
            if (!isWindows.booleanValue()) {
                File f = new File(string);
                try {
                    s = f.getCanonicalPath();
                }
                catch (IOException e) {
                    throw new VDBException(e);
                }
            } else if (!string.startsWith("/")) {
                throw new VDBException();
            }
            String[] a = s.split("/");
            for (int i = 0; i < a.length; ++i) {
                String leaf = a[i];
                if (leaf.length() == 0 || leaf.equals(".")) continue;
                if (leaf.equals("..")) {
                    path.remove(path.lastElement());
                    continue;
                }
                path.add(leaf);
            }
        }
        return path;
    }

    private static Vector<String> parseSystem(String string) throws VDBException {
        if (isWindows.booleanValue()) {
            return KFSPath.parseWindows(string);
        }
        return KFSPath.parsePosix(string);
    }

    private static Vector<String> parseWindows(String string) throws VDBException {
        if (string == null) {
            throw new VDBException();
        }
        if (string.length() == 0) {
            throw new VDBException();
        }
        Vector<String> path = new Vector<String>();
        string = string.replace('/', '\\');
        File f = new File(string);
        try {
            String s = f.getCanonicalPath();
            String[] a = s.split("\\\\");
            int i = 1;
            if (string.startsWith("\\\\")) {
                path.add("");
                i = 2;
            } else {
                path.add(a[0].substring(0, 1));
            }
            while (i < a.length) {
                path.add(a[i]);
                ++i;
            }
        }
        catch (IOException e) {
            throw new VDBException(e);
        }
        return path;
    }

    public static void posixTest() throws Exception {
        KFSPath posix;
        block2: {
            posix = KFSPath.makeFromPosixString("/");
            SRAToolkit.debugPrintln("1.a --- Posix string entered: '/'                      Received: '" + posix.getPosixPathString() + "'");
            try {
                posix = KFSPath.makeFromPosixString(".");
                SRAToolkit.debugPrintln("2.a --- Posix string entered: '.'                  Received: '" + posix.getPosixPathString() + "'");
            }
            catch (Exception e) {
                if (isWindows.booleanValue()) break block2;
                throw e;
            }
        }
        posix = KFSPath.makeFromPosixString("/Documents");
        SRAToolkit.debugPrintln("2.b --- Posix string entered: '/Documents'             Received: '" + posix.getPosixPathString() + "'");
    }

    public static void nonWindowsTest() throws Exception {
        KFSPath posix = KFSPath.makeFromSystemString("/");
        SRAToolkit.debugPrintln("1.b --- Posix string entered: '/'                      Received: '" + posix.getPosixPathString() + "'");
        posix = KFSPath.makeFromSystemString("/Documents");
        SRAToolkit.debugPrintln("2.c --- Posix string entered: '/Documents'             Received: '" + posix.getPosixPathString() + "'");
        posix = KFSPath.makeFromSystemString("/Documents/blark");
        SRAToolkit.debugPrintln("2.d --- Posix string entered: '/Documents/blark'       Received: '" + posix.getPosixPathString() + "'");
        posix = KFSPath.makeFromSystemString("/Documents/blark/../blah");
        SRAToolkit.debugPrintln("2.e --- Posix string entered: '/Documents/blark/../blah' Received: '" + posix.getPosixPathString() + "'");
    }

    public static void windowsTest() throws Exception {
        KFSPath derp = KFSPath.makeFromSystemString("C:\\Documents");
        SRAToolkit.debugPrintln("1.a --- Windows string entered: 'C:\\Documents'        Received: '" + derp.getPosixPathString() + "' as Posix");
        SRAToolkit.debugPrintln("1.a --- Windows string entered: 'C:\\Documents'        Received: '" + derp.getSystemPathString() + "' as Windows");
    }

    public static void main(String[] args) {
        SRAToolkit.setDebug();
        try {
            KFSPath.posixTest();
            if (isWindows.booleanValue()) {
                KFSPath.windowsTest();
            } else {
                KFSPath.nonWindowsTest();
            }
        }
        catch (Exception e) {
            SRAToolkit.stackTracePrint(e);
        }
    }
}

