/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.directed;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.QualityUtil;
import htsjdk.samtools.util.SequenceUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picard.analysis.GcBiasDetailMetrics;
import picard.analysis.GcBiasSummaryMetrics;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.directed.GcBiasCollectorArgs;
import picard.metrics.GcBiasMetrics;
import picard.metrics.MultiLevelCollector;
import picard.metrics.PerUnitMetricCollector;

public class GcBiasMetricsCollector
extends MultiLevelCollector<GcBiasMetrics, Integer, GcBiasCollectorArgs> {
    private final int windowSize;
    private final boolean bisulfite;
    private final Map<String, byte[]> gcByRef;
    private int[] windowsByGc = new int[101];
    private static final int WINDOWS = 101;

    public GcBiasMetricsCollector(Set<MetricAccumulationLevel> accumulationLevels, Map<String, byte[]> gcByRef, int[] windowsByGc, List<SAMReadGroupRecord> samRgRecords, int windowSize, boolean bisulfite) {
        this.windowSize = windowSize;
        this.bisulfite = bisulfite;
        this.gcByRef = gcByRef;
        this.windowsByGc = windowsByGc;
        this.setup(accumulationLevels, samRgRecords);
    }

    @Override
    protected GcBiasCollectorArgs makeArg(SAMRecord rec, ReferenceSequence ref) {
        return new GcBiasCollectorArgs(rec, ref);
    }

    @Override
    protected PerUnitMetricCollector<GcBiasMetrics, Integer, GcBiasCollectorArgs> makeChildCollector(String sample, String library, String readGroup) {
        return new PerUnitGcBiasMetricsCollector(sample, library, readGroup);
    }

    @Override
    public void acceptRecord(SAMRecord rec, ReferenceSequence ref) {
        super.acceptRecord(rec, ref);
    }

    private void calculateDropoutMetrics(Collection<GcBiasDetailMetrics> details, GcBiasSummaryMetrics summary) {
        double totalReads = 0.0;
        double totalWindows = 0.0;
        for (GcBiasDetailMetrics detail : details) {
            totalReads += (double)detail.READ_STARTS;
            totalWindows += (double)detail.WINDOWS;
        }
        double atDropout = 0.0;
        double gcDropout = 0.0;
        for (GcBiasDetailMetrics detail : details) {
            double relativeWindows = (double)detail.WINDOWS / totalWindows;
            double relativeReads = (double)detail.READ_STARTS / totalReads;
            double dropout = (relativeWindows - relativeReads) * 100.0;
            if (!(dropout > 0.0)) continue;
            if (detail.GC <= 50) {
                atDropout += dropout;
                continue;
            }
            gcDropout += dropout;
        }
        summary.AT_DROPOUT = atDropout;
        summary.GC_DROPOUT = gcDropout;
    }

    private void addRead(GcObject gcObj, SAMRecord rec, String group, byte[] gc, byte[] refBases) {
        byte windowGc;
        if (!rec.getReadPairedFlag() || rec.getFirstOfPairFlag()) {
            ++gcObj.totalClusters;
        }
        int pos = rec.getReadNegativeStrandFlag() ? rec.getAlignmentEnd() - this.windowSize : rec.getAlignmentStart();
        ++gcObj.totalAlignedReads;
        if (pos > 0 && (windowGc = gc[pos]) >= 0) {
            byte by = windowGc;
            gcObj.readsByGc[by] = gcObj.readsByGc[by] + 1;
            byte by2 = windowGc;
            gcObj.basesByGc[by2] = gcObj.basesByGc[by2] + (long)rec.getReadLength();
            byte by3 = windowGc;
            gcObj.errorsByGc[by3] = gcObj.errorsByGc[by3] + (long)(SequenceUtil.countMismatches(rec, refBases, this.bisulfite) + SequenceUtil.countInsertedBases(rec) + SequenceUtil.countDeletedBases(rec));
        }
        if (gcObj.group == null) {
            gcObj.group = group;
        }
    }

    class GcObject {
        int totalClusters = 0;
        int totalAlignedReads = 0;
        int[] readsByGc = new int[101];
        long[] basesByGc = new long[101];
        long[] errorsByGc = new long[101];
        String group = null;

        GcObject() {
        }
    }

    public class PerUnitGcBiasMetricsCollector
    implements PerUnitMetricCollector<GcBiasMetrics, Integer, GcBiasCollectorArgs> {
        Map<String, GcObject> gcData = new HashMap<String, GcObject>();
        private String sample = null;
        private String library = null;
        private String readGroup = null;
        private static final String allReads = "All_Reads";

        public PerUnitGcBiasMetricsCollector(String sample, String library, String readGroup) {
            this.sample = sample;
            this.library = library;
            this.readGroup = readGroup;
            if (this.readGroup != null) {
                String prefix = this.readGroup;
                this.gcData.put(prefix, new GcObject());
            } else if (this.library != null) {
                String prefix = this.library;
                this.gcData.put(prefix, new GcObject());
            } else if (this.sample != null) {
                String prefix = this.sample;
                this.gcData.put(prefix, new GcObject());
            } else {
                String prefix = allReads;
                this.gcData.put(prefix, new GcObject());
            }
        }

        @Override
        public void acceptRecord(GcBiasCollectorArgs args) {
            SAMRecord rec = args.getRec();
            if (!rec.getReadUnmappedFlag()) {
                ReferenceSequence ref = args.getRef();
                byte[] refBases = ref.getBases();
                String refName = ref.getName();
                byte[] gc = (byte[])GcBiasMetricsCollector.this.gcByRef.get(refName);
                if (this.readGroup != null) {
                    String type = this.readGroup;
                    String group = "Read Group";
                    GcBiasMetricsCollector.this.addRead(this.gcData.get(type), rec, group, gc, refBases);
                } else if (this.library != null) {
                    String type = this.library;
                    String group = "Library";
                    GcBiasMetricsCollector.this.addRead(this.gcData.get(type), rec, group, gc, refBases);
                } else if (this.sample != null) {
                    String type = this.sample;
                    String group = "Sample";
                    GcBiasMetricsCollector.this.addRead(this.gcData.get(type), rec, group, gc, refBases);
                } else {
                    String type = allReads;
                    String group = "All Reads";
                    GcBiasMetricsCollector.this.addRead(this.gcData.get(type), rec, group, gc, refBases);
                }
            } else {
                for (Map.Entry<String, GcObject> entry : this.gcData.entrySet()) {
                    GcObject gcCur = entry.getValue();
                    if (rec.getReadPairedFlag() && !rec.getFirstOfPairFlag()) continue;
                    ++gcCur.totalClusters;
                }
            }
        }

        @Override
        public void finish() {
        }

        private double sum(int[] values) {
            int length = values.length;
            double total = 0.0;
            for (int i = 0; i < length; ++i) {
                total += (double)values[i];
            }
            return total;
        }

        @Override
        public void addMetricsToFile(MetricsFile<GcBiasMetrics, Integer> file) {
            for (Map.Entry<String, GcObject> entry : this.gcData.entrySet()) {
                GcObject gcCur = entry.getValue();
                String gcType = entry.getKey();
                int[] readsByGc = gcCur.readsByGc;
                long[] errorsByGc = gcCur.errorsByGc;
                long[] basesByGc = gcCur.basesByGc;
                int totalClusters = gcCur.totalClusters;
                int totalAlignedReads = gcCur.totalAlignedReads;
                String group = gcCur.group;
                GcBiasMetrics metrics = new GcBiasMetrics();
                double totalWindows = this.sum(GcBiasMetricsCollector.this.windowsByGc);
                double totalReads = this.sum(readsByGc);
                double meanReadsPerWindow = totalReads / totalWindows;
                if (totalAlignedReads <= 0) continue;
                for (int i = 0; i < GcBiasMetricsCollector.this.windowsByGc.length; ++i) {
                    GcBiasDetailMetrics detail = new GcBiasDetailMetrics();
                    detail.GC = i;
                    detail.WINDOWS = GcBiasMetricsCollector.this.windowsByGc[i];
                    detail.READ_STARTS = readsByGc[i];
                    if (errorsByGc[i] > 0L) {
                        detail.MEAN_BASE_QUALITY = QualityUtil.getPhredScoreFromObsAndErrors(basesByGc[i], errorsByGc[i]);
                    }
                    if (GcBiasMetricsCollector.this.windowsByGc[i] != 0) {
                        detail.NORMALIZED_COVERAGE = (double)detail.READ_STARTS / (double)detail.WINDOWS / meanReadsPerWindow;
                        detail.ERROR_BAR_WIDTH = Math.sqrt(detail.READ_STARTS) / (double)detail.WINDOWS / meanReadsPerWindow;
                    } else {
                        detail.NORMALIZED_COVERAGE = 0.0;
                        detail.ERROR_BAR_WIDTH = 0.0;
                    }
                    detail.ACCUMULATION_LEVEL = group;
                    if (group.equals("Read Group")) {
                        detail.READ_GROUP = gcType;
                    } else if (group.equals("Sample")) {
                        detail.SAMPLE = gcType;
                    } else if (group.equals("Library")) {
                        detail.LIBRARY = gcType;
                    }
                    metrics.DETAILS.addMetric(detail);
                }
                GcBiasSummaryMetrics summary = new GcBiasSummaryMetrics();
                if (group.equals("Read Group")) {
                    summary.READ_GROUP = gcType;
                } else if (group.equals("Sample")) {
                    summary.SAMPLE = gcType;
                } else if (group.equals("Library")) {
                    summary.LIBRARY = gcType;
                }
                summary.ACCUMULATION_LEVEL = group;
                summary.WINDOW_SIZE = GcBiasMetricsCollector.this.windowSize;
                summary.TOTAL_CLUSTERS = totalClusters;
                summary.ALIGNED_READS = totalAlignedReads;
                GcBiasMetricsCollector.this.calculateDropoutMetrics(metrics.DETAILS.getMetrics(), summary);
                metrics.SUMMARY = summary;
                file.addMetric(metrics);
            }
        }
    }
}

