/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.liftover.LiftOver;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.List;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Intervals;

@CommandLineProgramProperties(usage="Lifts over an interval list from one reference build to another. Based on UCSC liftOver. Uses a UCSC chain file to guide the liftOver.", usageShort="Lifts over an interval list from one reference build to another", programGroup=Intervals.class)
public class LiftOverIntervalList
extends CommandLineProgram {
    private static final Log LOG = Log.getInstance(LiftOverIntervalList.class);
    @Option(doc="Interval list to be lifted over.", shortName="I")
    public File INPUT;
    @Option(doc="Where to write lifted-over interval list.", shortName="O")
    public File OUTPUT;
    @Option(doc="Sequence dictionary to write into the output interval list.", shortName="SD")
    public File SEQUENCE_DICTIONARY;
    @Option(doc="Chain file that guides LiftOver.")
    public File CHAIN;
    @Option(doc="Minimum percentage of bases in each input interval that must map to output interval.")
    public double MIN_LIFTOVER_PCT = 0.95;

    public static void main(String[] argv) {
        new LiftOverIntervalList().instanceMainWithExit(argv);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsReadable((File)this.SEQUENCE_DICTIONARY);
        IOUtil.assertFileIsReadable((File)this.CHAIN);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        LiftOver liftOver = new LiftOver(this.CHAIN);
        liftOver.setLiftOverMinMatch(this.MIN_LIFTOVER_PCT);
        IntervalList fromIntervals = IntervalList.fromFile((File)this.INPUT);
        SAMFileHeader toHeader = SamReaderFactory.makeDefault().getFileHeader(this.SEQUENCE_DICTIONARY);
        liftOver.validateToSequences(toHeader.getSequenceDictionary());
        IntervalList toIntervals = new IntervalList(toHeader);
        boolean anyFailed = false;
        for (Interval fromInterval : fromIntervals) {
            Interval toInterval = liftOver.liftOver(fromInterval);
            if (toInterval != null) {
                toIntervals.add(toInterval);
                continue;
            }
            anyFailed = true;
            LOG.warn(new Object[]{"Liftover failed for ", fromInterval, "(len ", fromInterval.length(), ")"});
            List partials = liftOver.diagnosticLiftover(fromInterval);
            for (LiftOver.PartialLiftover partial : partials) {
                LOG.info(new Object[]{partial});
            }
        }
        toIntervals.sorted();
        toIntervals.write(this.OUTPUT);
        return anyFailed ? 1 : 0;
    }
}

