/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates.util;

import htsjdk.samtools.DuplicateScoringStrategy;
import htsjdk.samtools.MergingSamRecordIterator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamFileHeaderMerger;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.Histogram;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picard.PicardException;
import picard.cmdline.Option;
import picard.sam.DuplicationMetrics;
import picard.sam.markduplicates.util.AbstractOpticalDuplicateFinderCommandLineProgram;
import picard.sam.markduplicates.util.LibraryIdGenerator;
import picard.sam.markduplicates.util.OpticalDuplicateFinder;
import picard.sam.markduplicates.util.ReadEnds;

public abstract class AbstractMarkDuplicatesCommandLineProgram
extends AbstractOpticalDuplicateFinderCommandLineProgram {
    @Option(shortName="I", doc="One or more input SAM or BAM files to analyze. Must be coordinate sorted.")
    public List<String> INPUT;
    @Option(shortName="O", doc="The output file to write marked records to")
    public File OUTPUT;
    @Option(shortName="M", doc="File to write duplication metrics to")
    public File METRICS_FILE;
    @Option(shortName="PG", doc="The program record ID for the @PG record(s) created by this program. Set to null to disable PG record creation.  This string may have a suffix appended to avoid collision with other program record IDs.", optional=true)
    public String PROGRAM_RECORD_ID = "MarkDuplicates";
    @Option(shortName="PG_VERSION", doc="Value of VN tag of PG record to be created. If not specified, the version will be detected automatically.", optional=true)
    public String PROGRAM_GROUP_VERSION;
    @Option(shortName="PG_COMMAND", doc="Value of CL tag of PG record to be created. If not supplied the command line will be detected automatically.", optional=true)
    public String PROGRAM_GROUP_COMMAND_LINE;
    @Option(shortName="PG_NAME", doc="Value of PN tag of PG record to be created.")
    public String PROGRAM_GROUP_NAME = this.getClass().getSimpleName();
    @Option(shortName="CO", doc="Comment(s) to include in the output file's header.", optional=true)
    public List<String> COMMENT = new ArrayList<String>();
    @Option(doc="If true do not write duplicates to the output file instead of writing them with appropriate flags set.")
    public boolean REMOVE_DUPLICATES = false;
    @Option(shortName="AS", doc="If true, assume that the input file is coordinate sorted even if the header says otherwise.")
    public boolean ASSUME_SORTED = false;
    @Option(shortName="DS", doc="The scoring strategy for choosing the non-duplicate among candidates.")
    public DuplicateScoringStrategy.ScoringStrategy DUPLICATE_SCORING_STRATEGY = DuplicateScoringStrategy.ScoringStrategy.TOTAL_MAPPED_REFERENCE_LENGTH;
    protected final Set<String> pgIdsSeen = new HashSet<String>();

    protected Map<String, String> getChainedPgIds(SAMFileHeader outputHeader) {
        HashMap<String, String> chainedPgIds;
        if (this.PROGRAM_RECORD_ID != null) {
            SAMFileHeader.PgIdGenerator pgIdGenerator = new SAMFileHeader.PgIdGenerator(outputHeader);
            if (this.PROGRAM_GROUP_VERSION == null) {
                this.PROGRAM_GROUP_VERSION = this.getVersion();
            }
            if (this.PROGRAM_GROUP_COMMAND_LINE == null) {
                this.PROGRAM_GROUP_COMMAND_LINE = this.getCommandLine();
            }
            chainedPgIds = new HashMap<String, String>();
            for (String existingId : this.pgIdsSeen) {
                String newPgId = pgIdGenerator.getNonCollidingId(this.PROGRAM_RECORD_ID);
                chainedPgIds.put(existingId, newPgId);
                SAMProgramRecord programRecord = new SAMProgramRecord(newPgId);
                programRecord.setProgramVersion(this.PROGRAM_GROUP_VERSION);
                programRecord.setCommandLine(this.PROGRAM_GROUP_COMMAND_LINE);
                programRecord.setProgramName(this.PROGRAM_GROUP_NAME);
                programRecord.setPreviousProgramGroupId(existingId);
                outputHeader.addProgramRecord(programRecord);
            }
        } else {
            chainedPgIds = null;
        }
        return chainedPgIds;
    }

    protected void finalizeAndWriteMetrics(LibraryIdGenerator libraryIdGenerator) {
        Map<String, DuplicationMetrics> metricsByLibrary = libraryIdGenerator.getMetricsByLibraryMap();
        Histogram<Short> opticalDuplicatesByLibraryId = libraryIdGenerator.getOpticalDuplicatesByLibraryIdMap();
        Map<String, Short> libraryIds = libraryIdGenerator.getLibraryIdsMap();
        MetricsFile file = this.getMetricsFile();
        for (Map.Entry<String, DuplicationMetrics> entry : metricsByLibrary.entrySet()) {
            Histogram.Bin bin;
            String libraryName = entry.getKey();
            DuplicationMetrics metrics = entry.getValue();
            metrics.READ_PAIRS_EXAMINED /= 2L;
            metrics.READ_PAIR_DUPLICATES /= 2L;
            Short libraryId = libraryIds.get(libraryName);
            if (libraryId != null && (bin = (Histogram.Bin)opticalDuplicatesByLibraryId.get((Object)libraryId)) != null) {
                metrics.READ_PAIR_OPTICAL_DUPLICATES = (long)bin.getValue();
            }
            metrics.calculateDerivedMetrics();
            file.addMetric((MetricBase)metrics);
        }
        if (metricsByLibrary.size() == 1) {
            file.setHistogram(metricsByLibrary.values().iterator().next().calculateRoiHistogram());
        }
        file.write(this.METRICS_FILE);
    }

    protected SamHeaderAndIterator openInputs() {
        ArrayList<SAMFileHeader> headers = new ArrayList<SAMFileHeader>(this.INPUT.size());
        ArrayList<SamReader> readers = new ArrayList<SamReader>(this.INPUT.size());
        for (String input : this.INPUT) {
            SamReader reader = SamReaderFactory.makeDefault().enable(new SamReaderFactory.Option[]{SamReaderFactory.Option.EAGERLY_DECODE}).open(SamInputResource.of((String)input));
            SAMFileHeader header = reader.getFileHeader();
            if (!this.ASSUME_SORTED && header.getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
                throw new PicardException("Input file " + input + " is not coordinate sorted.");
            }
            headers.add(header);
            readers.add(reader);
        }
        if (headers.size() == 1) {
            return new SamHeaderAndIterator((SAMFileHeader)headers.get(0), (CloseableIterator<SAMRecord>)((SamReader)readers.get(0)).iterator());
        }
        SamFileHeaderMerger headerMerger = new SamFileHeaderMerger(SAMFileHeader.SortOrder.coordinate, headers, false);
        MergingSamRecordIterator iterator = new MergingSamRecordIterator(headerMerger, readers, this.ASSUME_SORTED);
        return new SamHeaderAndIterator(headerMerger.getMergedHeader(), (CloseableIterator<SAMRecord>)iterator);
    }

    public static void trackOpticalDuplicates(List<? extends ReadEnds> ends, OpticalDuplicateFinder opticalDuplicateFinder, LibraryIdGenerator libraryIdGenerator) {
        boolean hasFR = false;
        boolean hasRF = false;
        for (ReadEnds readEnds : ends) {
            if (3 == readEnds.orientationForOpticalDuplicates) {
                hasFR = true;
                continue;
            }
            if (5 != readEnds.orientationForOpticalDuplicates) continue;
            hasRF = true;
        }
        if (hasFR && hasRF) {
            ArrayList<ReadEnds> trackOpticalDuplicatesF = new ArrayList<ReadEnds>();
            ArrayList<ReadEnds> arrayList = new ArrayList<ReadEnds>();
            for (ReadEnds readEnds : ends) {
                if (3 == readEnds.orientationForOpticalDuplicates) {
                    trackOpticalDuplicatesF.add(readEnds);
                    continue;
                }
                if (5 == readEnds.orientationForOpticalDuplicates) {
                    arrayList.add(readEnds);
                    continue;
                }
                throw new PicardException("Found an unexpected orientation: " + readEnds.orientation);
            }
            AbstractMarkDuplicatesCommandLineProgram.trackOpticalDuplicates(trackOpticalDuplicatesF, opticalDuplicateFinder, libraryIdGenerator.getOpticalDuplicatesByLibraryIdMap());
            AbstractMarkDuplicatesCommandLineProgram.trackOpticalDuplicates(arrayList, opticalDuplicateFinder, libraryIdGenerator.getOpticalDuplicatesByLibraryIdMap());
        } else {
            AbstractMarkDuplicatesCommandLineProgram.trackOpticalDuplicates(ends, opticalDuplicateFinder, libraryIdGenerator.getOpticalDuplicatesByLibraryIdMap());
        }
    }

    private static void trackOpticalDuplicates(List<? extends OpticalDuplicateFinder.PhysicalLocation> list, OpticalDuplicateFinder opticalDuplicateFinder, Histogram<Short> opticalDuplicatesByLibraryId) {
        boolean[] opticalDuplicateFlags = opticalDuplicateFinder.findOpticalDuplicates(list);
        int opticalDuplicates = 0;
        for (boolean b : opticalDuplicateFlags) {
            if (!b) continue;
            ++opticalDuplicates;
        }
        if (opticalDuplicates > 0) {
            opticalDuplicatesByLibraryId.increment((Comparable)Short.valueOf(list.get(0).getLibraryId()), (double)opticalDuplicates);
        }
    }

    public static final class SamHeaderAndIterator {
        public final SAMFileHeader header;
        public final CloseableIterator<SAMRecord> iterator;

        public SamHeaderAndIterator(SAMFileHeader header, CloseableIterator<SAMRecord> iterator) {
            this.header = header;
            this.iterator = iterator;
        }
    }
}

