/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.artifacts;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.filter.AggregateFilter;
import htsjdk.samtools.filter.AlignedFilter;
import htsjdk.samtools.filter.DuplicateReadFilter;
import htsjdk.samtools.filter.FailsVendorReadQualityFilter;
import htsjdk.samtools.filter.InsertSizeFilter;
import htsjdk.samtools.filter.MappingQualityFilter;
import htsjdk.samtools.filter.NotPrimaryAlignmentFilter;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.CodeUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.IntervalListReferenceSequenceMask;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import picard.PicardException;
import picard.analysis.SinglePassSamProgram;
import picard.analysis.artifacts.ArtifactCounter;
import picard.analysis.artifacts.SequencingArtifactMetrics;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.util.DbSnpBitSetUtil;

@CommandLineProgramProperties(usage="Collect metrics to quantify single-base sequencing artifacts.", usageShort="Collect metrics to quantify single-base sequencing artifacts.", programGroup=Metrics.class)
public class CollectSequencingArtifactMetrics
extends SinglePassSamProgram {
    static final String USAGE = "Collect metrics to quantify single-base sequencing artifacts.";
    @Option(doc="An optional list of intervals to restrict analysis to.", optional=true)
    public File INTERVALS;
    @Option(doc="VCF format dbSNP file, used to exclude regions around known polymorphisms from analysis.", optional=true)
    public File DB_SNP;
    @Option(shortName="Q", doc="The minimum base quality score for a base to be included in analysis.")
    public int MINIMUM_QUALITY_SCORE = 20;
    @Option(shortName="MQ", doc="The minimum mapping quality score for a base to be included in analysis.")
    public int MINIMUM_MAPPING_QUALITY = 30;
    @Option(shortName="MIN_INS", doc="The minimum insert size for a read to be included in analysis.")
    public int MINIMUM_INSERT_SIZE = 60;
    @Option(shortName="MAX_INS", doc="The maximum insert size for a read to be included in analysis. Set to 0 to have no maximum.")
    public int MAXIMUM_INSERT_SIZE = 600;
    @Option(shortName="UNPAIRED", doc="Include unpaired reads. If set to true then all paired reads will be included as well - MINIMUM_INSERT_SIZE and MAXIMUM_INSERT_SIZE will be ignored.")
    public boolean INCLUDE_UNPAIRED = false;
    @Option(shortName="TANDEM", doc="Set to true if mate pairs are being sequenced from the same strand, i.e. they're expected to face the same direction.")
    public boolean TANDEM_READS = false;
    @Option(doc="When available, use original quality scores for filtering.")
    public boolean USE_OQ = true;
    @Option(doc="The number of context bases to include on each side of the assayed base.")
    public int CONTEXT_SIZE = 1;
    @Option(doc="If specified, only print results for these contexts in the detail metrics output. However, the summary metrics output will still take all contexts into consideration.")
    public Set<String> CONTEXTS_TO_PRINT = new HashSet<String>();
    private static final String UNKNOWN_LIBRARY = "UnknownLibrary";
    private static final String UNKNOWN_SAMPLE = "UnknownSample";
    private File preAdapterSummaryOut;
    private File preAdapterDetailsOut;
    private File baitBiasSummaryOut;
    private File baitBiasDetailsOut;
    private IntervalListReferenceSequenceMask intervalMask;
    private DbSnpBitSetUtil dbSnpMask;
    private SamRecordFilter recordFilter;
    private final Set<String> samples = new HashSet<String>();
    private final Set<String> libraries = new HashSet<String>();
    private final Map<String, ArtifactCounter> artifactCounters = new HashMap<String, ArtifactCounter>();

    public static void main(String[] args) {
        new CollectSequencingArtifactMetrics().instanceMainWithExit(args);
    }

    @Override
    protected String[] customCommandLineValidation() {
        ArrayList<String> messages = new ArrayList<String>();
        int contextFullLength = 2 * this.CONTEXT_SIZE + 1;
        if (this.CONTEXT_SIZE < 0) {
            messages.add("CONTEXT_SIZE cannot be negative");
        }
        for (String context : this.CONTEXTS_TO_PRINT) {
            if (context.length() == contextFullLength) continue;
            messages.add("Context " + context + " is not the length implied by CONTEXT_SIZE: " + contextFullLength);
        }
        if (this.MINIMUM_INSERT_SIZE < 0) {
            messages.add("MINIMUM_INSERT_SIZE cannot be negative");
        }
        if (this.MAXIMUM_INSERT_SIZE < 0) {
            messages.add("MAXIMUM_INSERT_SIZE cannot be negative");
        }
        if (this.MAXIMUM_INSERT_SIZE > 0 && this.MAXIMUM_INSERT_SIZE < this.MINIMUM_INSERT_SIZE) {
            messages.add("MAXIMUM_INSERT_SIZE cannot be less than MINIMUM_INSERT_SIZE unless set to 0");
        }
        return messages.isEmpty() ? null : messages.toArray(new String[messages.size()]);
    }

    @Override
    protected void setup(SAMFileHeader header, File samFile) {
        this.preAdapterSummaryOut = new File(this.OUTPUT + ".pre_adapter_summary_metrics");
        this.preAdapterDetailsOut = new File(this.OUTPUT + ".pre_adapter_detail_metrics");
        this.baitBiasSummaryOut = new File(this.OUTPUT + ".bait_bias_summary_metrics");
        this.baitBiasDetailsOut = new File(this.OUTPUT + ".bait_bias_detail_metrics");
        IOUtil.assertFileIsWritable((File)this.preAdapterSummaryOut);
        IOUtil.assertFileIsWritable((File)this.preAdapterDetailsOut);
        IOUtil.assertFileIsWritable((File)this.baitBiasSummaryOut);
        IOUtil.assertFileIsWritable((File)this.baitBiasDetailsOut);
        for (SAMReadGroupRecord rec : header.getReadGroups()) {
            this.samples.add((String)CodeUtil.getOrElse((Object)rec.getSample(), (Object)UNKNOWN_SAMPLE));
            this.libraries.add((String)CodeUtil.getOrElse((Object)rec.getLibrary(), (Object)UNKNOWN_LIBRARY));
        }
        if (this.INTERVALS != null) {
            IOUtil.assertFileIsReadable((File)this.INTERVALS);
            this.intervalMask = new IntervalListReferenceSequenceMask(IntervalList.fromFile((File)this.INTERVALS).uniqued());
        }
        if (this.DB_SNP != null) {
            IOUtil.assertFileIsReadable((File)this.DB_SNP);
            this.dbSnpMask = new DbSnpBitSetUtil(this.DB_SNP, header.getSequenceDictionary());
        }
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(new FailsVendorReadQualityFilter());
        filters.add(new NotPrimaryAlignmentFilter());
        filters.add(new DuplicateReadFilter());
        filters.add(new AlignedFilter(true));
        filters.add(new MappingQualityFilter(this.MINIMUM_MAPPING_QUALITY));
        if (!this.INCLUDE_UNPAIRED) {
            int effectiveMaxInsertSize = this.MAXIMUM_INSERT_SIZE == 0 ? Integer.MAX_VALUE : this.MAXIMUM_INSERT_SIZE;
            filters.add(new InsertSizeFilter(this.MINIMUM_INSERT_SIZE, effectiveMaxInsertSize));
        }
        this.recordFilter = new AggregateFilter(filters);
        String sampleAlias = StringUtil.join((String)",", new ArrayList<String>(this.samples));
        for (String library : this.libraries) {
            this.artifactCounters.put(library, new ArtifactCounter(sampleAlias, library, this.CONTEXT_SIZE, this.TANDEM_READS));
        }
    }

    @Override
    protected void acceptRead(SAMRecord rec, ReferenceSequence ref) {
        String library;
        if (this.recordFilter.filterOut(rec)) {
            return;
        }
        String string = library = rec.getReadGroup() == null ? UNKNOWN_LIBRARY : (String)CodeUtil.getOrElse((Object)rec.getReadGroup().getLibrary(), (Object)UNKNOWN_LIBRARY);
        if (!this.libraries.contains(library)) {
            throw new PicardException("Record contains library that is missing from header: " + library);
        }
        for (AlignmentBlock block : rec.getAlignmentBlocks()) {
            for (int offset = 0; offset < block.getLength(); ++offset) {
                char readBase;
                String context;
                int readPos = block.getReadStart() + offset;
                int refPos = block.getReferenceStart() + offset;
                if (this.intervalMask != null && !this.intervalMask.get(ref.getContigIndex(), refPos) || this.dbSnpMask != null && this.dbSnpMask.isDbSnpSite(ref.getName(), refPos)) continue;
                int contextStartIndex = refPos - this.CONTEXT_SIZE - 1;
                int contextFullLength = 2 * this.CONTEXT_SIZE + 1;
                if (contextStartIndex < 0 || contextStartIndex + contextFullLength > ref.length() || (context = StringUtil.bytesToString((byte[])ref.getBases(), (int)contextStartIndex, (int)contextFullLength).toUpperCase()).contains("N") || this.failsBaseQualityCutoff(readPos, rec) || (readBase = Character.toUpperCase((char)rec.getReadBases()[readPos - 1])) == 'N') continue;
                this.artifactCounters.get(library).countRecord(context, readBase, rec);
            }
        }
    }

    @Override
    protected void finish() {
        MetricsFile preAdapterSummaryMetricsFile = this.getMetricsFile();
        MetricsFile preAdapterDetailMetricsFile = this.getMetricsFile();
        MetricsFile baitBiasSummaryMetricsFile = this.getMetricsFile();
        MetricsFile baitBiasDetailMetricsFile = this.getMetricsFile();
        for (ArtifactCounter counter : this.artifactCounters.values()) {
            counter.finish();
            preAdapterSummaryMetricsFile.addAllMetrics(counter.getPreAdapterSummaryMetrics());
            baitBiasSummaryMetricsFile.addAllMetrics(counter.getBaitBiasSummaryMetrics());
            for (SequencingArtifactMetrics.PreAdapterDetailMetrics preAdapterDetailMetrics : counter.getPreAdapterDetailMetrics()) {
                if (this.CONTEXTS_TO_PRINT.size() != 0 && !this.CONTEXTS_TO_PRINT.contains(preAdapterDetailMetrics.CONTEXT)) continue;
                preAdapterDetailMetricsFile.addMetric((MetricBase)preAdapterDetailMetrics);
            }
            for (SequencingArtifactMetrics.BaitBiasDetailMetrics baitBiasDetailMetrics : counter.getBaitBiasDetailMetrics()) {
                if (this.CONTEXTS_TO_PRINT.size() != 0 && !this.CONTEXTS_TO_PRINT.contains(baitBiasDetailMetrics.CONTEXT)) continue;
                baitBiasDetailMetricsFile.addMetric((MetricBase)baitBiasDetailMetrics);
            }
        }
        preAdapterDetailMetricsFile.write(this.preAdapterDetailsOut);
        preAdapterSummaryMetricsFile.write(this.preAdapterSummaryOut);
        baitBiasDetailMetricsFile.write(this.baitBiasDetailsOut);
        baitBiasSummaryMetricsFile.write(this.baitBiasSummaryOut);
    }

    @Override
    protected boolean usesNoRefReads() {
        return false;
    }

    private boolean failsBaseQualityCutoff(int oneIndexedPos, SAMRecord rec) {
        byte qual = this.USE_OQ && rec.getOriginalBaseQualities() != null ? rec.getOriginalBaseQualities()[oneIndexedPos - 1] : rec.getBaseQualities()[oneIndexedPos - 1];
        return qual < this.MINIMUM_QUALITY_SCORE;
    }
}

