/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.List;
import java.util.Set;
import picard.analysis.AlignmentSummaryMetricsCollector;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.SinglePassSamProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.util.IlluminaUtil;

@CommandLineProgramProperties(usage="Produces a file containing summary alignment metrics from a SAM or BAM.<br /><h4>Usage example:</h4><pre>    java -jar picard.jar CollectAlignmentMetrics \\<br />        R=reference.fasta \\<br />        I=input.bam \\<br />        O=output.txt</pre><hr />", usageShort="Produces a file containing summary alignment metrics from a SAM or BAM.", programGroup=Metrics.class)
public class CollectAlignmentSummaryMetrics
extends SinglePassSamProgram {
    static final String USAGE_SUMMARY = "Produces a file containing summary alignment metrics from a SAM or BAM.";
    static final String USAGE_DETAILS = "<br /><h4>Usage example:</h4><pre>    java -jar picard.jar CollectAlignmentMetrics \\<br />        R=reference.fasta \\<br />        I=input.bam \\<br />        O=output.txt</pre><hr />";
    private static final Log log = Log.getInstance(CollectAlignmentSummaryMetrics.class);
    @Option(doc="Paired end reads above this insert size will be considered chimeric along with inter-chromosomal pairs.")
    public int MAX_INSERT_SIZE = 100000;
    @Option(doc="List of adapter sequences to use when processing the alignment metrics")
    public List<String> ADAPTER_SEQUENCE = CollectionUtil.makeList((Object[])new String[]{IlluminaUtil.IlluminaAdapterPair.SINGLE_END.get5PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.SINGLE_END.get3PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.PAIRED_END.get5PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.PAIRED_END.get3PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.INDEXED.get5PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.INDEXED.get3PrimeAdapter()});
    @Option(shortName="LEVEL", doc="The level(s) at which to accumulate metrics.  ")
    private Set<MetricAccumulationLevel> METRIC_ACCUMULATION_LEVEL = CollectionUtil.makeSet((Object[])new MetricAccumulationLevel[]{MetricAccumulationLevel.ALL_READS});
    @Option(shortName="BS", doc="Whether the SAM or BAM file consists of bisulfite sequenced reads.  ")
    public boolean IS_BISULFITE_SEQUENCED = false;
    @Option(shortName="R", doc="Reference sequence file. Note that while this argument isn't required, without it only a small subset of the metrics will be calculated.", optional=true, overridable=true)
    public File REFERENCE_SEQUENCE = Defaults.REFERENCE_FASTA;
    private AlignmentSummaryMetricsCollector collector;

    public static void main(String[] argv) {
        new CollectAlignmentSummaryMetrics().instanceMainWithExit(argv);
    }

    protected final int testDoWork() {
        return this.doWork();
    }

    @Override
    protected void setup(SAMFileHeader header, File samFile) {
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        if (header.getSequenceDictionary().isEmpty()) {
            log.warn(new Object[]{this.INPUT.getAbsoluteFile() + " has no sequence dictionary.  If any reads " + "in the file are aligned then alignment summary metrics collection will fail."});
        }
        boolean doRefMetrics = this.REFERENCE_SEQUENCE != null;
        this.collector = new AlignmentSummaryMetricsCollector(this.METRIC_ACCUMULATION_LEVEL, header.getReadGroups(), doRefMetrics, this.ADAPTER_SEQUENCE, this.MAX_INSERT_SIZE, this.IS_BISULFITE_SEQUENCED);
    }

    @Override
    protected void acceptRead(SAMRecord rec, ReferenceSequence ref) {
        this.collector.acceptRecord(rec, ref);
    }

    @Override
    protected void finish() {
        this.collector.finish();
        MetricsFile file = this.getMetricsFile();
        this.collector.addAllLevelsToFile(file);
        file.write(this.OUTPUT);
    }
}

