/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.igsp.gkde.format;

import edu.duke.igsp.gkde.format.DensityWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;

public class WiggleDensityWriter
implements DensityWriter {
    private BufferedWriter bw;
    private int _step;
    private NumberFormat nf;
    private int _step_cursor;

    public WiggleDensityWriter(File f, String chr, long start, int step) throws IOException {
        this.bw = new BufferedWriter(new FileWriter(f));
        this.bw.write("fixedStep chrom=" + chr + " start=" + ++start + " step=" + step + "\n");
        this._step = step;
        this._step_cursor = (int)start;
        this.nf = NumberFormat.getNumberInstance();
        this.nf.setGroupingUsed(false);
        this.nf.setMaximumFractionDigits(4);
        this.nf.setMinimumFractionDigits(4);
    }

    public void writeDensity(float[] batch, int start, int length) throws IOException {
        int end = start + length;
        for (int i = start; i < end; ++i) {
            if (this._step_cursor % this._step == 0) {
                this.bw.write(this.nf.format(batch[i]) + "\n");
                this._step_cursor = 0;
            }
            ++this._step_cursor;
        }
    }

    public void close() throws IOException {
        this.bw.close();
    }

    public void setThreshold(float threshold) {
    }
}

