/*
 * Decompiled with CFR 0.152.
 */
package org.halophiles.assembly;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.halophiles.assembly.Contig;

public class ContigTerminal {
    public static final String START = "_s";
    public static final String END = "_e";
    private String terminus;
    private Contig contig;
    private Map<ContigTerminal, Vector<Integer>> links;
    private int totalConnections;

    public ContigTerminal(Contig c, String term) {
        this.contig = c;
        this.links = new HashMap<ContigTerminal, Vector<Integer>>();
        this.terminus = term;
        this.totalConnections = 0;
    }

    public void addLink(ContigTerminal ct, int dist) {
        if (this.links.containsKey(ct)) {
            this.links.get(ct).add(dist);
        } else {
            Vector<Integer> tmp = new Vector<Integer>();
            tmp.add(dist);
            this.links.put(ct, tmp);
        }
        ++this.totalConnections;
    }

    public int hashCode() {
        return (this.contig.name + this.terminus).hashCode();
    }

    public int getDistance(ContigTerminal ct) {
        if (!this.links.containsKey(ct)) {
            return -1;
        }
        Vector<Integer> tmp = this.links.get(ct);
        int ret = 0;
        Iterator<Integer> it = tmp.iterator();
        while (it.hasNext()) {
            ret += it.next().intValue();
        }
        return ret / tmp.size();
    }

    public int nlinks(ContigTerminal ct) {
        if (this.links.containsKey(ct)) {
            return this.links.get(ct).size();
        }
        return 0;
    }

    public int numConnections() {
        return this.totalConnections;
    }

    public String getName() {
        return this.contig.name + this.terminus;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isStart() {
        return this.terminus.equals(START);
    }
}

