/*
 * Decompiled with CFR 0.152.
 */
package org.halophiles.assembly.qc;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.halophiles.assembly.Contig;
import org.halophiles.assembly.qc.MatchPoint;
import org.halophiles.assembly.qc.ReadCluster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpatialClusterer {
    static double EPS;
    static int MIN_PTS;
    public static Comparator<MatchPoint> xSort;
    public static Comparator<ReadCluster> CLUST_COMP;
    private Contig ctg1;
    private Contig ctg2;
    private TreeSet<MatchPoint> currPoints;
    private int numPoints;
    private Set<ReadCluster> readPairClusters;

    public SpatialClusterer(Contig contig1, Contig contig2) {
        this.ctg1 = contig1;
        this.ctg2 = contig2;
        this.currPoints = new TreeSet<MatchPoint>(xSort);
        this.readPairClusters = new TreeSet<ReadCluster>(CLUST_COMP);
        this.numPoints = 0;
    }

    void exportCurrState(File file) throws IOException {
        file.createNewFile();
        PrintStream out = new PrintStream(file);
        for (MatchPoint tmp : this.currPoints) {
            out.println(tmp.x() + "\t" + Math.abs(tmp.y()) + "\t0");
        }
        for (ReadCluster tmpKc : this.readPairClusters) {
            for (MatchPoint tmp : tmpKc.getMatchPoints()) {
                out.println(tmp.x() + "\t" + Math.abs(tmp.y()) + "\t" + tmpKc.id);
            }
        }
        out.close();
    }

    public int numPoints() {
        return this.numPoints;
    }

    public boolean addMatch(int x, int y) {
        ++this.numPoints;
        return this.currPoints.add(new MatchPoint(x, y));
    }

    public void buildReadPairClusters() {
        this.locateNeighbors();
        this.runDBSCAN();
        if (this.readPairClusters.isEmpty()) {
            return;
        }
        System.out.println("[a5_qc] Found " + this.readPairClusters.size() + " initial blocks between contigs " + this.ctg1.getId() + " and " + this.ctg2.getId());
        Iterator<ReadCluster> kcIt = this.readPairClusters.iterator();
        while (kcIt.hasNext()) {
            System.out.println("        " + kcIt.next().toString());
        }
    }

    public ReadCluster[] getReadClusters() {
        ReadCluster[] ar = new ReadCluster[this.readPairClusters.size()];
        this.readPairClusters.toArray(ar);
        return ar;
    }

    public Contig getContig1() {
        return this.ctg1;
    }

    public Contig getContig2() {
        return this.ctg2;
    }

    private void locateNeighbors() {
        int i;
        MatchPoint[] matchpoints = new MatchPoint[this.currPoints.size()];
        Integer[] x_order_int = new Integer[matchpoints.length];
        Iterator<MatchPoint> it = this.currPoints.iterator();
        int[] x_order = new int[matchpoints.length];
        HashMap<MatchPoint, Integer> xref = new HashMap<MatchPoint, Integer>();
        for (int i2 = 0; i2 < matchpoints.length; ++i2) {
            matchpoints[i2] = it.next();
            x_order_int[i2] = i2;
        }
        MatchComparator mcx = new MatchComparator(0, matchpoints);
        Arrays.sort(x_order_int, mcx);
        for (i = 0; i < x_order.length; ++i) {
            x_order[i] = x_order_int[i];
            xref.put(matchpoints[x_order[i]], i);
        }
        for (i = 0; i < matchpoints.length; ++i) {
            int j_x;
            int i_in_x = (Integer)xref.get(matchpoints[i]);
            for (j_x = i_in_x + 1; j_x < x_order.length && (double)(matchpoints[x_order[j_x]].x() - matchpoints[i].x()) <= EPS; ++j_x) {
                if (!((double)Math.abs(matchpoints[x_order[j_x]].y() - matchpoints[i].y()) <= EPS)) continue;
                matchpoints[i].addNeighbor(matchpoints[x_order[j_x]]);
            }
            for (j_x = i_in_x - 1; j_x >= 0 && (double)(matchpoints[i].x() - matchpoints[x_order[j_x]].x()) <= EPS; --j_x) {
                if (!((double)Math.abs(matchpoints[x_order[j_x]].y() - matchpoints[i].y()) <= EPS)) continue;
                matchpoints[i].addNeighbor(matchpoints[x_order[j_x]]);
            }
        }
    }

    private void runDBSCAN() {
        Iterator<MatchPoint> it = this.currPoints.iterator();
        TreeSet<MatchPoint> currClust = null;
        MatchPoint tmp = null;
        while (it.hasNext()) {
            tmp = it.next();
            if (tmp.isVisited()) continue;
            if (tmp.size() < MIN_PTS) {
                tmp.setNoise();
                tmp.setAssigned();
            } else {
                currClust = new TreeSet<MatchPoint>(xSort);
                this.expandClusters(tmp, currClust);
                this.readPairClusters.add(new ReadCluster(currClust));
            }
            tmp.setVisited();
        }
    }

    private void expandClusters(MatchPoint p, Set<MatchPoint> clust) {
        clust.add(p);
        p.setAssigned();
        Vector<MatchPoint> neighbors = new Vector<MatchPoint>(p.getNeighbors());
        for (int i = 0; i < neighbors.size(); ++i) {
            MatchPoint tmp = neighbors.get(i);
            if (!tmp.isVisited()) {
                tmp.setVisited();
                if (tmp.size() >= MIN_PTS) {
                    neighbors.addAll(tmp.getNeighbors());
                }
            }
            if (tmp.isAssigned()) continue;
            clust.add(tmp);
            tmp.setAssigned();
        }
    }

    static {
        MIN_PTS = 10;
        xSort = new Comparator<MatchPoint>(){

            @Override
            public int compare(MatchPoint arg0, MatchPoint arg1) {
                if (arg0.x() == arg1.x()) {
                    return arg0.y() - arg1.y();
                }
                return arg0.x() - arg1.x();
            }
        };
        CLUST_COMP = new Comparator<ReadCluster>(){

            @Override
            public int compare(ReadCluster arg0, ReadCluster arg1) {
                return arg0.xMax - arg1.xMax;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MatchComparator
    implements Comparator<Integer> {
        int contig;
        MatchPoint[] matches;

        public MatchComparator(int contig, MatchPoint[] matches) {
            this.contig = contig;
            this.matches = matches;
        }

        @Override
        public int compare(Integer a, Integer b) {
            if (this.contig == 0) {
                return this.matches[a].x() - this.matches[b].x();
            }
            return this.matches[a].y() - this.matches[b].y();
        }
    }
}

