/*
 * Decompiled with CFR 0.152.
 */
package org.halophiles.assembly;

import java.util.HashMap;
import java.util.Map;
import org.halophiles.assembly.ContigTerminal;
import org.halophiles.assembly.ReadPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Contig
implements Comparable<Contig> {
    private static int CTG_COUNT = 0;
    private static int CONCAT_START = 1;
    private ContigTerminal start;
    private ContigTerminal end;
    private int id;
    private int rankId;
    public String name;
    public int len;
    private double cov = 0.0;
    private int concat_start;
    private Map<Contig, Integer> counts;
    public int numSelfConnect;
    private Map<String, ReadPair> reads;
    private double mappedBasesCount;
    private int mappedReadCount;
    private int out;
    private int in;

    public Contig(String name, int len) {
        this(name);
        this.len = len;
        this.concat_start = CONCAT_START;
        CONCAT_START += len;
    }

    public Contig(String name) {
        this.name = name;
        this.id = CTG_COUNT + 1;
        this.len = -1;
        this.concat_start = -1;
        this.rankId = this.id;
        this.cov = -1.0;
        this.numSelfConnect = 0;
        this.counts = new HashMap<Contig, Integer>();
        this.reads = new HashMap<String, ReadPair>();
        ++CTG_COUNT;
        this.mappedBasesCount = 0.0;
        this.mappedReadCount = 0;
        this.start = new ContigTerminal(this, "_s");
        this.end = new ContigTerminal(this, "_e");
        this.out = 0;
        this.in = 0;
    }

    public void addOut() {
        ++this.out;
    }

    public int getOut() {
        return this.out;
    }

    public void addIn() {
        ++this.in;
    }

    public int getIn() {
        return this.in;
    }

    public double getCov() {
        if (this.len == -1) {
            return -1.0;
        }
        return this.mappedBasesCount / (double)this.len;
    }

    public boolean hasCov() {
        return this.cov != 0.0;
    }

    public boolean equals(Contig c) {
        if (c == null) {
            System.out.print("");
        } else if (c.name == null) {
            System.out.print("");
        } else if (this.name == null) {
            System.out.print("");
        }
        return this.name.equals(c.name);
    }

    public void addLink(Contig c) {
        if (!this.counts.containsKey(c)) {
            this.counts.put(c, 1);
        } else {
            this.counts.put(c, this.counts.get(c) + 1);
        }
    }

    public int nLinks(Contig c) {
        if (!this.counts.containsKey(c)) {
            return 0;
        }
        return this.counts.get(c);
    }

    public int numReads() {
        return this.mappedReadCount;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public void addEndSpanningPair() {
        ++this.numSelfConnect;
    }

    public int getConcatCoord(int pos) {
        return this.concat_start + pos - 1;
    }

    @Override
    public int compareTo(Contig arg0) {
        return this.name.compareTo(arg0.name);
    }

    public void addRead(int len) {
        this.mappedBasesCount += (double)len;
        ++this.mappedReadCount;
    }

    public void removeReadPair(String readHdr) {
        this.reads.remove(readHdr);
    }

    public int getNumLinkedContigs() {
        return this.counts.size();
    }

    public int getNumLinks(Contig c) {
        return this.counts.get(c);
    }

    public int getId() {
        return this.id;
    }

    public void setRank(int id) {
        this.rankId = id;
    }

    public int getRank() {
        return this.rankId;
    }

    public ContigTerminal getStartTerminus() {
        return this.start;
    }

    public ContigTerminal getEndTerminus() {
        return this.end;
    }
}

