    \name{peakbound}
          \Rdversion{1.0}
          \alias{peakbound}
          \title{Refine Peak Boundaries from SBC Collapsed Significant Regions}
          \description{
            Takes SBC from bpout file line by line and determines exact peak boundaries, outputting them to a final peak file containing coordinates of collapsed and refined regions, in addition to the location of the max value in refined region and max value.
          }
          \usage{peakbound(bpprofile,output,pwinSize=200, winSize,quantile=.75,minscore=0)}
          \arguments{
            \item{bpprofile}{path to file that holds matrix of overlap information generated by basecountimport}
	    \item{output}{specify file name/path for output file that holds refined peaks}
	    \item{winSize}{window size, default=500bp}
            \item{pWinSize}{In the peak refinement step, reduce this parameter to get more sensitivity to detect local Maximums, default is 200.  This may increase false positives}
	    \item{method}{method used to generate files in winlist, either mixture or pscl}
	    \item{pquant}{In the peak refinement step, filters out local maximums whose height is lower than the 'pquant' quantile in the window. Use pquant=1 for selecting only the global max in a collapsed region, god for ChIP-seq datasets.  Default is .75}
	    \item{minscore}{minimum max height threshold for significant windows, filters out windows with max values below this point}
}
          \seealso{
            \code{\link{save}}.
          }
          \examples{
	   #FAIRE-seq with recommended parameters, no input.  
	   peakbound(bpprofile='FAIRE/faireresults.bpout',output='FAIRE/faireresults.peaks',winSize=250,pWinSize=200,pquant=1, minscore=5)
   
          }
          \keyword{file}
